/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import io.debezium.config.Configuration;
import io.debezium.connector.common.RelationalBaseSourceConnector;
import io.debezium.connector.sqlserver.Module;
import io.debezium.connector.sqlserver.SqlServerConnection;
import io.debezium.connector.sqlserver.SqlServerConnectorConfig;
import io.debezium.connector.sqlserver.SqlServerConnectorTask;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.util.Strings;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigValue;
import org.apache.kafka.connect.connector.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlServerConnector
extends RelationalBaseSourceConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlServerConnector.class);
    private Map<String, String> properties;

    public String version() {
        return Module.version();
    }

    public void start(Map<String, String> props) {
        this.properties = Collections.unmodifiableMap(new HashMap<String, String>(props));
    }

    public Class<? extends Task> taskClass() {
        return SqlServerConnectorTask.class;
    }

    public List<Map<String, String>> taskConfigs(int maxTasks) {
        if (maxTasks > 1) {
            throw new IllegalArgumentException("Only a single connector task may be started");
        }
        HashMap<String, String> taskConfig = new HashMap<String, String>(this.properties);
        Configuration config = Configuration.from(this.properties);
        SqlServerConnectorConfig sqlServerConfig = new SqlServerConnectorConfig(config);
        String databaseName = sqlServerConfig.getDatabaseName();
        try (SqlServerConnection connection = this.connect(sqlServerConfig);){
            String realDatabaseName = connection.retrieveRealDatabaseName(databaseName);
            if (!sqlServerConfig.isMultiPartitionModeEnabled()) {
                taskConfig.put(SqlServerConnectorConfig.DATABASE_NAME.name(), realDatabaseName);
            } else {
                taskConfig.put(SqlServerConnectorConfig.DATABASE_NAMES.name(), realDatabaseName);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Could not retrieve real database name", e);
        }
        return Collections.singletonList(taskConfig);
    }

    public void stop() {
    }

    public ConfigDef config() {
        return SqlServerConnectorConfig.configDef();
    }

    protected void validateConnection(Map<String, ConfigValue> configValues, Configuration config) {
        SqlServerConnectorConfig sqlServerConfig = new SqlServerConnectorConfig(config);
        if (Strings.isNullOrEmpty((String)sqlServerConfig.getDatabaseName())) {
            throw new IllegalArgumentException("Either '" + SqlServerConnectorConfig.DATABASE_NAME + "' or '" + SqlServerConnectorConfig.DATABASE_NAMES + "' option must be specified");
        }
        ConfigValue hostnameValue = configValues.get(RelationalDatabaseConnectorConfig.HOSTNAME.name());
        ConfigValue userValue = configValues.get(RelationalDatabaseConnectorConfig.USER.name());
        try (SqlServerConnection connection = this.connect(sqlServerConfig);){
            connection.execute(new String[]{"SELECT @@VERSION"});
            LOGGER.debug("Successfully tested connection for {} with user '{}'", (Object)connection.connectionString(), (Object)connection.username());
        }
        catch (Exception e) {
            LOGGER.error("Failed testing connection for {} with user '{}'", new Object[]{config.withMaskedPasswords(), userValue, e});
            hostnameValue.addErrorMessage("Unable to connect. Check this and other connection properties. Error: " + e.getMessage());
        }
    }

    protected Map<String, ConfigValue> validateAllFields(Configuration config) {
        return config.validate(SqlServerConnectorConfig.ALL_FIELDS);
    }

    private SqlServerConnection connect(SqlServerConnectorConfig sqlServerConfig) {
        return new SqlServerConnection(sqlServerConfig.jdbcConfig(), sqlServerConfig.getSourceTimestampMode(), null, () -> ((Object)((Object)this)).getClass().getClassLoader(), Collections.emptySet(), sqlServerConfig.isMultiPartitionModeEnabled());
    }
}

