/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.tools.cli;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.apache.inlong.tubemq.client.config.TubeClientConfig;
import org.apache.inlong.tubemq.client.factory.MessageSessionFactory;
import org.apache.inlong.tubemq.client.factory.TubeMultiSessionFactory;
import org.apache.inlong.tubemq.client.factory.TubeSingleSessionFactory;
import org.apache.inlong.tubemq.client.producer.MessageProducer;
import org.apache.inlong.tubemq.client.producer.MessageSentCallback;
import org.apache.inlong.tubemq.client.producer.MessageSentResult;
import org.apache.inlong.tubemq.corebase.Message;
import org.apache.inlong.tubemq.corebase.utils.MixedUtils;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;
import org.apache.inlong.tubemq.corebase.utils.ThreadUtils;
import org.apache.inlong.tubemq.corebase.utils.Tuple2;
import org.apache.inlong.tubemq.server.common.fielddef.CliArgDef;
import org.apache.inlong.tubemq.server.tools.cli.CliAbstractBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CliProducer
extends CliAbstractBase {
    private static final Logger logger = LoggerFactory.getLogger(CliProducer.class);
    private long startTime = System.currentTimeMillis();
    private static final AtomicLong TOTAL_COUNTER = new AtomicLong(0L);
    private static final AtomicLong SENT_SUCC_COUNTER = new AtomicLong(0L);
    private static final AtomicLong SENT_FAIL_COUNTER = new AtomicLong(0L);
    private static final AtomicLong SENT_EXCEPT_COUNTER = new AtomicLong(0L);
    private static byte[] sentData;
    private final Map<String, TreeSet<String>> topicAndFiltersMap = new HashMap<String, TreeSet<String>>();
    private static List<Tuple2<String, String>> topicSendRounds;
    private final List<MessageSessionFactory> sessionFactoryList = new ArrayList<MessageSessionFactory>();
    private final Map<MessageProducer, MsgSender> producerMap = new HashMap<MessageProducer, MsgSender>();
    private String masterServers;
    private long msgCount = -2L;
    private boolean useRandData = true;
    private int msgDataSize = 1000;
    private String payloadFilePath = null;
    private String payloadDelim = null;
    private long rpcTimeoutMs = -2L;
    private boolean reuseConn = false;
    private int clientCount = 1;
    private int sendThreadCnt = 100;
    private long printIntervalMs = 5000L;
    private boolean syncProduction = false;
    private boolean withoutDelay = false;
    private boolean isStarted = false;
    private ExecutorService sendExecutorService = null;

    public CliProducer() {
        super("tubemq-producer-test.sh");
        this.initCommandOptions();
    }

    @Override
    protected void initCommandOptions() {
        this.addCommandOption(CliArgDef.MASTERSERVER);
        this.addCommandOption(CliArgDef.MESSAGES);
        this.addCommandOption(CliArgDef.MSGDATASIZE);
        this.addCommandOption(CliArgDef.PRDTOPIC);
        this.addCommandOption(CliArgDef.RPCTIMEOUT);
        this.addCommandOption(CliArgDef.CONNREUSE);
        this.addCommandOption(CliArgDef.CLIENTCOUNT);
        this.addCommandOption(CliArgDef.OUTPUTINTERVAL);
        this.addCommandOption(CliArgDef.SYNCPRODUCE);
        this.addCommandOption(CliArgDef.SENDTHREADS);
        this.addCommandOption(CliArgDef.WITHOUTDELAY);
    }

    @Override
    public boolean processParams(String[] args) throws Exception {
        String printIntMsStr;
        String clientCntStr;
        String rpcTimeoutStr;
        String sendThreadCntStr;
        String reuseConnStr;
        String msgDataSizeStr;
        CommandLine cli = this.parser.parse(this.options, args);
        if (cli == null) {
            throw new ParseException("Parse args failure");
        }
        if (cli.hasOption(CliArgDef.VERSION.longOpt)) {
            this.version();
        }
        if (cli.hasOption(CliArgDef.HELP.longOpt)) {
            this.help();
        }
        this.masterServers = cli.getOptionValue(CliArgDef.MASTERSERVER.longOpt);
        if (TStringUtils.isBlank((String)this.masterServers)) {
            throw new Exception(CliArgDef.MASTERSERVER.longOpt + " is required!");
        }
        String topicStr = cli.getOptionValue(CliArgDef.PRDTOPIC.longOpt);
        if (TStringUtils.isBlank((String)topicStr)) {
            throw new Exception(CliArgDef.PRDTOPIC.longOpt + " is required!");
        }
        this.topicAndFiltersMap.putAll(MixedUtils.parseTopicParam((String)topicStr));
        if (this.topicAndFiltersMap.isEmpty()) {
            throw new Exception("Invalid " + CliArgDef.PRDTOPIC.longOpt + " parameter value!");
        }
        String msgCntStr = cli.getOptionValue(CliArgDef.MESSAGES.longOpt);
        if (TStringUtils.isNotBlank((String)msgCntStr)) {
            this.msgCount = Long.parseLong(msgCntStr);
        }
        if (TStringUtils.isNotBlank((String)(msgDataSizeStr = cli.getOptionValue(CliArgDef.MSGDATASIZE.longOpt)))) {
            this.msgDataSize = Integer.parseInt(msgDataSizeStr);
        }
        if (TStringUtils.isNotBlank((String)(reuseConnStr = cli.getOptionValue(CliArgDef.CONNREUSE.longOpt)))) {
            this.reuseConn = Boolean.parseBoolean(reuseConnStr);
        }
        if (TStringUtils.isNotBlank((String)(sendThreadCntStr = cli.getOptionValue(CliArgDef.SENDTHREADS.longOpt)))) {
            int tmpThreadCnt = Integer.parseInt(sendThreadCntStr);
            this.sendThreadCnt = tmpThreadCnt = MixedUtils.mid((int)tmpThreadCnt, (int)1, (int)200);
        }
        if (TStringUtils.isNotBlank((String)(rpcTimeoutStr = cli.getOptionValue(CliArgDef.RPCTIMEOUT.longOpt)))) {
            this.rpcTimeoutMs = Long.parseLong(rpcTimeoutStr);
        }
        if (TStringUtils.isNotBlank((String)(clientCntStr = cli.getOptionValue(CliArgDef.CLIENTCOUNT.longOpt)))) {
            this.clientCount = Integer.parseInt(clientCntStr);
        }
        if (TStringUtils.isNotBlank((String)(printIntMsStr = cli.getOptionValue(CliArgDef.OUTPUTINTERVAL.longOpt)))) {
            this.printIntervalMs = Long.parseLong(printIntMsStr);
            if (this.printIntervalMs < 5000L) {
                throw new Exception("Invalid " + CliArgDef.OUTPUTINTERVAL.longOpt + " parameter value!");
            }
        }
        if (cli.hasOption(CliArgDef.SYNCPRODUCE.longOpt)) {
            this.syncProduction = true;
        }
        if (cli.hasOption(CliArgDef.WITHOUTDELAY.longOpt)) {
            this.withoutDelay = true;
        }
        return true;
    }

    public void initTask() throws Exception {
        TubeClientConfig clientConfig = new TubeClientConfig(this.masterServers);
        clientConfig.setRpcTimeoutMs(this.rpcTimeoutMs);
        sentData = MixedUtils.buildTestData((int)this.msgDataSize);
        topicSendRounds = MixedUtils.buildTopicFilterTupleList(this.topicAndFiltersMap);
        this.startTime = System.currentTimeMillis();
        this.sendExecutorService = Executors.newFixedThreadPool(this.sendThreadCnt, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                return new Thread(runnable, "sender_" + CliProducer.this.producerMap.size());
            }
        });
        if (this.reuseConn) {
            TubeSingleSessionFactory msgSessionFactory = new TubeSingleSessionFactory(clientConfig);
            this.sessionFactoryList.add((MessageSessionFactory)msgSessionFactory);
            for (int i = 0; i < this.clientCount; ++i) {
                MessageProducer producer = msgSessionFactory.createProducer();
                producer.publish(this.topicAndFiltersMap.keySet());
                this.producerMap.put(producer, new MsgSender(producer));
                this.sendExecutorService.submit(this.producerMap.get(producer));
            }
        } else {
            for (int i = 0; i < this.clientCount; ++i) {
                TubeMultiSessionFactory msgSessionFactory = new TubeMultiSessionFactory(clientConfig);
                this.sessionFactoryList.add((MessageSessionFactory)msgSessionFactory);
                MessageProducer producer = msgSessionFactory.createProducer();
                producer.publish(this.topicAndFiltersMap.keySet());
                this.producerMap.put(producer, new MsgSender(producer));
                this.sendExecutorService.submit(this.producerMap.get(producer));
            }
        }
        this.isStarted = true;
    }

    public void shutdown() throws Throwable {
        if (this.sendExecutorService != null) {
            this.sendExecutorService.shutdownNow();
        }
        ThreadUtils.sleep((long)20L);
        for (MessageProducer producer : this.producerMap.keySet()) {
            producer.shutdown();
        }
        for (MessageSessionFactory messageSessionFactory : this.sessionFactoryList) {
            messageSessionFactory.shutdown();
        }
    }

    public static void main(String[] args) {
        CliProducer cliProducer = new CliProducer();
        try {
            boolean result = cliProducer.processParams(args);
            if (!result) {
                throw new Exception("Parse parameters failure!");
            }
            cliProducer.initTask();
            ThreadUtils.sleep((long)1000L);
            while (cliProducer.msgCount < 0L || TOTAL_COUNTER.get() < cliProducer.msgCount * (long)cliProducer.clientCount) {
                ThreadUtils.sleep((long)cliProducer.printIntervalMs);
                System.out.println("Continue, cost time: " + (System.currentTimeMillis() - cliProducer.startTime) + "ms, required count VS sent count = " + cliProducer.msgCount * (long)cliProducer.clientCount + " : " + TOTAL_COUNTER.get() + " (" + SENT_SUCC_COUNTER.get() + ":" + SENT_FAIL_COUNTER.get() + ":" + SENT_EXCEPT_COUNTER.get() + ")");
            }
            cliProducer.shutdown();
            System.out.println("Finished, cost time: " + (System.currentTimeMillis() - cliProducer.startTime) + "ms, required count VS sent count = " + cliProducer.msgCount * (long)cliProducer.clientCount + " : " + TOTAL_COUNTER.get() + " (" + SENT_SUCC_COUNTER.get() + ":" + SENT_FAIL_COUNTER.get() + ":" + SENT_EXCEPT_COUNTER.get() + ")");
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            logger.error(ex.getMessage());
            cliProducer.help();
        }
    }

    static {
        topicSendRounds = new ArrayList<Tuple2<String, String>>();
    }

    private class DefaultSendCallback
    implements MessageSentCallback {
        private DefaultSendCallback() {
        }

        public void onMessageSent(MessageSentResult result) {
            TOTAL_COUNTER.incrementAndGet();
            if (result.isSuccess()) {
                SENT_SUCC_COUNTER.incrementAndGet();
            } else {
                SENT_FAIL_COUNTER.incrementAndGet();
            }
        }

        public void onException(Throwable e) {
            TOTAL_COUNTER.incrementAndGet();
            SENT_EXCEPT_COUNTER.incrementAndGet();
            logger.error("Send message error!", e);
        }
    }

    public class MsgSender
    implements Runnable {
        private final MessageProducer producer;

        public MsgSender(MessageProducer producer) {
            this.producer = producer;
        }

        @Override
        public void run() {
            int topicAndCondCnt = topicSendRounds.size();
            long sentCount = 0L;
            int roundIndex = 0;
            while (CliProducer.this.msgCount < 0L || sentCount < CliProducer.this.msgCount) {
                roundIndex = (int)(sentCount++ % (long)topicAndCondCnt);
                try {
                    Tuple2 target = (Tuple2)topicSendRounds.get(roundIndex);
                    Message message = MixedUtils.buildMessage((String)((String)target.getF0()), (String)((String)target.getF1()), (byte[])sentData, (long)sentCount);
                    if (CliProducer.this.syncProduction) {
                        MessageSentResult procResult = this.producer.sendMessage(message);
                        TOTAL_COUNTER.incrementAndGet();
                        if (procResult.isSuccess()) {
                            SENT_SUCC_COUNTER.incrementAndGet();
                        } else {
                            SENT_FAIL_COUNTER.incrementAndGet();
                        }
                    } else {
                        this.producer.sendMessage(message, (MessageSentCallback)new DefaultSendCallback());
                    }
                }
                catch (Throwable e1) {
                    TOTAL_COUNTER.incrementAndGet();
                    SENT_EXCEPT_COUNTER.incrementAndGet();
                    logger.error("sendMessage exception: ", e1);
                }
                if (CliProducer.this.withoutDelay) continue;
                MixedUtils.coolSending((long)sentCount);
            }
            try {
                this.producer.shutdown();
            }
            catch (Throwable e) {
                logger.error("producer shutdown error: ", e);
            }
        }
    }
}

