/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.tools.cli;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.apache.inlong.tubemq.client.common.PeerInfo;
import org.apache.inlong.tubemq.client.config.ConsumerConfig;
import org.apache.inlong.tubemq.client.config.TubeClientConfig;
import org.apache.inlong.tubemq.client.consumer.ConsumePosition;
import org.apache.inlong.tubemq.client.consumer.ConsumerResult;
import org.apache.inlong.tubemq.client.consumer.MessageConsumer;
import org.apache.inlong.tubemq.client.consumer.MessageListener;
import org.apache.inlong.tubemq.client.consumer.PullMessageConsumer;
import org.apache.inlong.tubemq.client.consumer.PushMessageConsumer;
import org.apache.inlong.tubemq.client.exception.TubeClientException;
import org.apache.inlong.tubemq.client.factory.MessageSessionFactory;
import org.apache.inlong.tubemq.client.factory.TubeMultiSessionFactory;
import org.apache.inlong.tubemq.client.factory.TubeSingleSessionFactory;
import org.apache.inlong.tubemq.corebase.Message;
import org.apache.inlong.tubemq.corebase.TErrCodeConstants;
import org.apache.inlong.tubemq.corebase.utils.MixedUtils;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;
import org.apache.inlong.tubemq.corebase.utils.ThreadUtils;
import org.apache.inlong.tubemq.server.common.fielddef.CliArgDef;
import org.apache.inlong.tubemq.server.tools.cli.CliAbstractBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CliConsumer
extends CliAbstractBase {
    private static final Logger logger = LoggerFactory.getLogger(CliConsumer.class);
    private static final AtomicLong TOTAL_COUNTER = new AtomicLong(0L);
    private static final ConcurrentHashMap<String, AtomicLong> TOPIC_COUNT_MAP = new ConcurrentHashMap();
    private long startTime = System.currentTimeMillis();
    private final Map<String, TreeSet<String>> topicAndFiltersMap = new HashMap<String, TreeSet<String>>();
    private final List<MessageSessionFactory> sessionFactoryList = new ArrayList<MessageSessionFactory>();
    private final Map<MessageConsumer, TupleValue> consumerMap = new HashMap<MessageConsumer, TupleValue>();
    private String masterServers;
    private String groupName = "test_consume";
    private ConsumePosition consumePos = ConsumePosition.CONSUMER_FROM_LATEST_OFFSET;
    private long msgCount = -2L;
    private long rpcTimeoutMs = -2L;
    private boolean reuseConn = false;
    private int clientCount = 1;
    private int fetchThreadCnt = Runtime.getRuntime().availableProcessors();
    private long printIntervalMs = 5000L;
    private boolean isPushConsume = false;
    private boolean isStarted = false;

    public CliConsumer() {
        super("tubemq-consumer-test.sh");
        this.initCommandOptions();
    }

    @Override
    protected void initCommandOptions() {
        this.addCommandOption(CliArgDef.MASTERSERVER);
        this.addCommandOption(CliArgDef.MESSAGES);
        this.addCommandOption(CliArgDef.CNSTOPIC);
        this.addCommandOption(CliArgDef.RPCTIMEOUT);
        this.addCommandOption(CliArgDef.GROUP);
        this.addCommandOption(CliArgDef.CONNREUSE);
        this.addCommandOption(CliArgDef.PUSHCONSUME);
        this.addCommandOption(CliArgDef.CONSUMEPOS);
        this.addCommandOption(CliArgDef.FETCHTHREADS);
        this.addCommandOption(CliArgDef.CLIENTCOUNT);
        this.addCommandOption(CliArgDef.OUTPUTINTERVAL);
    }

    @Override
    public boolean processParams(String[] args) throws Exception {
        String fetchThreadCntStr;
        String consumePosStr;
        String printIntMsStr;
        String clientCntStr;
        String rpcTimeoutStr;
        String reuseConnStr;
        String groupNameStr;
        CommandLine cli = this.parser.parse(this.options, args);
        if (cli == null) {
            throw new ParseException("Parse args failure");
        }
        if (cli.hasOption(CliArgDef.VERSION.longOpt)) {
            this.version();
        }
        if (cli.hasOption(CliArgDef.HELP.longOpt)) {
            this.help();
        }
        this.masterServers = cli.getOptionValue(CliArgDef.MASTERSERVER.longOpt);
        if (TStringUtils.isBlank((String)this.masterServers)) {
            throw new Exception(CliArgDef.MASTERSERVER.longOpt + " is required!");
        }
        String topicStr = cli.getOptionValue(CliArgDef.CNSTOPIC.longOpt);
        if (TStringUtils.isBlank((String)topicStr)) {
            throw new Exception(CliArgDef.CNSTOPIC.longOpt + " is required!");
        }
        this.topicAndFiltersMap.putAll(MixedUtils.parseTopicParam((String)topicStr));
        if (this.topicAndFiltersMap.isEmpty()) {
            throw new Exception("Invalid " + CliArgDef.CNSTOPIC.longOpt + " parameter value!");
        }
        String msgCntStr = cli.getOptionValue(CliArgDef.MESSAGES.longOpt);
        if (TStringUtils.isNotBlank((String)msgCntStr)) {
            this.msgCount = Long.parseLong(msgCntStr);
        }
        if (TStringUtils.isNotBlank((String)(groupNameStr = cli.getOptionValue(CliArgDef.GROUP.longOpt)))) {
            this.groupName = cli.getOptionValue(CliArgDef.GROUP.longOpt);
        }
        if (TStringUtils.isNotBlank((String)(reuseConnStr = cli.getOptionValue(CliArgDef.CONNREUSE.longOpt)))) {
            this.reuseConn = Boolean.parseBoolean(reuseConnStr);
        }
        if (TStringUtils.isNotBlank((String)(rpcTimeoutStr = cli.getOptionValue(CliArgDef.RPCTIMEOUT.longOpt)))) {
            this.rpcTimeoutMs = Long.parseLong(rpcTimeoutStr);
        }
        if (TStringUtils.isNotBlank((String)(clientCntStr = cli.getOptionValue(CliArgDef.CLIENTCOUNT.longOpt)))) {
            this.clientCount = Integer.parseInt(clientCntStr);
        }
        if (TStringUtils.isNotBlank((String)(printIntMsStr = cli.getOptionValue(CliArgDef.OUTPUTINTERVAL.longOpt)))) {
            this.printIntervalMs = Long.parseLong(printIntMsStr);
            if (this.printIntervalMs < 5000L) {
                throw new Exception("Invalid " + CliArgDef.OUTPUTINTERVAL.longOpt + " parameter value!");
            }
        }
        if (TStringUtils.isNotBlank((String)(consumePosStr = cli.getOptionValue(CliArgDef.CONSUMEPOS.longOpt)))) {
            int tmpPosId = Integer.parseInt(consumePosStr);
            this.consumePos = tmpPosId > 0 ? ConsumePosition.CONSUMER_FROM_MAX_OFFSET_ALWAYS : (tmpPosId < 0 ? ConsumePosition.CONSUMER_FROM_FIRST_OFFSET : ConsumePosition.CONSUMER_FROM_LATEST_OFFSET);
        }
        if (cli.hasOption(CliArgDef.PUSHCONSUME.longOpt)) {
            this.isPushConsume = true;
        }
        if (TStringUtils.isNotBlank((String)(fetchThreadCntStr = cli.getOptionValue(CliArgDef.FETCHTHREADS.longOpt)))) {
            int tmpFetchThreadCnt = Integer.parseInt(fetchThreadCntStr);
            this.fetchThreadCnt = tmpFetchThreadCnt = MixedUtils.mid((int)tmpFetchThreadCnt, (int)1, (int)100);
        }
        return true;
    }

    public void initTask() throws Exception {
        ConsumerConfig consumerConfig = new ConsumerConfig(this.masterServers, this.groupName);
        consumerConfig.setRpcTimeoutMs(this.rpcTimeoutMs);
        consumerConfig.setPushFetchThreadCnt(this.fetchThreadCnt);
        consumerConfig.setConsumePosition(this.consumePos);
        this.startTime = System.currentTimeMillis();
        if (this.isPushConsume) {
            DefaultMessageListener msgListener = new DefaultMessageListener();
            if (this.reuseConn) {
                TubeSingleSessionFactory msgSessionFactory = new TubeSingleSessionFactory((TubeClientConfig)consumerConfig);
                this.sessionFactoryList.add((MessageSessionFactory)msgSessionFactory);
                for (int i = 0; i < this.clientCount; ++i) {
                    PushMessageConsumer consumer1 = msgSessionFactory.createPushConsumer(consumerConfig);
                    for (Map.Entry<String, TreeSet<String>> entry : this.topicAndFiltersMap.entrySet()) {
                        consumer1.subscribe(entry.getKey(), entry.getValue(), (MessageListener)msgListener);
                        TOPIC_COUNT_MAP.put(entry.getKey(), new AtomicLong(0L));
                    }
                    consumer1.completeSubscribe();
                    this.consumerMap.put((MessageConsumer)consumer1, null);
                }
            } else {
                for (int i = 0; i < this.clientCount; ++i) {
                    TubeMultiSessionFactory msgSessionFactory = new TubeMultiSessionFactory((TubeClientConfig)consumerConfig);
                    this.sessionFactoryList.add((MessageSessionFactory)msgSessionFactory);
                    PushMessageConsumer consumer1 = msgSessionFactory.createPushConsumer(consumerConfig);
                    for (Map.Entry<String, TreeSet<String>> entry : this.topicAndFiltersMap.entrySet()) {
                        consumer1.subscribe(entry.getKey(), entry.getValue(), (MessageListener)msgListener);
                        TOPIC_COUNT_MAP.put(entry.getKey(), new AtomicLong(0L));
                    }
                    consumer1.completeSubscribe();
                    this.consumerMap.put((MessageConsumer)consumer1, null);
                }
            }
        } else if (this.reuseConn) {
            TubeSingleSessionFactory msgSessionFactory = new TubeSingleSessionFactory((TubeClientConfig)consumerConfig);
            this.sessionFactoryList.add((MessageSessionFactory)msgSessionFactory);
            for (int i = 0; i < this.clientCount; ++i) {
                PullMessageConsumer consumer2 = msgSessionFactory.createPullConsumer(consumerConfig);
                for (Map.Entry<String, TreeSet<String>> entry : this.topicAndFiltersMap.entrySet()) {
                    consumer2.subscribe(entry.getKey(), entry.getValue());
                    TOPIC_COUNT_MAP.put(entry.getKey(), new AtomicLong(0L));
                }
                consumer2.completeSubscribe();
                this.consumerMap.put((MessageConsumer)consumer2, new TupleValue(consumer2, this.msgCount, this.fetchThreadCnt));
            }
        } else {
            for (int i = 0; i < this.clientCount; ++i) {
                TubeMultiSessionFactory msgSessionFactory = new TubeMultiSessionFactory((TubeClientConfig)consumerConfig);
                this.sessionFactoryList.add((MessageSessionFactory)msgSessionFactory);
                PullMessageConsumer consumer2 = msgSessionFactory.createPullConsumer(consumerConfig);
                for (Map.Entry<String, TreeSet<String>> entry : this.topicAndFiltersMap.entrySet()) {
                    consumer2.subscribe(entry.getKey(), entry.getValue());
                    TOPIC_COUNT_MAP.put(entry.getKey(), new AtomicLong(0L));
                }
                consumer2.completeSubscribe();
                this.consumerMap.put((MessageConsumer)consumer2, new TupleValue(consumer2, this.msgCount, this.fetchThreadCnt));
            }
        }
        this.isStarted = true;
    }

    public void shutdown() throws Throwable {
        ThreadUtils.sleep((long)20L);
        for (MessageConsumer consumer : this.consumerMap.keySet()) {
            consumer.shutdown();
        }
        for (MessageSessionFactory messageSessionFactory : this.sessionFactoryList) {
            messageSessionFactory.shutdown();
        }
    }

    public static void main(String[] args) {
        CliConsumer cliConsumer = new CliConsumer();
        try {
            boolean result = cliConsumer.processParams(args);
            if (!result) {
                throw new Exception("Parse parameters failure!");
            }
            cliConsumer.initTask();
            ThreadUtils.sleep((long)1000L);
            while (cliConsumer.msgCount < 0L || TOTAL_COUNTER.get() < cliConsumer.msgCount * (long)cliConsumer.clientCount) {
                ThreadUtils.sleep((long)cliConsumer.printIntervalMs);
                System.out.println("Continue, cost time: " + (System.currentTimeMillis() - cliConsumer.startTime) + " ms, required count VS received count = " + cliConsumer.msgCount * (long)cliConsumer.clientCount + " : " + TOTAL_COUNTER.get());
                for (Map.Entry<String, AtomicLong> entry : TOPIC_COUNT_MAP.entrySet()) {
                    System.out.println("Topic Name = " + entry.getKey() + ", count=" + entry.getValue().get());
                }
            }
            cliConsumer.shutdown();
            System.out.println("Finished, cost time: " + (System.currentTimeMillis() - cliConsumer.startTime) + " ms, required count VS received count = " + cliConsumer.msgCount * (long)cliConsumer.clientCount + " : " + TOTAL_COUNTER.get());
            for (Map.Entry<String, AtomicLong> entry : TOPIC_COUNT_MAP.entrySet()) {
                System.out.println("Topic Name = " + entry.getKey() + ", count=" + entry.getValue().get());
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            logger.error(ex.getMessage());
            cliConsumer.help();
        }
    }

    private static class FetchRequestRunner
    implements Runnable {
        private final PullMessageConsumer messageConsumer;
        private final long msgConsumeCnt;

        FetchRequestRunner(PullMessageConsumer messageConsumer, long msgConsumeCnt) {
            this.messageConsumer = messageConsumer;
            this.msgConsumeCnt = msgConsumeCnt;
        }

        @Override
        public void run() {
            try {
                do {
                    ConsumerResult result;
                    if ((result = this.messageConsumer.getMessage()).isSuccess()) {
                        List messageList = result.getMessageList();
                        if (messageList != null && !messageList.isEmpty()) {
                            int msgCnt = messageList.size();
                            TOTAL_COUNTER.addAndGet(msgCnt);
                            AtomicLong accCount = (AtomicLong)TOPIC_COUNT_MAP.get(result.getTopicName());
                            accCount.addAndGet(msgCnt);
                        }
                        this.messageConsumer.confirmConsume(result.getConfirmContext(), true);
                        continue;
                    }
                    if (TErrCodeConstants.IGNORE_ERROR_SET.contains(result.getErrCode())) continue;
                    logger.info("Receive messages errorCode is {}, Error message is {}", (Object)result.getErrCode(), (Object)result.getErrMsg());
                    if (this.messageConsumer.isShutdown()) break;
                } while (this.msgConsumeCnt < 0L || TOTAL_COUNTER.get() < this.msgConsumeCnt);
            }
            catch (TubeClientException e) {
                logger.error("Create consumer failed!", (Throwable)e);
            }
        }
    }

    private static class DefaultMessageListener
    implements MessageListener {
        public void receiveMessages(PeerInfo peerInfo, List<Message> messages) {
            if (messages != null && !messages.isEmpty()) {
                int msgCnt = messages.size();
                Message message = messages.get(0);
                TOTAL_COUNTER.addAndGet(msgCnt);
                AtomicLong accCount = (AtomicLong)TOPIC_COUNT_MAP.get(message.getTopic());
                accCount.addAndGet(msgCnt);
            }
        }

        public Executor getExecutor() {
            return null;
        }

        public void stop() {
        }
    }

    private static class TupleValue {
        public Thread[] fetchRunners = null;

        public TupleValue(PullMessageConsumer consumer, long msgCount, int fetchThreadCnt) {
            this.fetchRunners = new Thread[fetchThreadCnt];
            for (int i = 0; i < this.fetchRunners.length; ++i) {
                this.fetchRunners[i] = new Thread(new FetchRequestRunner(consumer, msgCount));
                this.fetchRunners[i].setName("_fetch_runner_" + i);
            }
            for (Thread thread : this.fetchRunners) {
                thread.start();
            }
        }
    }
}

