/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.tools.cli;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import org.apache.inlong.tubemq.server.tools.cli.AbstractCommandRunner;

public abstract class AbstractCommand {
    protected final JCommander jcommander = new JCommander();
    @Parameter(names={"-h", "--help"}, help=true, hidden=true)
    private boolean help;

    public AbstractCommand(String cmdName) {
        this.jcommander.setProgramName("tubectl " + cmdName);
    }

    public boolean run(String[] args) {
        if (this.help) {
            this.jcommander.usage();
            return true;
        }
        try {
            this.jcommander.parse(args);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            this.jcommander.usage();
            return false;
        }
        String cmd = this.jcommander.getParsedCommand();
        if (cmd == null) {
            this.jcommander.usage();
            return false;
        }
        JCommander obj = (JCommander)this.jcommander.getCommands().get(cmd);
        AbstractCommandRunner commandRunner = (AbstractCommandRunner)obj.getObjects().get(0);
        try {
            commandRunner.run();
            return true;
        }
        catch (ParameterException e) {
            System.err.println(e.getMessage() + System.lineSeparator());
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

