/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.web.simplemvc;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.servlet.MultipartConfigElement;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;
import org.apache.inlong.tubemq.server.master.web.simplemvc.MultipartHttpServletRequest;
import org.apache.inlong.tubemq.server.master.web.simplemvc.RequestContext;
import org.apache.inlong.tubemq.server.master.web.simplemvc.RequestDispatcher;
import org.apache.inlong.tubemq.server.master.web.simplemvc.WebFilter;
import org.apache.inlong.tubemq.server.master.web.simplemvc.conf.ConfigFileParser;
import org.apache.inlong.tubemq.server.master.web.simplemvc.conf.WebConfig;
import org.apache.log4j.PropertyConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebApiServlet
extends HttpServlet {
    public static final int MAX_MULTIPART_POST_DATA_SIZE = 0x4000000;
    private static final Logger logger = LoggerFactory.getLogger(WebFilter.class);
    private static final String DEFAULT_CONFIG_PATH = "/WEB-INF/simple-mvc.xml";
    private static final String DEFAULT_LOG_CONFIG_PATH = "/WEB-INF/log4j.xml";
    private MultipartConfigElement multipartConfig;
    private String configFilePath;
    private File configFile;
    private WebConfig config;
    private RequestDispatcher dispatcher;

    public WebApiServlet(WebConfig config) {
        this.config = config;
    }

    protected void doRequest(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (req instanceof MultipartHttpServletRequest) {
            req.setAttribute("org.eclipse.jetty.multipartConfig", (Object)this.multipartConfig);
        }
        String charset = req.getCharacterEncoding() == null ? "UTF-8" : req.getCharacterEncoding();
        resp.setCharacterEncoding(charset);
        RequestContext context = new RequestContext(this.config, req, resp);
        if (this.config.containsType(context.requestType())) {
            if (this.dispatcher == null) {
                resp.sendError(500);
            } else {
                try {
                    this.dispatcher.processRequest(context);
                }
                catch (Throwable t) {
                    logger.error("", t);
                    resp.sendError(500);
                }
            }
            resp.flushBuffer();
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doRequest(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doRequest(req, resp);
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            this.initLogSystem(config);
            if (this.config == null) {
                URL configFileURL;
                if (this.configFilePath == null) {
                    String filePath = config.getInitParameter("configFile");
                    if (TStringUtils.isEmpty((String)filePath)) {
                        filePath = DEFAULT_CONFIG_PATH;
                    }
                    this.configFilePath = filePath;
                }
                if ((configFileURL = config.getServletContext().getResource(this.configFilePath)) == null) {
                    throw new ServletException(new StringBuilder(256).append("can not found config file:").append(this.configFilePath).toString());
                }
                this.configFile = new File(configFileURL.toURI());
                ConfigFileParser configParser = new ConfigFileParser(this.configFile);
                this.config = configParser.parse();
            }
            this.checkConfig(this.config, config.getServletContext());
            this.dispatcher = new RequestDispatcher(this.config);
            this.dispatcher.init();
            this.multipartConfig = new MultipartConfigElement(null, 0L, 0x4000000L, 0x4000000);
        }
        catch (ServletException se) {
            throw se;
        }
        catch (Throwable t) {
            logger.error("Dispatcher start failed!", t);
            throw new ServletException(t);
        }
    }

    private void checkConfig(WebConfig config, ServletContext servletContext) throws Exception {
        URL resourcesURL = servletContext.getResource(config.getResourcePath());
        if (resourcesURL == null) {
            throw new ServletException(new StringBuilder(256).append("Invalid resources path:").append(config.getResourcePath()).toString());
        }
        config.setResourcePath(resourcesURL.getPath());
        URL templatesURL = servletContext.getResource(config.getTemplatePath());
        if (templatesURL == null) {
            throw new ServletException(new StringBuilder(256).append("Invalid templates path:").append(config.getTemplatePath()).toString());
        }
        config.setTemplatePath(templatesURL.getPath());
        if (TStringUtils.isNotEmpty((String)config.getVelocityConfigFilePath())) {
            URL velocityConfigFilePath = servletContext.getResource(config.getVelocityConfigFilePath());
            if (velocityConfigFilePath != null) {
                config.setVelocityConfigFilePath(velocityConfigFilePath.getPath());
            } else {
                logger.warn(new StringBuilder(256).append("Invalid velocity config file path:").append(config.getVelocityConfigFilePath()).toString());
                config.setVelocityConfigFilePath(null);
            }
        }
    }

    private void initLogSystem(ServletConfig config) throws Exception {
        URL logConfigFileURL;
        ServletContext servletContext;
        String filePath = config.getInitParameter("logConfigFile");
        if (TStringUtils.isEmpty((String)filePath) && !this.config.isStandalone()) {
            filePath = DEFAULT_LOG_CONFIG_PATH;
        }
        if (TStringUtils.isNotEmpty((String)filePath) && (servletContext = config.getServletContext()) != null && (logConfigFileURL = servletContext.getResource(filePath)) != null) {
            PropertyConfigurator.configure((URL)logConfigFileURL);
        }
    }
}

