/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.web.handler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.inlong.tubemq.corebase.rv.ProcessResult;
import org.apache.inlong.tubemq.server.common.fielddef.WebFieldDef;
import org.apache.inlong.tubemq.server.common.statusdef.EnableStatus;
import org.apache.inlong.tubemq.server.common.utils.WebParameterUtils;
import org.apache.inlong.tubemq.server.master.TMaster;
import org.apache.inlong.tubemq.server.master.metamanage.DataOpErrCode;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.BaseEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.GroupConsumeCtrlEntity;
import org.apache.inlong.tubemq.server.master.web.handler.AbstractWebHandler;
import org.apache.inlong.tubemq.server.master.web.handler.GroupProcessResult;

public class WebGroupConsumeCtrlHandler
extends AbstractWebHandler {
    public WebGroupConsumeCtrlHandler(TMaster master) {
        super(master);
    }

    @Override
    public void registerWebApiMethod() {
        this.registerQueryWebMethod("admin_query_group_csmctrl_info", "adminQueryGroupConsumeCtrlInfo");
        this.registerQueryWebMethod("admin_query_booked_csmctrl_groups", "adminQueryBookedConsumeCtrlGroups");
        this.registerModifyWebMethod("admin_add_group_csmctrl_info", "adminAddGroupConsumeCtrlInfo");
        this.registerModifyWebMethod("admin_batch_add_group_csmctrl_info", "adminBatchAddGroupConsumeCtrlInfo");
        this.registerModifyWebMethod("admin_update_group_csmctrl_info", "adminModGroupConsumeCtrlInfo");
        this.registerModifyWebMethod("admin_batch_update_group_csmctrl_info", "adminBatchModGroupConsumeCtrlInfo");
        this.registerModifyWebMethod("admin_delete_group_csmctrl_info", "adminDelGroupConsumeCtrlInfo");
        this.registerModifyWebMethod("admin_batch_delete_group_csmctrl_info", "adminBatchDelGroupConsumeCtrlInfo");
    }

    public StringBuilder adminQueryBookedConsumeCtrlGroups(HttpServletRequest req, StringBuilder strBuff, ProcessResult result) {
        return this.innQueryGroupConsumeCtrlInfo(req, strBuff, result, true);
    }

    public StringBuilder adminQueryGroupConsumeCtrlInfo(HttpServletRequest req, StringBuilder strBuff, ProcessResult result) {
        return this.innQueryGroupConsumeCtrlInfo(req, strBuff, result, false);
    }

    public StringBuilder adminAddGroupConsumeCtrlInfo(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        return this.innAddOrUpdGroupConsumeCtrlInfo(req, sBuffer, result, true);
    }

    public StringBuilder adminBatchAddGroupConsumeCtrlInfo(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        return this.innBatchAddOrUpdGroupConsumeCtrlInfo(req, sBuffer, result, true);
    }

    public StringBuilder adminModGroupConsumeCtrlInfo(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        return this.innAddOrUpdGroupConsumeCtrlInfo(req, sBuffer, result, false);
    }

    public StringBuilder adminBatchModGroupConsumeCtrlInfo(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        return this.innBatchAddOrUpdGroupConsumeCtrlInfo(req, sBuffer, result, false);
    }

    public StringBuilder adminDelGroupConsumeCtrlInfo(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        if (!WebParameterUtils.getAUDBaseInfo(req, false, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        BaseEntity opEntity = (BaseEntity)result.getRetData();
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.COMPSGROUPNAME, true, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Set groupNameSet = (Set)result.getRetData();
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.COMPSTOPICNAME, false, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Set topicNameSet = (Set)result.getRetData();
        ArrayList<GroupProcessResult> retInfo = new ArrayList<GroupProcessResult>();
        if (topicNameSet.isEmpty()) {
            Map<String, List<GroupConsumeCtrlEntity>> groupCtrlConsumeMap = this.defMetaDataService.getConsumeCtrlByGroupName(groupNameSet);
            for (Map.Entry<String, List<GroupConsumeCtrlEntity>> entry : groupCtrlConsumeMap.entrySet()) {
                if (entry.getValue().isEmpty()) {
                    result.setFullInfo(true, DataOpErrCode.DERR_SUCCESS.getCode(), "Ok!");
                    retInfo.add(new GroupProcessResult(entry.getKey(), "", result));
                    continue;
                }
                for (GroupConsumeCtrlEntity ctrlEntity : entry.getValue()) {
                    if (ctrlEntity == null) continue;
                    this.defMetaDataService.delConsumeCtrlConf(opEntity.getModifyUser(), ctrlEntity.getGroupName(), ctrlEntity.getTopicName(), sBuffer, result);
                }
                result.setFullInfo(true, DataOpErrCode.DERR_SUCCESS.getCode(), "Ok!");
                retInfo.add(new GroupProcessResult(entry.getKey(), "", result));
            }
        } else {
            for (String groupName : groupNameSet) {
                for (String topicName : topicNameSet) {
                    this.defMetaDataService.delConsumeCtrlConf(opEntity.getModifyUser(), groupName, topicName, sBuffer, result);
                    retInfo.add(new GroupProcessResult(groupName, topicName, result));
                }
            }
        }
        this.buildRetInfo(retInfo, sBuffer);
        return sBuffer;
    }

    public StringBuilder adminBatchDelGroupConsumeCtrlInfo(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        if (!WebParameterUtils.getAUDBaseInfo(req, false, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        BaseEntity opEntity = (BaseEntity)result.getRetData();
        if (!this.getGroupConsumeJsonSetInfo(req, false, opEntity, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Map batchAddInfoMap = (Map)result.getRetData();
        ArrayList<GroupProcessResult> retInfo = new ArrayList<GroupProcessResult>();
        for (GroupConsumeCtrlEntity ctrlEntity : batchAddInfoMap.values()) {
            this.defMetaDataService.delConsumeCtrlConf(opEntity.getModifyUser(), ctrlEntity.getGroupName(), ctrlEntity.getTopicName(), sBuffer, result);
            retInfo.add(new GroupProcessResult(ctrlEntity.getGroupName(), ctrlEntity.getTopicName(), result));
        }
        this.buildRetInfo(retInfo, sBuffer);
        return sBuffer;
    }

    private StringBuilder innQueryGroupConsumeCtrlInfo(HttpServletRequest req, StringBuilder strBuff, ProcessResult result, boolean onlyRetGroup) {
        GroupConsumeCtrlEntity qryEntity = new GroupConsumeCtrlEntity();
        if (!WebParameterUtils.getQueriedOperateInfo(req, qryEntity, strBuff, result)) {
            WebParameterUtils.buildFailResult(strBuff, result.getErrMsg());
            return strBuff;
        }
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.COMPSGROUPNAME, false, null, strBuff, result)) {
            WebParameterUtils.buildFailResult(strBuff, result.getErrMsg());
            return strBuff;
        }
        Set groupSet = (Set)result.getRetData();
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.COMPSTOPICNAME, false, null, strBuff, result)) {
            WebParameterUtils.buildFailResult(strBuff, result.getErrMsg());
            return strBuff;
        }
        Set topicNameSet = (Set)result.getRetData();
        if (!WebParameterUtils.getEnableStatusValue(req, WebFieldDef.CONSUMEENABLE, false, null, strBuff, result)) {
            WebParameterUtils.buildFailResult(strBuff, result.getErrMsg());
            return strBuff;
        }
        EnableStatus consumeEnable = (EnableStatus)((Object)result.getRetData());
        if (!WebParameterUtils.getEnableStatusValue(req, WebFieldDef.FILTERENABLE, false, null, strBuff, result)) {
            WebParameterUtils.buildFailResult(strBuff, result.getErrMsg());
            return strBuff;
        }
        EnableStatus filterEnable = (EnableStatus)((Object)result.getRetData());
        if (!WebParameterUtils.getFilterCondSet(req, false, true, strBuff, result)) {
            WebParameterUtils.buildFailResult(strBuff, result.getErrMsg());
            return strBuff;
        }
        Set filterCondSet = (Set)result.getRetData();
        qryEntity.updModifyInfo(qryEntity.getDataVerId(), consumeEnable, null, filterEnable, null);
        Map<String, List<GroupConsumeCtrlEntity>> qryResultMap = this.defMetaDataService.getGroupConsumeCtrlConf(groupSet, topicNameSet, qryEntity);
        int totalCnt = 0;
        WebParameterUtils.buildSuccessWithDataRetBegin(strBuff);
        if (onlyRetGroup) {
            for (String groupName : qryResultMap.keySet()) {
                if (groupName == null) continue;
                if (totalCnt++ > 0) {
                    strBuff.append(",");
                }
                strBuff.append("\"").append(groupName).append("\"");
            }
        } else {
            for (List<GroupConsumeCtrlEntity> consumeCtrlEntityList : qryResultMap.values()) {
                if (consumeCtrlEntityList == null || consumeCtrlEntityList.isEmpty()) continue;
                for (GroupConsumeCtrlEntity entity : consumeCtrlEntityList) {
                    if (entity == null || !WebParameterUtils.isFilterSetFullIncluded(filterCondSet, entity.getFilterCondStr())) continue;
                    if (totalCnt++ > 0) {
                        strBuff.append(",");
                    }
                    entity.toWebJsonStr(strBuff, true, true);
                }
            }
        }
        WebParameterUtils.buildSuccessWithDataRetEnd(strBuff, totalCnt);
        return strBuff;
    }

    private StringBuilder innAddOrUpdGroupConsumeCtrlInfo(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result, boolean isAddOp) {
        if (!WebParameterUtils.getAUDBaseInfo(req, isAddOp, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        BaseEntity opInfoEntity = (BaseEntity)result.getRetData();
        if (!WebParameterUtils.getAndValidTopicNameInfo(req, this.defMetaDataService, true, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Set topicNameSet = (Set)result.getRetData();
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.COMPSGROUPNAME, true, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Set groupNameSet = (Set)result.getRetData();
        if (!WebParameterUtils.getEnableStatusValue(req, WebFieldDef.CONSUMEENABLE, false, isAddOp ? EnableStatus.STATUS_ENABLE : null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        EnableStatus consumeEnable = (EnableStatus)((Object)result.getRetData());
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.DSBCSMREASON, false, isAddOp ? "" : null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        String disableRsn = (String)result.getRetData();
        if (!WebParameterUtils.getEnableStatusValue(req, WebFieldDef.FILTERENABLE, false, isAddOp ? EnableStatus.STATUS_DISABLE : null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        EnableStatus filterEnable = (EnableStatus)((Object)result.getRetData());
        if (!WebParameterUtils.getFilterCondString(req, false, isAddOp, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        String filterCondStr = (String)result.getRetData();
        ArrayList<GroupProcessResult> retInfo = new ArrayList<GroupProcessResult>();
        for (String groupName : groupNameSet) {
            for (String topicName : topicNameSet) {
                retInfo.add(this.defMetaDataService.addOrUpdConsumeCtrlInfo(isAddOp, opInfoEntity, groupName, topicName, consumeEnable, disableRsn, filterEnable, filterCondStr, sBuffer, result));
            }
        }
        return this.buildRetInfo(retInfo, sBuffer);
    }

    private StringBuilder innBatchAddOrUpdGroupConsumeCtrlInfo(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result, boolean isAddOp) {
        if (!WebParameterUtils.getAUDBaseInfo(req, isAddOp, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        BaseEntity defOpEntity = (BaseEntity)result.getRetData();
        if (!this.getGroupConsumeJsonSetInfo(req, isAddOp, defOpEntity, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Map batchAddInfoMap = (Map)result.getRetData();
        ArrayList<GroupProcessResult> retInfo = new ArrayList<GroupProcessResult>();
        for (GroupConsumeCtrlEntity ctrlEntity : batchAddInfoMap.values()) {
            retInfo.add(this.defMetaDataService.addOrUpdConsumeCtrlInfo(isAddOp, ctrlEntity, sBuffer, result));
        }
        this.buildRetInfo(retInfo, sBuffer);
        return sBuffer;
    }

    private StringBuilder buildRetInfo(List<GroupProcessResult> retInfo, StringBuilder sBuffer) {
        int totalCnt = 0;
        WebParameterUtils.buildSuccessWithDataRetBegin(sBuffer);
        for (GroupProcessResult result : retInfo) {
            if (totalCnt++ > 0) {
                sBuffer.append(",");
            }
            sBuffer.append("{\"groupName\":\"").append(result.getGroupName()).append("\"").append(",\"topicName\":\"").append(result.getTopicName()).append("\"").append(",\"success\":").append(result.isSuccess()).append(",\"errCode\":").append(result.getErrCode()).append(",\"errInfo\":\"").append(result.getErrMsg()).append("\"}");
        }
        WebParameterUtils.buildSuccessWithDataRetEnd(sBuffer, totalCnt);
        return sBuffer;
    }

    private boolean getGroupConsumeJsonSetInfo(HttpServletRequest req, boolean isAddOp, BaseEntity defOpEntity, StringBuilder sBuffer, ProcessResult result) {
        if (!WebParameterUtils.getJsonArrayParamValue(req, WebFieldDef.GROUPCSMJSONSET, true, null, result)) {
            return result.isSuccess();
        }
        List filterJsonArray = (List)result.getRetData();
        HashMap<String, GroupConsumeCtrlEntity> addRecordMap = new HashMap<String, GroupConsumeCtrlEntity>();
        Set<String> configuredTopicSet = this.defMetaDataService.getDeployedTopicSet();
        for (Map itemsMap : filterJsonArray) {
            if (!WebParameterUtils.getAUDBaseInfo(itemsMap, isAddOp, defOpEntity, sBuffer, result)) {
                return result.isSuccess();
            }
            BaseEntity itemOpEntity = (BaseEntity)result.getRetData();
            if (!WebParameterUtils.getStringParamValue(itemsMap, WebFieldDef.GROUPNAME, true, "", sBuffer, result)) {
                return result.isSuccess();
            }
            String groupName = (String)result.getRetData();
            if (!WebParameterUtils.getStringParamValue(itemsMap, WebFieldDef.TOPICNAME, true, "", sBuffer, result)) {
                return result.isSuccess();
            }
            String topicName = (String)result.getRetData();
            if (!configuredTopicSet.contains(topicName)) {
                result.setFailResult(sBuffer.append(WebFieldDef.TOPICNAME.name).append(" ").append(topicName).append(" is not configure, please configure first!").toString());
                sBuffer.delete(0, sBuffer.length());
                return result.isSuccess();
            }
            if (!WebParameterUtils.getEnableStatusValue(itemsMap, WebFieldDef.CONSUMEENABLE, false, isAddOp ? EnableStatus.STATUS_ENABLE : null, sBuffer, result)) {
                return result.isSuccess();
            }
            EnableStatus consumeEnable = (EnableStatus)((Object)result.getRetData());
            if (!WebParameterUtils.getStringParamValue(itemsMap, WebFieldDef.DSBCSMREASON, false, isAddOp ? "" : null, sBuffer, result)) {
                return result.isSuccess();
            }
            String disableRsn = (String)result.getRetData();
            if (!WebParameterUtils.getEnableStatusValue(itemsMap, WebFieldDef.FILTERENABLE, false, isAddOp ? EnableStatus.STATUS_DISABLE : null, sBuffer, result)) {
                return result.isSuccess();
            }
            EnableStatus filterEnable = (EnableStatus)((Object)result.getRetData());
            if (!WebParameterUtils.getFilterCondString(itemsMap, false, isAddOp, sBuffer, result)) {
                return result.isSuccess();
            }
            String filterCondStr = (String)result.getRetData();
            GroupConsumeCtrlEntity itemConf = new GroupConsumeCtrlEntity(itemOpEntity, groupName, topicName);
            itemConf.updModifyInfo(itemOpEntity.getDataVerId(), consumeEnable, disableRsn, filterEnable, filterCondStr);
            addRecordMap.put(itemConf.getRecordKey(), itemConf);
        }
        if (addRecordMap.isEmpty()) {
            result.setFailResult(sBuffer.append("Not found record in ").append(WebFieldDef.GROUPCSMJSONSET.name).append(" parameter!").toString());
            sBuffer.delete(0, sBuffer.length());
            return result.isSuccess();
        }
        result.setSuccResult(addRecordMap);
        return result.isSuccess();
    }
}

