/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.web.handler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.inlong.tubemq.corebase.cluster.BrokerInfo;
import org.apache.inlong.tubemq.corebase.rv.ProcessResult;
import org.apache.inlong.tubemq.corebase.utils.AddressUtils;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;
import org.apache.inlong.tubemq.corebase.utils.Tuple2;
import org.apache.inlong.tubemq.server.common.fielddef.WebFieldDef;
import org.apache.inlong.tubemq.server.common.statusdef.ManageStatus;
import org.apache.inlong.tubemq.server.common.statusdef.StepStatus;
import org.apache.inlong.tubemq.server.common.statusdef.TopicStatus;
import org.apache.inlong.tubemq.server.common.utils.WebParameterUtils;
import org.apache.inlong.tubemq.server.master.TMaster;
import org.apache.inlong.tubemq.server.master.metamanage.DataOpErrCode;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.BaseEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.BrokerConfEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.ClusterSettingEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.TopicDeployEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.TopicPropGroup;
import org.apache.inlong.tubemq.server.master.nodemanage.nodebroker.BrokerAbnHolder;
import org.apache.inlong.tubemq.server.master.nodemanage.nodebroker.BrokerRunManager;
import org.apache.inlong.tubemq.server.master.nodemanage.nodebroker.BrokerRunStatusInfo;
import org.apache.inlong.tubemq.server.master.web.handler.AbstractWebHandler;
import org.apache.inlong.tubemq.server.master.web.handler.BrokerProcessResult;

public class WebBrokerConfHandler
extends AbstractWebHandler {
    public WebBrokerConfHandler(TMaster master) {
        super(master);
    }

    @Override
    public void registerWebApiMethod() {
        this.registerQueryWebMethod("admin_query_broker_configure", "adminQueryBrokerConfInfo");
        this.registerQueryWebMethod("admin_query_broker_run_status", "adminQueryBrokerRunStatusInfo");
        this.registerModifyWebMethod("admin_add_broker_configure", "adminAddBrokerConfInfo");
        this.registerModifyWebMethod("admin_batch_add_broker_configure", "adminBatchAddBrokerConfInfo");
        this.registerModifyWebMethod("admin_update_broker_configure", "adminUpdateBrokerConfInfo");
        this.registerModifyWebMethod("admin_batch_update_broker_configure", "adminBatchUpdBrokerConfInfo");
        this.registerModifyWebMethod("admin_delete_broker_configure", "adminDeleteBrokerConfEntityInfo");
        this.registerModifyWebMethod("admin_online_broker_configure", "adminOnlineBrokerConf");
        this.registerModifyWebMethod("admin_set_broker_read_or_write", "adminSetReadOrWriteBrokerConf");
        this.registerModifyWebMethod("admin_offline_broker_configure", "adminOfflineBrokerConf");
        this.registerModifyWebMethod("admin_reload_broker_configure", "adminReloadBrokerConf");
        this.registerModifyWebMethod("admin_release_broker_autoforbidden_status", "adminRelBrokerAutoForbiddenStatus");
        this.registerModifyWebMethod("admin_bath_add_broker_configure", "adminBatchAddBrokerConfInfo");
    }

    public StringBuilder adminQueryBrokerConfInfo(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        BrokerConfEntity qryEntity = new BrokerConfEntity();
        if (!WebParameterUtils.getQueriedOperateInfo(req, qryEntity, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        if (!WebParameterUtils.getIntParamValue(req, WebFieldDef.COMPSBROKERID, false, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Set brokerIds = (Set)result.getRetData();
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.COMPBROKERIP, false, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Set brokerIpSet = (Set)result.getRetData();
        if (!WebParameterUtils.getIntParamValue(req, WebFieldDef.BROKERPORT, false, -2, 1, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        int brokerPort = (Integer)result.getRetData();
        if (!WebParameterUtils.getIntParamValue(req, WebFieldDef.BROKERTLSPORT, false, -2, 1, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        int brokerTlsPort = (Integer)result.getRetData();
        if (!WebParameterUtils.getIntParamValue(req, WebFieldDef.BROKERWEBPORT, false, -2, 1, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        int brokerWebPort = (Integer)result.getRetData();
        if (!WebParameterUtils.getIntParamValue(req, WebFieldDef.REGIONID, false, -2, 0, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        int regionId = (Integer)result.getRetData();
        if (!WebParameterUtils.getIntParamValue(req, WebFieldDef.GROUPID, false, -2, 0, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        int groupId = (Integer)result.getRetData();
        if (!WebParameterUtils.getTopicPropInfo(req, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        TopicPropGroup brokerProps = (TopicPropGroup)result.getRetData();
        if (!WebParameterUtils.getTopicStatusParamValue(req, false, TopicStatus.STATUS_TOPIC_UNDEFINED, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        TopicStatus topicStatus = (TopicStatus)((Object)result.getRetData());
        if (!this.getManageStatusParamValue(req, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        ManageStatus mngStatus = (ManageStatus)((Object)result.getRetData());
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.COMPSTOPICNAME, false, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Set topicNameSet = (Set)result.getRetData();
        if (!WebParameterUtils.getBooleanParamValue(req, WebFieldDef.ISINCLUDE, false, true, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Boolean isInclude = (Boolean)result.getRetData();
        if (!WebParameterUtils.getBooleanParamValue(req, WebFieldDef.WITHTOPIC, false, false, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Boolean withTopic = (Boolean)result.getRetData();
        qryEntity.updModifyInfo(qryEntity.getDataVerId(), brokerPort, brokerTlsPort, brokerWebPort, regionId, groupId, mngStatus, brokerProps);
        Map<Integer, BrokerConfEntity> qryResult = this.defMetaDataService.getBrokerConfInfo(brokerIds, brokerIpSet, qryEntity);
        int totalCnt = 0;
        BrokerRunManager brokerRunManager = this.master.getBrokerRunManager();
        WebParameterUtils.buildSuccessWithDataRetBegin(sBuffer);
        for (BrokerConfEntity entity : qryResult.values()) {
            Map<String, TopicDeployEntity> topicConfEntityMap = this.defMetaDataService.getBrokerTopicConfEntitySet(entity.getBrokerId());
            if (!this.isValidRecord(topicNameSet, isInclude, topicStatus, topicConfEntityMap)) continue;
            if (totalCnt++ > 0) {
                sBuffer.append(",");
            }
            boolean isConfUpdated = false;
            boolean isConfLoaded = false;
            BrokerRunStatusInfo runStatusInfo = brokerRunManager.getBrokerRunStatusInfo(entity.getBrokerId());
            if (runStatusInfo != null) {
                Tuple2<Boolean, Boolean> syncTuple = runStatusInfo.getDataSyncStatus();
                isConfUpdated = (Boolean)syncTuple.getF0();
                isConfLoaded = (Boolean)syncTuple.getF1();
            }
            entity.toWebJsonStr(sBuffer, isConfUpdated, isConfLoaded, true, false);
            this.addTopicInfo(withTopic, sBuffer, topicConfEntityMap);
            sBuffer.append("}");
        }
        WebParameterUtils.buildSuccessWithDataRetEnd(sBuffer, totalCnt);
        return sBuffer;
    }

    public StringBuilder adminAddBrokerConfInfo(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        return this.innAddOrUpdBrokerConfInfo(req, sBuffer, result, true);
    }

    public StringBuilder adminUpdateBrokerConfInfo(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        return this.innAddOrUpdBrokerConfInfo(req, sBuffer, result, false);
    }

    public StringBuilder adminBatchAddBrokerConfInfo(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        return this.innBatchAddOrUpdBrokerConfInfo(req, sBuffer, result, true);
    }

    public StringBuilder adminBatchUpdBrokerConfInfo(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        return this.innBatchAddOrUpdBrokerConfInfo(req, sBuffer, result, false);
    }

    public StringBuilder adminDeleteBrokerConfEntityInfo(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        if (!WebParameterUtils.getAUDBaseInfo(req, false, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        BaseEntity opEntity = (BaseEntity)result.getRetData();
        if (!WebParameterUtils.getBooleanParamValue(req, WebFieldDef.ISRESERVEDDATA, false, false, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Boolean isReservedData = (Boolean)result.getRetData();
        if (!WebParameterUtils.getIntParamValue(req, WebFieldDef.COMPSBROKERID, true, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Set brokerIds = (Set)result.getRetData();
        ArrayList<BrokerProcessResult> retInfo = new ArrayList<BrokerProcessResult>();
        for (Integer brokerId : brokerIds) {
            this.defMetaDataService.delBrokerConfInfo(opEntity.getModifyUser(), isReservedData, brokerId, sBuffer, result);
            retInfo.add(new BrokerProcessResult(brokerId, null, result));
        }
        return this.buildRetInfo(retInfo, sBuffer);
    }

    public StringBuilder adminOnlineBrokerConf(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        if (!WebParameterUtils.getAUDBaseInfo(req, false, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        BaseEntity opEntity = (BaseEntity)result.getRetData();
        if (!WebParameterUtils.getIntParamValue(req, WebFieldDef.COMPSBROKERID, true, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Set brokerIds = (Set)result.getRetData();
        ArrayList<BrokerProcessResult> retInfo = new ArrayList<BrokerProcessResult>();
        for (Integer brokerId : brokerIds) {
            retInfo.add(this.defMetaDataService.changeBrokerConfStatus(opEntity, brokerId, ManageStatus.STATUS_MANAGE_ONLINE, sBuffer, result));
        }
        return this.buildRetInfo(retInfo, sBuffer);
    }

    public StringBuilder adminOfflineBrokerConf(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        if (!WebParameterUtils.getAUDBaseInfo(req, false, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        BaseEntity opEntity = (BaseEntity)result.getRetData();
        if (!WebParameterUtils.getIntParamValue(req, WebFieldDef.COMPSBROKERID, true, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Set brokerIds = (Set)result.getRetData();
        ArrayList<BrokerProcessResult> retInfo = new ArrayList<BrokerProcessResult>();
        for (Integer brokerId : brokerIds) {
            retInfo.add(this.defMetaDataService.changeBrokerConfStatus(opEntity, brokerId, ManageStatus.STATUS_MANAGE_OFFLINE, sBuffer, result));
        }
        return this.buildRetInfo(retInfo, sBuffer);
    }

    public StringBuilder adminSetReadOrWriteBrokerConf(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        if (!WebParameterUtils.getAUDBaseInfo(req, false, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        BaseEntity opEntity = (BaseEntity)result.getRetData();
        if (!WebParameterUtils.getIntParamValue(req, WebFieldDef.COMPSBROKERID, true, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Set brokerIds = (Set)result.getRetData();
        if (!this.getAcceptReadAndWriteParamValue(req, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Tuple2 rdWtTpl = (Tuple2)result.getRetData();
        ArrayList<BrokerProcessResult> retInfo = new ArrayList<BrokerProcessResult>();
        for (Integer brokerId : brokerIds) {
            BrokerConfEntity curEntry = this.defMetaDataService.getBrokerConfByBrokerId(brokerId);
            if (curEntry == null) {
                result.setFailResult(DataOpErrCode.DERR_NOT_EXIST.getCode(), "The broker configure not exist!");
                retInfo.add(new BrokerProcessResult(brokerId, "", result));
                continue;
            }
            if (curEntry.getManageStatus().getCode() < ManageStatus.STATUS_MANAGE_ONLINE.getCode()) {
                result.setFailResult(DataOpErrCode.DERR_CONDITION_LACK.getCode(), "The broker configure under draft status, please online first!");
                retInfo.add(new BrokerProcessResult(brokerId, "", result));
                continue;
            }
            ManageStatus newMngStatus = ManageStatus.getNewStatus(curEntry.getManageStatus(), (Boolean)rdWtTpl.getF0(), (Boolean)rdWtTpl.getF1());
            if (curEntry.getManageStatus() == newMngStatus) {
                result.setSuccResult(null);
                retInfo.add(new BrokerProcessResult(brokerId, curEntry.getBrokerIp(), result));
                continue;
            }
            retInfo.add(this.defMetaDataService.changeBrokerConfStatus(opEntity, brokerId, newMngStatus, sBuffer, result));
        }
        return this.buildRetInfo(retInfo, sBuffer);
    }

    public StringBuilder adminReloadBrokerConf(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        if (!WebParameterUtils.getAUDBaseInfo(req, false, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        BaseEntity opEntity = (BaseEntity)result.getRetData();
        if (!WebParameterUtils.getIntParamValue(req, WebFieldDef.COMPSBROKERID, true, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Set brokerIds = (Set)result.getRetData();
        ArrayList<BrokerProcessResult> retInfo = new ArrayList<BrokerProcessResult>();
        for (Integer brokerId : brokerIds) {
            retInfo.add(this.defMetaDataService.reloadBrokerConfInfo(opEntity, brokerId, sBuffer, result));
        }
        return this.buildRetInfo(retInfo, sBuffer);
    }

    public StringBuilder adminRelBrokerAutoForbiddenStatus(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        if (!WebParameterUtils.getAUDBaseInfo(req, false, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        BaseEntity opEntity = (BaseEntity)result.getRetData();
        if (!WebParameterUtils.getIntParamValue(req, WebFieldDef.COMPSBROKERID, true, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Set brokerIds = (Set)result.getRetData();
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.RELREASON, false, "Web API call", sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        String relReason = (String)result.getRetData();
        BrokerAbnHolder abnHolder = this.master.getBrokerAbnHolder();
        abnHolder.relAutoForbiddenBrokerInfo(brokerIds, relReason);
        WebParameterUtils.buildSuccessResult(sBuffer);
        return sBuffer;
    }

    public StringBuilder adminQueryBrokerRunStatusInfo(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        BrokerConfEntity qryEntity = new BrokerConfEntity();
        if (!WebParameterUtils.getQueriedOperateInfo(req, qryEntity, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        if (!WebParameterUtils.getIntParamValue(req, WebFieldDef.COMPSBROKERID, false, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Set brokerIds = (Set)result.getRetData();
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.COMPBROKERIP, false, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Set brokerIpSet = (Set)result.getRetData();
        if (!WebParameterUtils.getBooleanParamValue(req, WebFieldDef.WITHDETAIL, false, false, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        boolean withDetail = (Boolean)result.getRetData();
        if (!WebParameterUtils.getBooleanParamValue(req, WebFieldDef.ONLYABNORMAL, false, false, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        boolean onlyAbnormal = (Boolean)result.getRetData();
        if (!WebParameterUtils.getBooleanParamValue(req, WebFieldDef.ONLYAUTOFBD, false, false, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        boolean onlyAutoForbidden = (Boolean)result.getRetData();
        if (!WebParameterUtils.getBooleanParamValue(req, WebFieldDef.ONLYENABLETLS, false, false, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        boolean onlyEnableTLS = (Boolean)result.getRetData();
        Map<Integer, BrokerConfEntity> brokerConfEntityMap = this.defMetaDataService.getBrokerConfInfo(brokerIds, brokerIpSet, null);
        BrokerAbnHolder abnHolder = this.master.getBrokerAbnHolder();
        BrokerRunManager brokerRunManager = this.master.getBrokerRunManager();
        Map<Integer, BrokerAbnHolder.BrokerAbnInfo> brokerAbnInfoMap = abnHolder.getBrokerAbnormalMap();
        Map<Integer, BrokerAbnHolder.BrokerFbdInfo> brokerFbdInfoMap = abnHolder.getAutoForbiddenBrokerMapInfo();
        int totalCnt = 0;
        WebParameterUtils.buildSuccessWithDataRetBegin(sBuffer);
        for (BrokerConfEntity entity : brokerConfEntityMap.values()) {
            BrokerAbnHolder.BrokerAbnInfo brokerAbnInfo = brokerAbnInfoMap.get(entity.getBrokerId());
            if (onlyAbnormal && brokerAbnInfo == null) continue;
            BrokerAbnHolder.BrokerFbdInfo brokerForbInfo = brokerFbdInfoMap.get(entity.getBrokerId());
            if (onlyAutoForbidden && brokerForbInfo == null) continue;
            BrokerInfo brokerInfo = brokerRunManager.getBrokerInfo(entity.getBrokerId());
            if (onlyEnableTLS && (brokerInfo == null || !brokerInfo.isEnableTLS())) continue;
            if (totalCnt++ > 0) {
                sBuffer.append(",");
            }
            sBuffer.append("{\"brokerId\":").append(entity.getBrokerId()).append(",\"brokerIp\":\"").append(entity.getBrokerIp()).append("\",\"brokerPort\":").append(entity.getBrokerPort()).append(",\"brokerWebPort\":").append(entity.getBrokerWebPort()).append(",\"manageStatus\":\"").append(entity.getManageStatusStr()).append("\"");
            if (brokerInfo == null) {
                sBuffer.append(",\"brokerTLSPort\":").append(entity.getBrokerTLSPort()).append(",\"enableTLS\":\"-\"");
            } else {
                sBuffer.append(",\"brokerTLSPort\":").append(entity.getBrokerTLSPort()).append(",\"enableTLS\":").append(brokerInfo.isEnableTLS());
            }
            if (brokerAbnInfo == null) {
                sBuffer.append(",\"isRepAbnormal\":false");
            } else {
                sBuffer.append(",\"isRepAbnormal\":true,\"repStatus\":").append(brokerAbnInfo.getAbnStatus());
            }
            if (brokerForbInfo == null) {
                sBuffer.append(",\"isAutoForbidden\":false");
            } else {
                sBuffer.append(",\"isAutoForbidden\":true");
            }
            if (entity.getManageStatus() == ManageStatus.STATUS_MANAGE_APPLY) {
                sBuffer.append(",\"runStatus\":\"-\",\"subStatus\":\"-\"").append(",\"isConfChanged\":\"-\",\"isConfLoaded\":\"-\",\"isBrokerOnline\":\"-\"").append(",\"brokerVersion\":\"-\",\"acceptPublish\":\"-\",\"acceptSubscribe\":\"-\"");
            } else {
                Tuple2<Boolean, Boolean> pubSubTuple = entity.getManageStatus().getPubSubStatus();
                BrokerRunStatusInfo runStatusInfo = brokerRunManager.getBrokerRunStatusInfo(entity.getBrokerId());
                if (runStatusInfo == null) {
                    sBuffer.append(",\"runStatus\":\"unRegister\",\"subStatus\":\"-\"").append(",\"isConfChanged\":\"-\",\"isConfLoaded\":\"-\",\"isBrokerOnline\":\"-\"").append(",\"brokerVersion\":\"-\",\"acceptPublish\":\"-\",\"acceptSubscribe\":\"-\"");
                } else {
                    StepStatus stepStatus = runStatusInfo.getCurStepStatus();
                    if (runStatusInfo.isOnline()) {
                        if (stepStatus == StepStatus.STEP_STATUS_UNDEFINED) {
                            sBuffer.append(",\"runStatus\":\"running\",\"subStatus\":\"idle\"");
                        } else {
                            sBuffer.append(",\"runStatus\":\"running\"").append(",\"subStatus\":\"processing_event\",\"stepOp\":").append(stepStatus.getCode());
                        }
                    } else if (stepStatus == StepStatus.STEP_STATUS_UNDEFINED) {
                        sBuffer.append(",\"runStatus\":\"notRegister\",\"subStatus\":\"idle\"");
                    } else {
                        sBuffer.append(",\"runStatus\":\"notRegister\"").append(",\"subStatus\":\"processing_event\",\"stepOp\":").append(stepStatus.getCode());
                    }
                    Tuple2<Boolean, Boolean> syncTuple = runStatusInfo.getDataSyncStatus();
                    sBuffer.append(",\"isConfChanged\":\"").append(syncTuple.getF0()).append("\",\"isConfLoaded\":\"").append(syncTuple.getF1()).append("\",\"isBrokerOnline\":\"").append(runStatusInfo.isOnline()).append("\"").append(",\"brokerVersion\":\"-\",\"acceptPublish\":\"").append(pubSubTuple.getF0()).append("\",\"acceptSubscribe\":\"").append(pubSubTuple.getF1()).append("\"");
                    if (withDetail) {
                        sBuffer = runStatusInfo.toJsonString(sBuffer.append(","));
                    }
                }
            }
            sBuffer.append("}");
        }
        WebParameterUtils.buildSuccessWithDataRetEnd(sBuffer, totalCnt);
        return sBuffer;
    }

    private StringBuilder innAddOrUpdBrokerConfInfo(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result, boolean isAddOp) {
        if (!WebParameterUtils.getAUDBaseInfo(req, isAddOp, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        BaseEntity opEntity = (BaseEntity)result.getRetData();
        ClusterSettingEntity defClusterSetting = this.defMetaDataService.getClusterDefSetting(false);
        if (!WebParameterUtils.getIntParamValue(req, WebFieldDef.BROKERPORT, false, isAddOp ? defClusterSetting.getBrokerPort() : -2, 1, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        int brokerPort = (Integer)result.getRetData();
        if (!WebParameterUtils.getIntParamValue(req, WebFieldDef.BROKERTLSPORT, false, isAddOp ? defClusterSetting.getBrokerTLSPort() : -2, 1, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        int brokerTlsPort = (Integer)result.getRetData();
        if (!WebParameterUtils.getIntParamValue(req, WebFieldDef.BROKERWEBPORT, false, isAddOp ? defClusterSetting.getBrokerWebPort() : -2, 1, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        int brokerWebPort = (Integer)result.getRetData();
        if (!WebParameterUtils.getIntParamValue(req, WebFieldDef.REGIONID, false, isAddOp ? 0 : -2, 0, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        int regionId = (Integer)result.getRetData();
        if (!WebParameterUtils.getIntParamValue(req, WebFieldDef.GROUPID, false, isAddOp ? 0 : -2, 0, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        int groupId = (Integer)result.getRetData();
        if (!WebParameterUtils.getTopicPropInfo(req, isAddOp ? defClusterSetting.getClsDefTopicProps() : null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        TopicPropGroup brokerProps = (TopicPropGroup)result.getRetData();
        if (!this.getManageStatusParamValue(req, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        ManageStatus mngStatus = (ManageStatus)((Object)result.getRetData());
        ArrayList<BrokerProcessResult> retInfo = new ArrayList<BrokerProcessResult>();
        if (isAddOp) {
            if (!this.getBrokerIpAndIdParamValue(req, sBuffer, result)) {
                WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
                return sBuffer;
            }
            Tuple2 brokerIdAndIpTuple = (Tuple2)result.getRetData();
            if (mngStatus == ManageStatus.STATUS_MANAGE_UNDEFINED) {
                mngStatus = ManageStatus.STATUS_MANAGE_APPLY;
            }
            retInfo.add(this.defMetaDataService.addOrUpdBrokerConfig(isAddOp, opEntity, (Integer)brokerIdAndIpTuple.getF0(), (String)brokerIdAndIpTuple.getF1(), brokerPort, brokerTlsPort, brokerWebPort, regionId, groupId, mngStatus, brokerProps, sBuffer, result));
        } else {
            if (!WebParameterUtils.getIntParamValue(req, WebFieldDef.COMPSBROKERID, true, sBuffer, result)) {
                WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
                return sBuffer;
            }
            Set brokerIdSet = (Set)result.getRetData();
            for (Integer brokerId : brokerIdSet) {
                retInfo.add(this.defMetaDataService.addOrUpdBrokerConfig(isAddOp, opEntity, brokerId, "", brokerPort, brokerTlsPort, brokerWebPort, regionId, groupId, mngStatus, brokerProps, sBuffer, result));
            }
        }
        return this.buildRetInfo(retInfo, sBuffer);
    }

    private StringBuilder innBatchAddOrUpdBrokerConfInfo(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result, boolean isAddOp) {
        if (!WebParameterUtils.getAUDBaseInfo(req, isAddOp, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        BaseEntity defOpEntity = (BaseEntity)result.getRetData();
        if (!this.getBrokerJsonSetInfo(req, isAddOp, defOpEntity, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        HashMap addedRecordMap = (HashMap)result.getRetData();
        ArrayList<BrokerProcessResult> retInfo = new ArrayList<BrokerProcessResult>();
        for (BrokerConfEntity brokerEntity : addedRecordMap.values()) {
            retInfo.add(this.defMetaDataService.addOrUpdBrokerConfig(isAddOp, brokerEntity, sBuffer, result));
        }
        return this.buildRetInfo(retInfo, sBuffer);
    }

    private boolean isValidRecord(Set<String> qryTopicSet, Boolean isInclude, TopicStatus topicStatus, Map<String, TopicDeployEntity> topicConfEntityMap) {
        if (topicConfEntityMap == null || topicConfEntityMap.isEmpty()) {
            return (qryTopicSet == null || qryTopicSet.isEmpty()) && topicStatus == TopicStatus.STATUS_TOPIC_UNDEFINED;
        }
        if (qryTopicSet != null && !qryTopicSet.isEmpty()) {
            boolean matched = false;
            Set<String> curTopics = topicConfEntityMap.keySet();
            if (isInclude.booleanValue()) {
                for (String topic : qryTopicSet) {
                    if (!curTopics.contains(topic)) continue;
                    matched = true;
                    break;
                }
            } else {
                matched = true;
                for (String topic : qryTopicSet) {
                    if (!curTopics.contains(topic)) continue;
                    matched = false;
                    break;
                }
            }
            if (!matched) {
                return false;
            }
        }
        if (topicStatus != TopicStatus.STATUS_TOPIC_UNDEFINED) {
            for (TopicDeployEntity topicConfEntity : topicConfEntityMap.values()) {
                if (topicConfEntity.getDeployStatus() != topicStatus) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private StringBuilder addTopicInfo(Boolean withTopic, StringBuilder sBuffer, Map<String, TopicDeployEntity> topicConfEntityMap) {
        if (withTopic.booleanValue()) {
            sBuffer.append(",\"topicSet\":[");
            int topicCount = 0;
            if (topicConfEntityMap != null) {
                for (TopicDeployEntity topicEntity : topicConfEntityMap.values()) {
                    if (topicCount++ > 0) {
                        sBuffer.append(",");
                    }
                    topicEntity.toWebJsonStr(sBuffer, true, true);
                }
            }
            sBuffer.append("]");
        }
        return sBuffer;
    }

    private boolean getBrokerJsonSetInfo(HttpServletRequest req, boolean isAddOp, BaseEntity defOpEntity, StringBuilder sBuffer, ProcessResult result) {
        if (!WebParameterUtils.getJsonArrayParamValue(req, WebFieldDef.BROKERJSONSET, true, null, result)) {
            return result.isSuccess();
        }
        List brokerJsonArray = (List)result.getRetData();
        ClusterSettingEntity defClusterSetting = this.defMetaDataService.getClusterDefSetting(false);
        HashMap<Integer, BrokerConfEntity> addedRecordMap = new HashMap<Integer, BrokerConfEntity>();
        for (Map brokerObject : brokerJsonArray) {
            BrokerConfEntity itemEntity;
            if (!WebParameterUtils.getAUDBaseInfo(brokerObject, isAddOp, defOpEntity, sBuffer, result)) {
                return result.isSuccess();
            }
            BaseEntity itemOpEntity = (BaseEntity)result.getRetData();
            if (!WebParameterUtils.getIntParamValue(brokerObject, WebFieldDef.BROKERPORT, false, isAddOp ? defClusterSetting.getBrokerPort() : -2, 1, sBuffer, result)) {
                return result.isSuccess();
            }
            int brokerPort = (Integer)result.getRetData();
            if (!WebParameterUtils.getIntParamValue(brokerObject, WebFieldDef.BROKERTLSPORT, false, isAddOp ? defClusterSetting.getBrokerTLSPort() : -2, 1, sBuffer, result)) {
                return result.isSuccess();
            }
            int brokerTlsPort = (Integer)result.getRetData();
            if (!WebParameterUtils.getIntParamValue(brokerObject, WebFieldDef.BROKERWEBPORT, false, isAddOp ? defClusterSetting.getBrokerWebPort() : -2, 1, sBuffer, result)) {
                return result.isSuccess();
            }
            int brokerWebPort = (Integer)result.getRetData();
            if (!WebParameterUtils.getIntParamValue(brokerObject, WebFieldDef.REGIONID, false, isAddOp ? 0 : -2, 0, sBuffer, result)) {
                return result.isSuccess();
            }
            int regionId = (Integer)result.getRetData();
            if (!WebParameterUtils.getIntParamValue(brokerObject, WebFieldDef.GROUPID, false, isAddOp ? 0 : -2, 0, sBuffer, result)) {
                return result.isSuccess();
            }
            int groupId = (Integer)result.getRetData();
            if (!WebParameterUtils.getTopicPropInfo(brokerObject, isAddOp ? defClusterSetting.getClsDefTopicProps() : null, sBuffer, result)) {
                return result.isSuccess();
            }
            TopicPropGroup brokerProps = (TopicPropGroup)result.getRetData();
            if (!this.getManageStatusParamValue(brokerObject, sBuffer, result)) {
                return result.isSuccess();
            }
            ManageStatus mngStatus = (ManageStatus)((Object)result.getRetData());
            if (isAddOp) {
                if (!this.getBrokerIpAndIdParamValue(brokerObject, sBuffer, result)) {
                    return result.isSuccess();
                }
                Tuple2 brokerIdAndIpTuple = (Tuple2)result.getRetData();
                if (mngStatus == ManageStatus.STATUS_MANAGE_UNDEFINED) {
                    mngStatus = ManageStatus.STATUS_MANAGE_APPLY;
                }
                itemEntity = new BrokerConfEntity(itemOpEntity, (Integer)brokerIdAndIpTuple.getF0(), (String)brokerIdAndIpTuple.getF1());
                itemEntity.updModifyInfo(itemOpEntity.getDataVerId(), brokerPort, brokerTlsPort, brokerWebPort, regionId, groupId, mngStatus, brokerProps);
                addedRecordMap.put(itemEntity.getBrokerId(), itemEntity);
                continue;
            }
            if (!WebParameterUtils.getIntParamValue(brokerObject, WebFieldDef.BROKERID, true, sBuffer, result)) {
                return result.isSuccess();
            }
            Integer brokerId = (Integer)result.getRetData();
            itemEntity = new BrokerConfEntity(itemOpEntity, brokerId, "");
            itemEntity.updModifyInfo(itemOpEntity.getDataVerId(), brokerPort, brokerTlsPort, brokerWebPort, regionId, groupId, mngStatus, brokerProps);
            addedRecordMap.put(itemEntity.getBrokerId(), itemEntity);
        }
        if (addedRecordMap.isEmpty()) {
            result.setFailResult(sBuffer.append("Not found record in ").append(WebFieldDef.BROKERJSONSET.name).append(" parameter!").toString());
            sBuffer.delete(0, sBuffer.length());
            return result.isSuccess();
        }
        result.setSuccResult(addedRecordMap);
        return result.isSuccess();
    }

    private StringBuilder buildRetInfo(List<BrokerProcessResult> retInfo, StringBuilder sBuffer) {
        int totalCnt = 0;
        WebParameterUtils.buildSuccessWithDataRetBegin(sBuffer);
        for (BrokerProcessResult entry : retInfo) {
            if (totalCnt++ > 0) {
                sBuffer.append(",");
            }
            sBuffer.append("{\"brokerId\":").append(entry.getBrokerId()).append(",\"brokerIp\":\"").append(entry.getBrokerIp()).append("\",\"success\":").append(entry.isSuccess()).append(",\"errCode\":").append(entry.getErrCode()).append(",\"errInfo\":\"").append(entry.getErrMsg()).append("\"}");
        }
        WebParameterUtils.buildSuccessWithDataRetEnd(sBuffer, totalCnt);
        return sBuffer;
    }

    private <T> boolean getBrokerIpAndIdParamValue(T paramCntr, StringBuilder sBuffer, ProcessResult result) {
        BrokerConfEntity curEntity;
        if (!WebParameterUtils.getStringParamValue(paramCntr, WebFieldDef.BROKERIP, true, null, sBuffer, result)) {
            return result.isSuccess();
        }
        String brokerIp = (String)result.getRetData();
        if (!WebParameterUtils.getIntParamValue(paramCntr, WebFieldDef.BROKERID, false, 0, 0, sBuffer, result)) {
            return result.isSuccess();
        }
        int brokerId = (Integer)result.getRetData();
        if (brokerId <= 0) {
            try {
                brokerId = Math.abs(AddressUtils.ipToInt((String)brokerIp));
            }
            catch (Exception e) {
                result.setFailResult(DataOpErrCode.DERR_ILLEGAL_VALUE.getCode(), sBuffer.append("Get ").append(WebFieldDef.BROKERID.name).append(" by ").append(WebFieldDef.BROKERIP.name).append(" error !, exception is :").append(e.toString()).toString());
                sBuffer.delete(0, sBuffer.length());
                return result.isSuccess();
            }
        }
        if ((curEntity = this.defMetaDataService.getBrokerConfByBrokerIp(brokerIp)) != null) {
            result.setFailResult(DataOpErrCode.DERR_EXISTED.getCode(), sBuffer.append("Duplicated broker configure record, query by ").append(WebFieldDef.BROKERIP.name).append(" : ").append(brokerIp).toString());
            sBuffer.delete(0, sBuffer.length());
            return result.isSuccess();
        }
        curEntity = this.defMetaDataService.getBrokerConfByBrokerId(brokerId);
        if (curEntity != null) {
            result.setFailResult(DataOpErrCode.DERR_EXISTED.getCode(), sBuffer.append("Duplicated broker configure record, query by ").append(WebFieldDef.BROKERID.name).append(" : ").append(brokerId).toString());
            sBuffer.delete(0, sBuffer.length());
            return result.isSuccess();
        }
        result.setSuccResult((Object)new Tuple2((Object)brokerId, (Object)brokerIp));
        return result.isSuccess();
    }

    private <T> boolean getManageStatusParamValue(T paramCntr, StringBuilder sBuffer, ProcessResult result) {
        if (!WebParameterUtils.getStringParamValue(paramCntr, WebFieldDef.MANAGESTATUS, false, null, sBuffer, result)) {
            return result.isSuccess();
        }
        String statusInfo = (String)result.getRetData();
        ManageStatus mngStatus = ManageStatus.STATUS_MANAGE_UNDEFINED;
        if (TStringUtils.isNotBlank((String)statusInfo)) {
            try {
                mngStatus = ManageStatus.descOf(statusInfo);
            }
            catch (Throwable e) {
                result.setFailResult(DataOpErrCode.DERR_ILLEGAL_VALUE.getCode(), sBuffer.append("Illegal ").append(WebFieldDef.MANAGESTATUS.name).append(" parameter value :").append(e.getMessage()).toString());
                sBuffer.delete(0, sBuffer.length());
                return result.isSuccess();
            }
        }
        result.setSuccResult((Object)mngStatus);
        return result.isSuccess();
    }

    private <T> boolean getAcceptReadAndWriteParamValue(T paramCntr, StringBuilder sBuffer, ProcessResult result) {
        if (!WebParameterUtils.getBooleanParamValue(paramCntr, WebFieldDef.ACCEPTPUBLISH, false, null, sBuffer, result)) {
            return result.isSuccess();
        }
        Boolean publishParam = (Boolean)result.getRetData();
        if (!WebParameterUtils.getBooleanParamValue(paramCntr, WebFieldDef.ACCEPTSUBSCRIBE, false, null, sBuffer, result)) {
            return result.isSuccess();
        }
        Boolean subscribeParam = (Boolean)result.getRetData();
        if (publishParam == null && subscribeParam == null) {
            result.setFailResult(DataOpErrCode.DERR_ILLEGAL_VALUE.getCode(), sBuffer.append("Fields ").append(WebFieldDef.ACCEPTPUBLISH.name).append(" or ").append(WebFieldDef.ACCEPTSUBSCRIBE.name).append(" must exist at this method!").toString());
            sBuffer.delete(0, sBuffer.length());
            return result.isSuccess();
        }
        result.setSuccResult((Object)new Tuple2((Object)publishParam, (Object)subscribeParam));
        return result.isSuccess();
    }
}

