/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.web;

import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.apache.inlong.tubemq.server.Server;
import org.apache.inlong.tubemq.server.master.MasterConfig;
import org.apache.inlong.tubemq.server.master.TMaster;
import org.apache.inlong.tubemq.server.master.web.MasterStatusCheckFilter;
import org.apache.inlong.tubemq.server.master.web.UserAuthFilter;
import org.apache.inlong.tubemq.server.master.web.action.layout.Default;
import org.apache.inlong.tubemq.server.master.web.action.screen.Master;
import org.apache.inlong.tubemq.server.master.web.action.screen.Tubeweb;
import org.apache.inlong.tubemq.server.master.web.action.screen.Webapi;
import org.apache.inlong.tubemq.server.master.web.action.screen.cluster.ClusterManager;
import org.apache.inlong.tubemq.server.master.web.action.screen.config.BrokerDetail;
import org.apache.inlong.tubemq.server.master.web.action.screen.config.BrokerList;
import org.apache.inlong.tubemq.server.master.web.action.screen.config.TopicDetail;
import org.apache.inlong.tubemq.server.master.web.action.screen.config.TopicList;
import org.apache.inlong.tubemq.server.master.web.action.screen.consume.Detail;
import org.apache.inlong.tubemq.server.master.web.simplemvc.WebApiServlet;
import org.apache.inlong.tubemq.server.master.web.simplemvc.WebFilter;
import org.apache.inlong.tubemq.server.master.web.simplemvc.conf.WebConfig;
import org.apache.velocity.tools.generic.DateTool;
import org.apache.velocity.tools.generic.NumberTool;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public class WebServer
implements Server {
    private final MasterConfig masterConfig;
    private org.eclipse.jetty.server.Server srv;
    private TMaster master;

    public WebServer(MasterConfig masterConfig, TMaster master) {
        this.masterConfig = masterConfig;
        this.master = master;
    }

    @Override
    public void start() throws Exception {
        WebConfig webConfig = new WebConfig();
        webConfig.setActionPackage("org.apache.inlong.tubemq.server.master.web.action");
        webConfig.setResourcePath("/");
        webConfig.setVelocityConfigFilePath("/velocity.properties");
        webConfig.setStandalone(true);
        this.registerActions(webConfig);
        this.registerTools(webConfig);
        this.srv = new org.eclipse.jetty.server.Server(this.masterConfig.getWebPort());
        ServletContextHandler servletContext = new ServletContextHandler((HandlerContainer)this.srv, "/", 1);
        servletContext.addFilter(new FilterHolder((Filter)new MasterStatusCheckFilter(this.master)), "/*", EnumSet.of(DispatcherType.REQUEST, DispatcherType.ASYNC));
        servletContext.addFilter(new FilterHolder((Filter)new UserAuthFilter()), "/*", EnumSet.of(DispatcherType.REQUEST, DispatcherType.ASYNC));
        servletContext.addFilter(new FilterHolder((Filter)new WebFilter()), "/*", EnumSet.of(DispatcherType.REQUEST, DispatcherType.ASYNC));
        ServletHolder servletHolder = new ServletHolder((Servlet)new WebApiServlet(webConfig));
        servletHolder.setInitParameter("dirAllowed", "false");
        servletContext.addServlet(servletHolder, "/");
        ServletHolder staticHolder = new ServletHolder((Servlet)new DefaultServlet());
        staticHolder.setInitParameter("dirAllowed", "false");
        servletContext.addServlet(staticHolder, "/assets/*");
        servletContext.setResourceBase(this.masterConfig.getWebResourcePath());
        this.srv.start();
        if (!this.srv.getHandler().equals(servletContext)) {
            throw new Exception("servletContext is not a handler!");
        }
    }

    @Override
    public void stop() throws Exception {
        this.srv.stop();
    }

    private void registerActions(WebConfig config) {
        config.registerAction(new Detail(this.master));
        config.registerAction(new BrokerDetail(this.master));
        config.registerAction(new TopicDetail(this.master));
        config.registerAction(new TopicList(this.master));
        config.registerAction(new ClusterManager(this.master));
        config.registerAction(new BrokerList(this.master));
        config.registerAction(new Master(this.master));
        config.registerAction(new Webapi(this.master));
        config.registerAction(new Tubeweb(this.master));
        config.registerAction(new Default(this.master));
    }

    private void registerTools(WebConfig config) {
        config.registerTool("dateTool", new DateTool());
        config.registerTool("numericTool", new NumberTool());
    }
}

