/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.utils;

import org.apache.inlong.tubemq.corebase.utils.AbstractSamplePrint;
import org.slf4j.Logger;

public class BrokerStatusSamplePrint
extends AbstractSamplePrint {
    private final Logger logger;

    public BrokerStatusSamplePrint(Logger logger) {
        this.logger = logger;
    }

    public BrokerStatusSamplePrint(Logger logger, long sampleDetailDur, long sampleResetDur, long maxDetailCount, long maxTotalCount) {
        super(sampleDetailDur, sampleResetDur, maxDetailCount, maxTotalCount);
        this.logger = logger;
    }

    public void printExceptionCaught(Throwable e) {
    }

    public void printExceptionCaught(Throwable e, String hostName, String nodeName) {
    }

    public void printWarn(String err) {
        this.printMsg(true, err);
    }

    public void printError(String err) {
        this.printMsg(false, err);
    }

    private void printMsg(boolean isWarn, String err) {
        long now = System.currentTimeMillis();
        long diffTime = now - this.lastLogTime.get();
        long curPrintCnt = this.totalPrintCount.incrementAndGet();
        if (curPrintCnt < this.maxTotalCount && diffTime < this.sampleDetailDur && curPrintCnt < this.maxDetailCount) {
            if (isWarn) {
                this.logger.warn(err);
            } else {
                this.logger.error(err);
            }
        }
        if (diffTime > this.sampleResetDur && this.lastLogTime.compareAndSet(now - diffTime, now)) {
            this.totalPrintCount.set(0L);
        }
    }
}

