/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.stats;

import java.lang.management.ManagementFactory;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.inlong.tubemq.corebase.metric.MetricMXBean;
import org.apache.inlong.tubemq.server.common.webbase.WebCallStatsHolder;
import org.apache.inlong.tubemq.server.master.stats.MasterSrvStatsHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterJMXHolder {
    private static final Logger logger = LoggerFactory.getLogger(MasterJMXHolder.class);
    private static final AtomicBoolean registered = new AtomicBoolean(false);
    private static final MasterServiceStatusBean serviceStatusInfo = new MasterServiceStatusBean();
    private static final MasterWebAPIStatusBean webAPIStatusInfo = new MasterWebAPIStatusBean();

    public static void registerMXBean() {
        if (!registered.compareAndSet(false, true)) {
            return;
        }
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName srvStatusMxBeanName = new ObjectName("org.apache.inlong.tubemq.server.master:type=serviceStatus");
            mbs.registerMBean(serviceStatusInfo, srvStatusMxBeanName);
            ObjectName webAPIMxBeanName = new ObjectName("org.apache.inlong.tubemq.server.master:type=webAPI");
            mbs.registerMBean(webAPIStatusInfo, webAPIMxBeanName);
        }
        catch (Exception ex) {
            logger.error("Register Master MXBean error: ", (Throwable)ex);
        }
    }

    private static class MasterWebAPIStatusBean
    implements MetricMXBean {
        private MasterWebAPIStatusBean() {
        }

        public Map<String, Long> getValue() {
            LinkedHashMap<String, Long> metricValues = new LinkedHashMap<String, Long>();
            WebCallStatsHolder.getValue(metricValues);
            return metricValues;
        }

        public Map<String, Long> snapshot() {
            LinkedHashMap<String, Long> metricValues = new LinkedHashMap<String, Long>();
            WebCallStatsHolder.snapShort(metricValues);
            return metricValues;
        }
    }

    private static class MasterServiceStatusBean
    implements MetricMXBean {
        private MasterServiceStatusBean() {
        }

        public Map<String, Long> getValue() {
            LinkedHashMap<String, Long> metricValues = new LinkedHashMap<String, Long>();
            MasterSrvStatsHolder.getValue(metricValues);
            return metricValues;
        }

        public Map<String, Long> snapshot() {
            LinkedHashMap<String, Long> metricValues = new LinkedHashMap<String, Long>();
            MasterSrvStatsHolder.snapShort(metricValues);
            return metricValues;
        }
    }
}

