/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;
import org.apache.inlong.tubemq.corebase.utils.Tuple2;
import org.apache.inlong.tubemq.server.common.statusdef.CleanPolType;

public class TopicPropGroup
implements Serializable,
Cloneable {
    private int numTopicStores = -2;
    private int numPartitions = -2;
    private int unflushThreshold = -2;
    private int unflushInterval = -2;
    private int unflushDataHold = -2;
    private int memCacheMsgSizeInMB = -2;
    private int memCacheMsgCntInK = -2;
    private int memCacheFlushIntvl = -2;
    private Boolean acceptPublish = null;
    private Boolean acceptSubscribe = null;
    private int dataStoreType = -2;
    private String dataPath = "";
    private String deletePolicy = "";
    private CleanPolType cleanPolicyType = CleanPolType.CLEAN_POL_DELETE;
    private long retPeriodInMs = -2L;

    public TopicPropGroup() {
    }

    public TopicPropGroup(int numTopicStores, int numPartitions, int unflushThreshold, int unflushInterval, int unflushDataHold, int memCacheMsgSizeInMB, int memCacheMsgCntInK, int memCacheFlushIntvl, boolean acceptPublish, boolean acceptSubscribe, String deletePolicy, int dataStoreType, String dataPath) {
        this.numTopicStores = numTopicStores;
        this.numPartitions = numPartitions;
        this.unflushThreshold = unflushThreshold;
        this.unflushInterval = unflushInterval;
        this.unflushDataHold = unflushDataHold;
        this.memCacheMsgSizeInMB = memCacheMsgSizeInMB;
        this.memCacheMsgCntInK = memCacheMsgCntInK;
        this.memCacheFlushIntvl = memCacheFlushIntvl;
        this.acceptPublish = acceptPublish;
        this.acceptSubscribe = acceptSubscribe;
        this.setDeletePolicy(deletePolicy);
        this.dataStoreType = dataStoreType;
        if (dataPath != null) {
            this.dataPath = dataPath;
        }
    }

    public int getNumTopicStores() {
        return this.numTopicStores;
    }

    public void setNumTopicStores(int numTopicStores) {
        this.numTopicStores = numTopicStores;
    }

    public int getNumPartitions() {
        return this.numPartitions;
    }

    public void setNumPartitions(int numPartitions) {
        this.numPartitions = numPartitions;
    }

    public int getUnflushThreshold() {
        return this.unflushThreshold;
    }

    public void setUnflushThreshold(int unflushThreshold) {
        this.unflushThreshold = unflushThreshold;
    }

    public int getUnflushInterval() {
        return this.unflushInterval;
    }

    public void setUnflushInterval(int unflushInterval) {
        this.unflushInterval = unflushInterval;
    }

    public int getUnflushDataHold() {
        return this.unflushDataHold;
    }

    public void setUnflushDataHold(int unflushDataHold) {
        this.unflushDataHold = unflushDataHold;
    }

    public int getMemCacheMsgSizeInMB() {
        return this.memCacheMsgSizeInMB;
    }

    public void setMemCacheMsgSizeInMB(int memCacheMsgSizeInMB) {
        this.memCacheMsgSizeInMB = memCacheMsgSizeInMB;
    }

    public int getMemCacheMsgCntInK() {
        return this.memCacheMsgCntInK;
    }

    public void setMemCacheMsgCntInK(int memCacheMsgCntInK) {
        this.memCacheMsgCntInK = memCacheMsgCntInK;
    }

    public int getMemCacheFlushIntvl() {
        return this.memCacheFlushIntvl;
    }

    public void setMemCacheFlushIntvl(int memCacheFlushIntvl) {
        this.memCacheFlushIntvl = memCacheFlushIntvl;
    }

    public boolean isAcceptPublish() {
        return this.acceptPublish;
    }

    public Boolean getAcceptPublish() {
        return this.acceptPublish;
    }

    public void setAcceptPublish(Boolean acceptPublish) {
        this.acceptPublish = acceptPublish;
    }

    public boolean isAcceptSubscribe() {
        return this.acceptSubscribe;
    }

    public void setAcceptSubscribe(Boolean acceptSubscribe) {
        this.acceptSubscribe = acceptSubscribe;
    }

    public Boolean getAcceptSubscribe() {
        return this.acceptSubscribe;
    }

    public void setDeletePolicy(String deletePolicy) {
        if (TStringUtils.isNotBlank((String)deletePolicy)) {
            this.deletePolicy = deletePolicy;
            Tuple2<CleanPolType, Long> parsedRet = this.parseDelPolicy(deletePolicy);
            this.cleanPolicyType = (CleanPolType)((Object)parsedRet.getF0());
            this.retPeriodInMs = (Long)parsedRet.getF1();
        }
    }

    public String getDeletePolicy() {
        return this.deletePolicy;
    }

    public long getRetPeriodInMs() {
        return this.retPeriodInMs;
    }

    public CleanPolType getCleanPolicyType() {
        return this.cleanPolicyType;
    }

    public void setDataStoreInfo(int dataStoreType, String dataPath) {
        this.dataPath = dataPath;
        this.dataStoreType = dataStoreType;
    }

    public String getDataPath() {
        return this.dataPath;
    }

    public int getDataStoreType() {
        return this.dataStoreType;
    }

    public boolean isMatched(TopicPropGroup target) {
        if (target == null) {
            return true;
        }
        return !(target.getNumTopicStores() != -2 && target.getNumTopicStores() != this.numTopicStores || target.getNumPartitions() != -2 && target.getNumPartitions() != this.numPartitions || target.getUnflushThreshold() != -2 && target.getUnflushThreshold() != this.unflushThreshold || target.getUnflushInterval() != -2 && target.getUnflushInterval() != this.unflushInterval || target.getUnflushDataHold() != -2 && target.getUnflushDataHold() != this.unflushDataHold || target.getMemCacheMsgSizeInMB() != -2 && target.getMemCacheMsgSizeInMB() != this.memCacheMsgSizeInMB || target.getMemCacheMsgCntInK() != -2 && target.getMemCacheMsgCntInK() != this.memCacheMsgCntInK || target.getMemCacheFlushIntvl() != -2 && target.getMemCacheFlushIntvl() != this.memCacheFlushIntvl || target.getAcceptPublish() != null && !Objects.equals(target.getAcceptPublish(), this.acceptPublish) || target.getAcceptSubscribe() != null && !Objects.equals(target.getAcceptSubscribe(), this.acceptSubscribe) || !TStringUtils.isBlank((String)target.getDeletePolicy()) && !target.getDeletePolicy().equals(this.deletePolicy));
    }

    public StringBuilder toWebJsonStr(StringBuilder sBuilder, boolean isLongName) {
        if (isLongName) {
            sBuilder.append(",\"numTopicStores\":").append(this.numTopicStores).append(",\"numPartitions\":").append(this.numPartitions).append(",\"unflushThreshold\":").append(this.unflushThreshold).append(",\"unflushInterval\":").append(this.unflushInterval).append(",\"unflushDataHold\":").append(this.unflushDataHold).append(",\"memCacheMsgSizeInMB\":").append(this.memCacheMsgSizeInMB).append(",\"memCacheMsgCntInK\":").append(this.memCacheMsgCntInK).append(",\"memCacheFlushIntvl\":").append(this.memCacheFlushIntvl).append(",\"acceptPublish\":").append(this.acceptPublish).append(",\"acceptSubscribe\":").append(this.acceptSubscribe).append(",\"deletePolicy\":\"").append(this.deletePolicy).append("\"").append(",\"dataStoreType\":").append(this.dataStoreType).append(",\"dataPath\":\"").append(this.dataPath).append("\"");
        } else {
            sBuilder.append(",\"numStore\":").append(this.numTopicStores).append(",\"numPart\":").append(this.numPartitions).append(",\"unfDskMsgCnt\":").append(this.unflushThreshold).append(",\"unfDskInt\":").append(this.unflushInterval).append(",\"unfDskDataSz\":").append(this.unflushDataHold).append(",\"cacheInMB\":").append(this.memCacheMsgSizeInMB).append(",\"unfMemMsgCnt\":").append(this.memCacheMsgCntInK).append(",\"unfMemInt\":").append(this.memCacheFlushIntvl).append(",\"accPub\":").append(this.acceptPublish).append(",\"accSub\":").append(this.acceptSubscribe).append(",\"delPol\":\"").append(this.deletePolicy).append("\"").append(",\"dStType\":").append(this.dataStoreType).append(",\"dPath\":\"").append(this.dataPath).append("\"");
        }
        return sBuilder;
    }

    public void getConfigureInfo(Map<String, String> paramMap, boolean isLongName) {
        if (this.numTopicStores != -2) {
            paramMap.put(isLongName ? "numTopicStores" : "numStore", String.valueOf(this.numTopicStores));
        }
        if (this.numPartitions != -2) {
            paramMap.put(isLongName ? "numPartitions" : "numPart", String.valueOf(this.numPartitions));
        }
        if (this.unflushThreshold != -2) {
            paramMap.put(isLongName ? "unflushThreshold" : "unfDskMsgCnt", String.valueOf(this.unflushThreshold));
        }
        if (this.unflushInterval != -2) {
            paramMap.put(isLongName ? "unflushInterval" : "unfDskInt", String.valueOf(this.unflushInterval));
        }
        if (this.unflushDataHold != -2) {
            paramMap.put(isLongName ? "unflushDataHold" : "unfDskDataSz", String.valueOf(this.unflushDataHold));
        }
        if (this.memCacheMsgSizeInMB != -2) {
            paramMap.put(isLongName ? "memCacheMsgSizeInMB" : "cacheInMB", String.valueOf(this.memCacheMsgSizeInMB));
        }
        if (this.memCacheMsgCntInK != -2) {
            paramMap.put(isLongName ? "memCacheMsgCntInK" : "unfMemMsgCnt", String.valueOf(this.memCacheMsgCntInK));
        }
        if (this.memCacheFlushIntvl != -2) {
            paramMap.put(isLongName ? "memCacheFlushIntvl" : "unfMemInt", String.valueOf(this.memCacheFlushIntvl));
        }
        if (this.acceptPublish != null) {
            paramMap.put(isLongName ? "acceptPublish" : "accPub", String.valueOf(this.acceptPublish));
        }
        if (this.acceptSubscribe != null) {
            paramMap.put(isLongName ? "acceptSubscribe" : "accSub", String.valueOf(this.acceptSubscribe));
        }
        if (TStringUtils.isNotBlank((String)this.deletePolicy)) {
            paramMap.put(isLongName ? "deletePolicy" : "delPol", this.deletePolicy);
        }
        if (this.dataStoreType != -2) {
            paramMap.put(isLongName ? "dataStoreType" : "dStType", String.valueOf(this.dataStoreType));
        }
        if (TStringUtils.isNotBlank((String)this.dataPath)) {
            paramMap.put(isLongName ? "dataPath" : "dPath", this.dataPath);
        }
    }

    public TopicPropGroup fillDefaultValue() {
        this.numTopicStores = 1;
        this.numPartitions = 1;
        this.unflushThreshold = 1000;
        this.unflushInterval = 10000;
        this.unflushDataHold = 0;
        this.memCacheMsgSizeInMB = 3;
        this.memCacheFlushIntvl = 20000;
        this.memCacheMsgCntInK = 10;
        this.acceptPublish = true;
        this.acceptSubscribe = true;
        this.deletePolicy = "delete,168h";
        this.retPeriodInMs = 14515200L;
        return this;
    }

    public boolean isDataEquals(TopicPropGroup other) {
        return this.numTopicStores == other.numTopicStores && this.numPartitions == other.numPartitions && this.unflushThreshold == other.unflushThreshold && this.unflushInterval == other.unflushInterval && this.unflushDataHold == other.unflushDataHold && this.memCacheMsgSizeInMB == other.memCacheMsgSizeInMB && this.memCacheMsgCntInK == other.memCacheMsgCntInK && this.memCacheFlushIntvl == other.memCacheFlushIntvl && this.dataStoreType == other.dataStoreType && this.retPeriodInMs == other.retPeriodInMs && Objects.equals(this.acceptPublish, other.acceptPublish) && Objects.equals(this.acceptSubscribe, other.acceptSubscribe) && Objects.equals(this.dataPath, other.dataPath) && Objects.equals(this.deletePolicy, other.deletePolicy) && this.cleanPolicyType == other.cleanPolicyType;
    }

    public boolean updModifyInfo(TopicPropGroup other) {
        boolean changed = false;
        if (other.numTopicStores != -2 && this.numTopicStores != other.numTopicStores) {
            changed = true;
            this.numTopicStores = other.numTopicStores;
        }
        if (other.numPartitions != -2 && this.numPartitions != other.numPartitions) {
            changed = true;
            this.numPartitions = other.numPartitions;
        }
        if (other.unflushThreshold != -2 && this.unflushThreshold != other.unflushThreshold) {
            changed = true;
            this.unflushThreshold = other.unflushThreshold;
        }
        if (other.unflushInterval != -2 && this.unflushInterval != other.unflushInterval) {
            changed = true;
            this.unflushInterval = other.unflushInterval;
        }
        if (other.unflushDataHold != -2 && this.unflushDataHold != other.unflushDataHold) {
            changed = true;
            this.unflushDataHold = other.unflushDataHold;
        }
        if (other.memCacheMsgSizeInMB != -2 && this.memCacheMsgSizeInMB != other.memCacheMsgSizeInMB) {
            changed = true;
            this.memCacheMsgSizeInMB = other.memCacheMsgSizeInMB;
        }
        if (other.memCacheMsgCntInK != -2 && this.memCacheMsgCntInK != other.memCacheMsgCntInK) {
            changed = true;
            this.memCacheMsgCntInK = other.memCacheMsgCntInK;
        }
        if (other.memCacheFlushIntvl != -2 && this.memCacheFlushIntvl != other.memCacheFlushIntvl) {
            changed = true;
            this.memCacheFlushIntvl = other.memCacheFlushIntvl;
        }
        if (other.acceptPublish != null && !Objects.equals(this.acceptPublish, other.acceptPublish)) {
            changed = true;
            this.acceptPublish = other.acceptPublish;
        }
        if (other.acceptSubscribe != null && !Objects.equals(this.acceptSubscribe, other.acceptSubscribe)) {
            changed = true;
            this.acceptSubscribe = other.acceptSubscribe;
        }
        if (other.dataStoreType != -2 && this.dataStoreType != other.dataStoreType) {
            changed = true;
            this.dataStoreType = other.dataStoreType;
        }
        if (TStringUtils.isNotBlank((String)other.dataPath) && !Objects.equals(this.dataPath, other.dataPath)) {
            changed = true;
            this.dataPath = other.dataPath;
        }
        if (TStringUtils.isNotBlank((String)other.deletePolicy) && !Objects.equals(this.deletePolicy, other.deletePolicy)) {
            changed = true;
            this.setDeletePolicy(other.deletePolicy);
        }
        return changed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TopicPropGroup)) {
            return false;
        }
        TopicPropGroup that = (TopicPropGroup)o;
        return this.isDataEquals(that);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.numTopicStores, this.numPartitions, this.unflushThreshold, this.unflushInterval, this.unflushDataHold, this.memCacheMsgSizeInMB, this.memCacheMsgCntInK, this.memCacheFlushIntvl, this.acceptPublish, this.acceptSubscribe, this.dataStoreType, this.dataPath, this.deletePolicy, this.cleanPolicyType, this.retPeriodInMs});
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public TopicPropGroup clone() {
        try {
            return (TopicPropGroup)super.clone();
        }
        catch (Throwable e) {
            return null;
        }
    }

    private Tuple2<CleanPolType, Long> parseDelPolicy(String delPolicy) {
        long validDuration = 0L;
        String[] tmpStrs = delPolicy.split(",");
        String validValStr = tmpStrs[1];
        String timeUnit = validValStr.substring(validValStr.length() - 1).toLowerCase();
        validDuration = timeUnit.endsWith("s") ? Long.parseLong(validValStr.substring(0, validValStr.length() - 1)) * 1000L : (timeUnit.endsWith("m") ? Long.parseLong(validValStr.substring(0, validValStr.length() - 1)) * 60000L : (timeUnit.endsWith("h") ? Long.parseLong(validValStr.substring(0, validValStr.length() - 1)) * 3600000L : Long.parseLong(validValStr) * 3600000L));
        return new Tuple2((Object)CleanPolType.CLEAN_POL_DELETE, (Object)validDuration);
    }
}

