/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity;

import java.util.Map;
import java.util.Objects;
import org.apache.inlong.tubemq.corebase.utils.SettingValidUtils;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;
import org.apache.inlong.tubemq.server.common.statusdef.EnableStatus;
import org.apache.inlong.tubemq.server.master.bdbstore.bdbentitys.BdbClusterSettingEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.BaseEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.TopicPropGroup;

public class ClusterSettingEntity
extends BaseEntity
implements Cloneable {
    private final String recordKey = "default_cluster_config";
    private int brokerPort = -2;
    private int brokerTLSPort = -2;
    private int brokerWebPort = -2;
    private TopicPropGroup clsDefTopicProps = new TopicPropGroup();
    private int maxMsgSizeInB = -2;
    private int maxMsgSizeInMB = -2;
    private int qryPriorityId = -2;
    private EnableStatus gloFlowCtrlStatus = EnableStatus.STATUS_UNDEFINE;
    private int gloFlowCtrlRuleCnt = -2;
    private String gloFlowCtrlRuleInfo = "";

    public ClusterSettingEntity() {
    }

    public ClusterSettingEntity(BaseEntity opEntity) {
        super(opEntity);
    }

    public ClusterSettingEntity(BdbClusterSettingEntity bdbEntity) {
        super(bdbEntity.getConfigId(), bdbEntity.getCreateUser(), bdbEntity.getCreateDate(), bdbEntity.getModifyUser(), bdbEntity.getModifyDate());
        this.fillDefaultValue();
        TopicPropGroup defTopicProps = new TopicPropGroup(bdbEntity.getNumTopicStores(), bdbEntity.getNumPartitions(), bdbEntity.getUnflushThreshold(), bdbEntity.getUnflushInterval(), bdbEntity.getUnflushDataHold(), bdbEntity.getMemCacheMsgSizeInMB(), bdbEntity.getMemCacheMsgCntInK(), bdbEntity.getMemCacheFlushIntvl(), bdbEntity.isAcceptPublish(), bdbEntity.isAcceptSubscribe(), bdbEntity.getDeletePolicy(), bdbEntity.getDefDataType(), bdbEntity.getDefDataPath());
        this.updModifyInfo(bdbEntity.getConfigId(), bdbEntity.getBrokerPort(), bdbEntity.getBrokerTLSPort(), bdbEntity.getBrokerWebPort(), bdbEntity.getMaxMsgSizeInB() / 0x100000, bdbEntity.getQryPriorityId(), bdbEntity.getEnableGloFlowCtrl(), bdbEntity.getGloFlowCtrlCnt(), bdbEntity.getGloFlowCtrlInfo(), defTopicProps);
        this.setAttributes(bdbEntity.getAttributes());
    }

    public BdbClusterSettingEntity buildBdbClsDefSettingEntity() {
        BdbClusterSettingEntity bdbEntity = new BdbClusterSettingEntity("default_cluster_config", this.getDataVerId(), this.brokerPort, this.brokerTLSPort, this.brokerWebPort, this.clsDefTopicProps.getNumTopicStores(), this.clsDefTopicProps.getNumPartitions(), this.clsDefTopicProps.getUnflushThreshold(), this.clsDefTopicProps.getUnflushInterval(), this.clsDefTopicProps.getUnflushDataHold(), this.clsDefTopicProps.getMemCacheMsgCntInK(), this.clsDefTopicProps.getMemCacheFlushIntvl(), this.clsDefTopicProps.getMemCacheMsgSizeInMB(), this.clsDefTopicProps.isAcceptPublish(), this.clsDefTopicProps.isAcceptSubscribe(), this.clsDefTopicProps.getDeletePolicy(), this.qryPriorityId, this.maxMsgSizeInB, this.getAttributes(), this.getModifyUser(), this.getModifyDate());
        if (TStringUtils.isNotBlank((String)this.clsDefTopicProps.getDataPath())) {
            bdbEntity.setDefDataPath(this.clsDefTopicProps.getDataPath());
        }
        bdbEntity.setCreateInfo(this.getCreateUser(), this.getCreateDate());
        bdbEntity.setDefDataType(this.clsDefTopicProps.getDataStoreType());
        bdbEntity.setEnableGloFlowCtrl(this.enableFlowCtrl());
        bdbEntity.setGloFlowCtrlCnt(this.gloFlowCtrlRuleCnt);
        if (TStringUtils.isNotBlank((String)this.gloFlowCtrlRuleInfo)) {
            bdbEntity.setGloFlowCtrlInfo(this.gloFlowCtrlRuleInfo);
        }
        return bdbEntity;
    }

    public ClusterSettingEntity fillDefaultValue() {
        this.brokerPort = 8123;
        this.brokerTLSPort = 8124;
        this.brokerWebPort = 8081;
        this.maxMsgSizeInMB = 1;
        this.maxMsgSizeInB = SettingValidUtils.validAndXfeMaxMsgSizeFromMBtoB((int)this.maxMsgSizeInMB);
        this.qryPriorityId = 301;
        this.gloFlowCtrlStatus = EnableStatus.STATUS_DISABLE;
        this.gloFlowCtrlRuleCnt = 0;
        this.gloFlowCtrlRuleInfo = "[]";
        this.clsDefTopicProps.fillDefaultValue();
        return this;
    }

    public boolean updModifyInfo(long dataVerId, int brokerPort, int brokerTLSPort, int brokerWebPort, int maxMsgSizeMB, int qryPriorityId, EnableStatus flowCtrlEnable, int flowRuleCnt, String flowCtrlRuleInfo, TopicPropGroup defTopicProps) {
        int tmpMaxMsgSizeInMB;
        boolean changed = false;
        if (dataVerId != -2L && this.getDataVerId() != dataVerId) {
            changed = true;
            this.setDataVersionId(dataVerId);
        }
        if (brokerPort != -2 && this.brokerPort != brokerPort) {
            changed = true;
            this.brokerPort = brokerPort;
        }
        if (brokerTLSPort != -2 && this.brokerTLSPort != brokerTLSPort) {
            changed = true;
            this.brokerTLSPort = brokerTLSPort;
        }
        if (brokerWebPort != -2 && this.brokerWebPort != brokerWebPort) {
            changed = true;
            this.brokerWebPort = brokerWebPort;
        }
        if (maxMsgSizeMB != -2 && this.maxMsgSizeInMB != (tmpMaxMsgSizeInMB = SettingValidUtils.validAndGetMsgSizeInMB((int)maxMsgSizeMB))) {
            changed = true;
            this.maxMsgSizeInMB = tmpMaxMsgSizeInMB;
            this.maxMsgSizeInB = SettingValidUtils.validAndXfeMaxMsgSizeFromMBtoB((int)tmpMaxMsgSizeInMB);
        }
        if (qryPriorityId != -2 && this.qryPriorityId != qryPriorityId) {
            changed = true;
            this.qryPriorityId = qryPriorityId;
        }
        if (flowCtrlEnable != null && flowCtrlEnable != EnableStatus.STATUS_UNDEFINE && this.gloFlowCtrlStatus != flowCtrlEnable) {
            this.gloFlowCtrlStatus = flowCtrlEnable;
            changed = true;
        }
        if (TStringUtils.isNotBlank((String)flowCtrlRuleInfo) && !flowCtrlRuleInfo.equals(this.gloFlowCtrlRuleInfo)) {
            changed = true;
            this.setGloFlowCtrlInfo(flowRuleCnt, flowCtrlRuleInfo);
        }
        if (defTopicProps != null && !defTopicProps.isDataEquals(this.clsDefTopicProps) && this.clsDefTopicProps.updModifyInfo(defTopicProps)) {
            changed = true;
        }
        if (changed) {
            this.updSerialId();
        }
        return changed;
    }

    public String getRecordKey() {
        return "default_cluster_config";
    }

    public int getBrokerPort() {
        return this.brokerPort;
    }

    public int getBrokerTLSPort() {
        return this.brokerTLSPort;
    }

    public int getBrokerWebPort() {
        return this.brokerWebPort;
    }

    public int getMaxMsgSizeInB() {
        return this.maxMsgSizeInB;
    }

    public int getMaxMsgSizeInMB() {
        return this.maxMsgSizeInMB;
    }

    public int getQryPriorityId() {
        return this.qryPriorityId;
    }

    public EnableStatus getGloFlowCtrlStatus() {
        return this.gloFlowCtrlStatus;
    }

    public int getGloFlowCtrlRuleCnt() {
        return this.gloFlowCtrlRuleCnt;
    }

    public String getGloFlowCtrlRuleInfo() {
        return this.gloFlowCtrlRuleInfo;
    }

    public boolean enableFlowCtrl() {
        return this.gloFlowCtrlStatus == EnableStatus.STATUS_ENABLE;
    }

    public TopicPropGroup getClsDefTopicProps() {
        return this.clsDefTopicProps;
    }

    public boolean isDataEquals(ClusterSettingEntity other) {
        return super.isDataEquals(other) && this.brokerPort == other.brokerPort && this.brokerTLSPort == other.brokerTLSPort && this.brokerWebPort == other.brokerWebPort && this.maxMsgSizeInB == other.maxMsgSizeInB && this.qryPriorityId == other.qryPriorityId && this.gloFlowCtrlRuleCnt == other.gloFlowCtrlRuleCnt && Objects.equals(this.clsDefTopicProps, other.clsDefTopicProps) && this.gloFlowCtrlStatus == other.gloFlowCtrlStatus && Objects.equals(this.gloFlowCtrlRuleInfo, other.gloFlowCtrlRuleInfo);
    }

    public StringBuilder toWebJsonStr(StringBuilder sBuilder, boolean isLongName, boolean fullFormat) {
        if (isLongName) {
            sBuilder.append("{\"brokerPort\":").append(this.brokerPort).append(",\"brokerTLSPort\":").append(this.brokerTLSPort).append(",\"brokerWebPort\":").append(this.brokerWebPort).append(",\"maxMsgSizeInMB\":").append(this.maxMsgSizeInMB).append(",\"qryPriorityId\":").append(this.qryPriorityId).append(",\"flowCtrlEnable\":").append(this.gloFlowCtrlStatus.isEnable()).append(",\"flowCtrlRuleCount\":").append(this.gloFlowCtrlRuleCnt).append(",\"flowCtrlInfo\":").append(this.gloFlowCtrlRuleInfo);
        } else {
            sBuilder.append("{\"bPort\":").append(this.brokerPort).append(",\"bTlsPort\":").append(this.brokerTLSPort).append(",\"bWebPort\":").append(this.brokerWebPort).append(",\"mxMsgInMB\":").append(this.maxMsgSizeInMB).append(",\"qryPriId\":").append(this.qryPriorityId).append(",\"fCtrlEn\":").append(this.gloFlowCtrlStatus.isEnable()).append(",\"fCtrlCnt\":").append(this.gloFlowCtrlRuleCnt).append(",\"fCtrlInfo\":").append(this.gloFlowCtrlRuleInfo);
        }
        this.clsDefTopicProps.toWebJsonStr(sBuilder, isLongName);
        super.toWebJsonStr(sBuilder, isLongName);
        if (fullFormat) {
            sBuilder.append("}");
        }
        return sBuilder;
    }

    @Override
    public void getConfigureInfo(Map<String, String> paramMap, boolean isLongName) {
        if (this.brokerPort != -2) {
            paramMap.put(isLongName ? "brokerPort" : "bPort", String.valueOf(this.brokerPort));
        }
        if (this.brokerTLSPort != -2) {
            paramMap.put(isLongName ? "brokerTLSPort" : "bTlsPort", String.valueOf(this.brokerTLSPort));
        }
        if (this.brokerWebPort != -2) {
            paramMap.put(isLongName ? "brokerWebPort" : "bWebPort", String.valueOf(this.brokerWebPort));
        }
        if (this.maxMsgSizeInMB != -2) {
            paramMap.put(isLongName ? "maxMsgSizeInMB" : "mxMsgInMB", String.valueOf(this.maxMsgSizeInMB));
        }
        if (this.qryPriorityId != -2) {
            paramMap.put(isLongName ? "qryPriorityId" : "qryPriId", String.valueOf(this.qryPriorityId));
        }
        if (this.gloFlowCtrlStatus != EnableStatus.STATUS_UNDEFINE) {
            paramMap.put(isLongName ? "flowCtrlEnable" : "fCtrlEn", String.valueOf(this.gloFlowCtrlStatus.isEnable()));
        }
        if (this.gloFlowCtrlRuleCnt != -2) {
            paramMap.put(isLongName ? "flowCtrlRuleCount" : "fCtrlCnt", String.valueOf(this.gloFlowCtrlRuleCnt));
        }
        if (TStringUtils.isNotBlank((String)this.gloFlowCtrlRuleInfo)) {
            paramMap.put(isLongName ? "flowCtrlInfo" : "fCtrlInfo", this.gloFlowCtrlRuleInfo);
        }
        this.clsDefTopicProps.getConfigureInfo(paramMap, isLongName);
        super.getConfigureInfo(paramMap, isLongName);
    }

    public StringBuilder toOldVerFlowCtrlWebJsonStr(StringBuilder sBuilder, boolean isLongName) {
        int statusId;
        int n = statusId = this.gloFlowCtrlStatus.isEnable() ? 1 : 0;
        if (isLongName) {
            sBuilder.append("{\"statusId\":").append(statusId).append(",\"maxMsgSizeInMB\":").append(this.maxMsgSizeInMB).append(",\"qryPriorityId\":").append(this.qryPriorityId).append(",\"ruleCnt\":").append(this.gloFlowCtrlRuleCnt).append(",\"flowCtrlInfo\":").append(this.gloFlowCtrlRuleInfo);
        } else {
            sBuilder.append("{\"statusId\":").append(statusId).append(",\"mxMsgInMB\":").append(this.maxMsgSizeInMB).append(",\"qryPriId\":").append(this.qryPriorityId).append(",\"fCtrlCnt\":").append(this.gloFlowCtrlRuleCnt).append(",\"fCtrlInfo\":").append(this.gloFlowCtrlRuleInfo);
        }
        super.toWebJsonStr(sBuilder, isLongName);
        sBuilder.append("}");
        return sBuilder;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClusterSettingEntity)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterSettingEntity entity = (ClusterSettingEntity)o;
        return this.isDataEquals(entity);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), "default_cluster_config", this.brokerPort, this.brokerTLSPort, this.brokerWebPort, this.clsDefTopicProps, this.maxMsgSizeInB, this.qryPriorityId, this.gloFlowCtrlStatus, this.gloFlowCtrlRuleCnt, this.gloFlowCtrlRuleInfo});
    }

    @Override
    public ClusterSettingEntity clone() {
        ClusterSettingEntity copy = (ClusterSettingEntity)super.clone();
        copy.setGloFlowCtrlStatus(this.getGloFlowCtrlStatus());
        copy.setClsDefTopicProps(this.getClsDefTopicProps().clone());
        return copy;
    }

    private void setGloFlowCtrlStatus(EnableStatus gloFlowCtrlStatus) {
        if (gloFlowCtrlStatus != null) {
            this.gloFlowCtrlStatus = gloFlowCtrlStatus;
        }
    }

    private void setGloFlowCtrlInfo(int flowCtrlCnt, String flowCtrlInfo) {
        this.gloFlowCtrlRuleCnt = flowCtrlCnt;
        this.gloFlowCtrlRuleInfo = flowCtrlInfo;
    }

    private void setClsDefTopicProps(TopicPropGroup clsDefTopicProps) {
        this.clsDefTopicProps = clsDefTopicProps;
    }
}

