/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.bdbstore.bdbentitys;

import com.sleepycat.persist.model.Entity;
import com.sleepycat.persist.model.PrimaryKey;
import java.io.Serializable;
import java.util.Date;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.inlong.tubemq.corebase.utils.DateTimeConvertUtils;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;

@Entity
public class BdbBlackGroupEntity
implements Serializable {
    private static final long serialVersionUID = 6081445397689294316L;
    @PrimaryKey
    private String recordKey;
    private String topicName;
    private String consumerGroupName;
    private String createUser;
    private Date createDate;
    private String attributes;

    public BdbBlackGroupEntity() {
    }

    public BdbBlackGroupEntity(String topicName, String consumerGroupName, String createUser, Date createDate) {
        this.recordKey = new StringBuilder(512).append(topicName).append(":").append(consumerGroupName).toString();
        this.topicName = topicName;
        this.consumerGroupName = consumerGroupName;
        this.createUser = createUser;
        this.createDate = createDate;
    }

    public BdbBlackGroupEntity(String topicName, String groupName, String attributes, String createUser, Date createDate) {
        this.recordKey = new StringBuilder(512).append(topicName).append(":").append(this.consumerGroupName).toString();
        this.topicName = topicName;
        this.consumerGroupName = groupName;
        this.attributes = attributes;
        this.createUser = createUser;
        this.createDate = createDate;
    }

    public String getAttributes() {
        return this.attributes;
    }

    public void setAttributes(String attributes) {
        this.attributes = attributes;
    }

    public String getBlackRecordKey() {
        return this.recordKey;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    public String getBlackGroupName() {
        return this.consumerGroupName;
    }

    public void setBlackGroupName(String consumerGroupName) {
        this.consumerGroupName = consumerGroupName;
    }

    public String getCreateUser() {
        return this.createUser;
    }

    public void setCreateUser(String createUser) {
        this.createUser = createUser;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public long getDataVerId() {
        String atrVal = TStringUtils.getAttrValFrmAttributes((String)this.attributes, (String)"dataVerId");
        if (atrVal != null) {
            return Long.parseLong(atrVal);
        }
        return -2L;
    }

    public void setDataVerId(long dataVerId) {
        this.attributes = TStringUtils.setAttrValToAttributes((String)this.attributes, (String)"dataVerId", (String)String.valueOf(dataVerId));
    }

    public void setReason(String reason) {
        this.attributes = TStringUtils.setAttrValToAttributes((String)this.attributes, (String)"reason", (String)reason);
    }

    public String getReason() {
        return TStringUtils.getAttrValFrmAttributes((String)this.attributes, (String)"reason");
    }

    public StringBuilder toJsonString(StringBuilder sBuilder) {
        return sBuilder.append("{\"type\":\"BdbBlackGroupEntity\",").append("\"recordKey\":\"").append(this.recordKey).append("\",\"topicName\":\"").append(this.topicName).append("\",\"consumerGroupName\":\"").append(this.consumerGroupName).append("\",\"attributes\":\"").append(this.attributes).append("\",\"createUser\":\"").append(this.createUser).append("\",\"createDate\":\"").append(DateTimeConvertUtils.date2yyyyMMddHHmmss((Date)this.createDate)).append("\"}");
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("recordKey", (Object)this.recordKey).append("topicName", (Object)this.topicName).append("consumerGroupName", (Object)this.consumerGroupName).append("createUser", (Object)this.createUser).append("createDate", (Object)this.createDate).append("attributes", (Object)this.attributes).toString();
    }
}

