/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.common.zookeeper;

import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryCounter {
    private static final Logger logger = LoggerFactory.getLogger(RetryCounter.class);
    private final int maxRetries;
    private final int retryIntervalMillis;
    private final TimeUnit timeUnit;
    private int retriesRemaining;

    public RetryCounter(int maxRetries, int retryIntervalMillis, TimeUnit timeUnit) {
        this.maxRetries = maxRetries;
        this.retriesRemaining = maxRetries;
        this.retryIntervalMillis = retryIntervalMillis;
        this.timeUnit = timeUnit;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void sleepUntilNextRetry() throws InterruptedException {
        int attempts = this.getAttemptTimes();
        long sleepTime = (long)((double)this.retryIntervalMillis * Math.pow(2.0, attempts));
        logger.info("Sleeping " + sleepTime + "ms before retry #" + attempts + "...");
        this.timeUnit.sleep(sleepTime);
    }

    public boolean shouldRetry() {
        return this.retriesRemaining > 0;
    }

    public void useRetry() {
        --this.retriesRemaining;
    }

    public int getAttemptTimes() {
        return this.maxRetries - this.retriesRemaining + 1;
    }
}

