/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.store.service.consume;

import com.google.gson.Gson;
import java.util.List;
import org.apache.inlong.audit.protocol.AuditData;
import org.apache.inlong.audit.store.config.MessageQueueConfig;
import org.apache.inlong.audit.store.config.StoreConfig;
import org.apache.inlong.audit.store.metric.MetricsManager;
import org.apache.inlong.audit.store.service.InsertData;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.MessageId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseConsume {
    private static final Logger LOG = LoggerFactory.getLogger(BaseConsume.class);
    private final Gson gson = new Gson();
    protected List<InsertData> insertServiceList;
    protected StoreConfig storeConfig;
    protected MessageQueueConfig mqConfig;

    public BaseConsume(List<InsertData> insertServiceList, StoreConfig storeConfig, MessageQueueConfig mqConfig) {
        this.insertServiceList = insertServiceList;
        this.storeConfig = storeConfig;
        this.mqConfig = mqConfig;
    }

    public abstract void start();

    protected void handleMessage(String body) throws Exception {
        AuditData msgBody = (AuditData)this.gson.fromJson(body, AuditData.class);
        MetricsManager.getInstance().addReceiveSuccess(1L);
        this.insertServiceList.forEach(service -> {
            try {
                service.insert(msgBody);
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        });
    }

    protected void handleMessage(String body, Consumer<byte[]> consumer, MessageId messageId) {
        AuditData msgBody = (AuditData)this.gson.fromJson(body, AuditData.class);
        MetricsManager.getInstance().addReceiveSuccess(1L);
        this.insertServiceList.forEach(service -> {
            try {
                service.insert(msgBody, consumer, messageId);
            }
            catch (Exception e) {
                LOG.error("Handle message has exception!", (Throwable)e);
            }
        });
    }
}

