/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.ReadableByteChannel;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.net.Peer;
import org.apache.hadoop.hdfs.protocol.datatransfer.IOStreamPair;
import org.apache.hadoop.net.unix.DomainSocket;

@InterfaceAudience.Private
public class EncryptedPeer
implements Peer {
    private final Peer enclosedPeer;
    private final InputStream in;
    private final OutputStream out;
    private final ReadableByteChannel channel;

    public EncryptedPeer(Peer enclosedPeer, IOStreamPair ios) {
        this.enclosedPeer = enclosedPeer;
        this.in = ios.in;
        this.out = ios.out;
        this.channel = ios.in instanceof ReadableByteChannel ? (ReadableByteChannel)((Object)ios.in) : null;
    }

    @Override
    public ReadableByteChannel getInputStreamChannel() {
        return this.channel;
    }

    @Override
    public void setReadTimeout(int timeoutMs) throws IOException {
        this.enclosedPeer.setReadTimeout(timeoutMs);
    }

    @Override
    public int getReceiveBufferSize() throws IOException {
        return this.enclosedPeer.getReceiveBufferSize();
    }

    @Override
    public boolean getTcpNoDelay() throws IOException {
        return this.enclosedPeer.getTcpNoDelay();
    }

    @Override
    public void setWriteTimeout(int timeoutMs) throws IOException {
        this.enclosedPeer.setWriteTimeout(timeoutMs);
    }

    @Override
    public boolean isClosed() {
        return this.enclosedPeer.isClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.in.close();
        }
        finally {
            try {
                this.out.close();
            }
            finally {
                this.enclosedPeer.close();
            }
        }
    }

    @Override
    public String getRemoteAddressString() {
        return this.enclosedPeer.getRemoteAddressString();
    }

    @Override
    public String getLocalAddressString() {
        return this.enclosedPeer.getLocalAddressString();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.in;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.out;
    }

    @Override
    public boolean isLocal() {
        return this.enclosedPeer.isLocal();
    }

    public String toString() {
        return "EncryptedPeer(" + this.enclosedPeer + ")";
    }

    @Override
    public DomainSocket getDomainSocket() {
        return this.enclosedPeer.getDomainSocket();
    }

    @Override
    public boolean hasSecureChannel() {
        return true;
    }
}

