/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.common.pojo.sort.dataflow.field.format;

import java.util.Arrays;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.TypeInfo;

public class RowTypeInfo
implements TypeInfo {
    private static final long serialVersionUID = 1L;
    private static final String FIELD_FIELD_NAMES = "fieldNames";
    private static final String FIELD_FIELD_TYPES = "fieldTypes";
    private static final String FIELD_FIELD_DESCRIPTIONS = "fieldDescriptions";
    public static final RowTypeInfo EMPTY = new RowTypeInfo(new String[0], new TypeInfo[0], new String[0]);
    @JsonProperty(value="fieldNames")
    @Nonnull
    private final String[] fieldNames;
    @JsonProperty(value="fieldTypes")
    @Nonnull
    private final TypeInfo[] fieldTypeInfos;
    @JsonProperty(value="fieldDescriptions")
    @Nonnull
    private final String[] fieldDescriptions;

    @JsonCreator
    public RowTypeInfo(@JsonProperty(value="fieldNames") @Nonnull String[] fieldNames, @JsonProperty(value="fieldTypes") @Nonnull TypeInfo[] fieldTypeInfos, @JsonProperty(value="fieldDescriptions") @Nonnull String[] fieldDescriptions) {
        RowTypeInfo.checkArity(fieldNames, fieldTypeInfos, fieldDescriptions);
        RowTypeInfo.checkDuplicates(fieldNames);
        this.fieldNames = fieldNames;
        this.fieldTypeInfos = fieldTypeInfos;
        this.fieldDescriptions = fieldDescriptions;
    }

    private static void checkArity(String[] fieldNames, TypeInfo[] fieldTypeInfos, String[] fieldDescriptions) {
        if (fieldNames.length != fieldTypeInfos.length) {
            throw new IllegalArgumentException(String.format("The number of names and types is not equal. FieldNames: %s, filedTypes: %s", Arrays.toString(fieldNames), Arrays.toString(fieldTypeInfos)));
        }
        if (fieldDescriptions.length != fieldTypeInfos.length) {
            throw new IllegalArgumentException(String.format("The number of descriptions and types is not equal. FieldDescriptions: %s, filedTypes: %s", Arrays.toString(fieldDescriptions), Arrays.toString(fieldTypeInfos)));
        }
        if (fieldDescriptions.length != fieldNames.length) {
            throw new IllegalArgumentException(String.format("The number of descriptions and names is not equal. FieldDescriptions: %s, filedNames: %s", Arrays.toString(fieldDescriptions), Arrays.toString(fieldNames)));
        }
    }

    @Nonnull
    public String[] getFieldNames() {
        return this.fieldNames;
    }

    @Nonnull
    public TypeInfo[] getFieldTypeInfos() {
        return this.fieldTypeInfos;
    }

    @Nonnull
    public String[] getFieldDescriptions() {
        return this.fieldDescriptions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RowTypeInfo that = (RowTypeInfo)o;
        return Arrays.equals(this.fieldNames, that.fieldNames) && Arrays.equals(this.fieldTypeInfos, that.fieldTypeInfos) && Arrays.equals(this.fieldDescriptions, that.fieldDescriptions);
    }

    public int hashCode() {
        return Arrays.hashCode(this.fieldTypeInfos);
    }

    public String toString() {
        return "RowTypeInfo{fieldNames=" + Arrays.toString(this.fieldNames) + "fieldTypeInfos=" + Arrays.toString(this.fieldTypeInfos) + "fieldDescriptions=" + Arrays.toString(this.fieldDescriptions) + '}';
    }

    private static void checkDuplicates(String[] fieldNames) {
        long numFieldNames = fieldNames.length;
        long numDistinctFieldNames = Arrays.stream(fieldNames).collect(Collectors.toSet()).size();
        if (numDistinctFieldNames != numFieldNames) {
            throw new IllegalArgumentException("There exist duplicated field names.");
        }
    }
}

