/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.memory;

import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.LongConsumer;
import javax.annotation.concurrent.GuardedBy;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.memory.MemoryAllocationException;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.LongFunctionWithException;

final class SharedResources {
    private final ReentrantLock lock = new ReentrantLock();
    @GuardedBy(value="lock")
    private final HashMap<String, LeasedResource<?>> reservedResources = new HashMap();

    SharedResources() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T extends AutoCloseable> ResourceAndSize<T> getOrAllocateSharedResource(String type, Object leaseHolder, LongFunctionWithException<T, Exception> initializer, long sizeForInitialization) throws Exception {
        try {
            this.lock.lockInterruptibly();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new MemoryAllocationException("Interrupted while acquiring memory");
        }
        try {
            LeasedResource<Object> resource = this.reservedResources.get(type);
            if (resource == null) {
                resource = SharedResources.createResource(initializer, sizeForInitialization);
                this.reservedResources.put(type, resource);
            }
            resource.addLeaseHolder(leaseHolder);
            LeasedResource<Object> leasedResource = resource;
            return leasedResource;
        }
        finally {
            this.lock.unlock();
        }
    }

    void release(String type, Object leaseHolder) throws Exception {
        this.release(type, leaseHolder, value -> {});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release(String type, Object leaseHolder, LongConsumer releaser) throws Exception {
        block8: {
            this.lock.lock();
            try {
                LeasedResource<?> resource = this.reservedResources.get(type);
                if (resource == null) {
                    return;
                }
                if (!resource.removeLeaseHolder(leaseHolder)) break block8;
                try {
                    this.reservedResources.remove(type);
                    resource.dispose();
                }
                finally {
                    releaser.accept(resource.size());
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    @VisibleForTesting
    int getNumResources() {
        return this.reservedResources.size();
    }

    private static <T extends AutoCloseable> LeasedResource<T> createResource(LongFunctionWithException<T, Exception> initializer, long size) throws Exception {
        AutoCloseable resource = (AutoCloseable)initializer.apply(size);
        return new LeasedResource(resource, size, null);
    }

    private static final class LeasedResource<T extends AutoCloseable>
    implements ResourceAndSize<T> {
        private final HashSet<Object> leaseHolders = new HashSet();
        private final T resourceHandle;
        private final long size;
        private boolean disposed;

        private LeasedResource(T resourceHandle, long size) {
            this.resourceHandle = resourceHandle;
            this.size = size;
        }

        @Override
        public T resourceHandle() {
            return this.resourceHandle;
        }

        @Override
        public long size() {
            return this.size;
        }

        void addLeaseHolder(Object leaseHolder) {
            Preconditions.checkState((!this.disposed ? 1 : 0) != 0);
            this.leaseHolders.add(leaseHolder);
        }

        boolean removeLeaseHolder(Object leaseHolder) {
            Preconditions.checkState((!this.disposed ? 1 : 0) != 0);
            this.leaseHolders.remove(leaseHolder);
            return this.leaseHolders.isEmpty();
        }

        void dispose() throws Exception {
            if (!this.disposed) {
                this.disposed = true;
                this.resourceHandle.close();
            }
        }

        /* synthetic */ LeasedResource(AutoCloseable x0, long x1, 1 x2) {
            this(x0, x1);
        }
    }

    static interface ResourceAndSize<T extends AutoCloseable> {
        public T resourceHandle();

        public long size();
    }
}

