/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import javax.annotation.Nullable;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferBuilder;
import org.apache.flink.runtime.io.network.buffer.BufferConsumer;
import org.apache.flink.runtime.io.network.buffer.BufferPool;
import org.apache.flink.runtime.io.network.buffer.FreeingBufferRecycler;
import org.apache.flink.runtime.io.network.buffer.NetworkBuffer;
import org.apache.flink.runtime.io.network.partition.BufferWithChannel;
import org.apache.flink.runtime.io.network.partition.DataBuffer;
import org.apache.flink.util.Preconditions;

public class HashBasedDataBuffer
implements DataBuffer {
    private final BufferPool bufferPool;
    private final int numGuaranteedBuffers;
    private final ArrayDeque<BufferConsumer>[] buffers;
    private long numTotalBytes;
    private long numTotalRecords;
    private boolean isFull;
    private boolean isFinished;
    private boolean isReleased;
    private final BufferBuilder[] builders;
    private int numBuffersOccupied;
    private int readOrderIndex;
    private final int[] subpartitionReadOrder;
    private long numTotalBytesRead;

    public HashBasedDataBuffer(BufferPool bufferPool, int numSubpartitions, int numGuaranteedBuffers, @Nullable int[] customReadOrder) {
        int channel;
        Preconditions.checkArgument((numGuaranteedBuffers > 0 ? 1 : 0) != 0, (Object)"No guaranteed buffers for sort.");
        this.bufferPool = (BufferPool)Preconditions.checkNotNull((Object)bufferPool);
        this.numGuaranteedBuffers = numGuaranteedBuffers;
        this.builders = new BufferBuilder[numSubpartitions];
        this.buffers = new ArrayDeque[numSubpartitions];
        for (channel = 0; channel < numSubpartitions; ++channel) {
            this.buffers[channel] = new ArrayDeque();
        }
        this.subpartitionReadOrder = new int[numSubpartitions];
        if (customReadOrder != null) {
            Preconditions.checkArgument((customReadOrder.length == numSubpartitions ? 1 : 0) != 0, (Object)"Illegal data read order.");
            System.arraycopy(customReadOrder, 0, this.subpartitionReadOrder, 0, numSubpartitions);
        } else {
            for (channel = 0; channel < numSubpartitions; ++channel) {
                this.subpartitionReadOrder[channel] = channel;
            }
        }
    }

    @Override
    public boolean append(ByteBuffer source, int targetChannel, Buffer.DataType dataType) throws IOException {
        Preconditions.checkArgument((boolean)source.hasRemaining(), (Object)"Cannot append empty data.");
        Preconditions.checkState((!this.isFull ? 1 : 0) != 0, (Object)"Sort buffer is already full.");
        Preconditions.checkState((!this.isFinished ? 1 : 0) != 0, (Object)"Sort buffer is already finished.");
        Preconditions.checkState((!this.isReleased ? 1 : 0) != 0, (Object)"Sort buffer is already released.");
        int totalBytes = source.remaining();
        if (dataType.isBuffer()) {
            this.writeRecord(source, targetChannel);
        } else {
            this.writeEvent(source, targetChannel, dataType);
        }
        this.isFull = source.hasRemaining();
        if (!this.isFull) {
            ++this.numTotalRecords;
        }
        this.numTotalBytes += (long)(totalBytes - source.remaining());
        return this.isFull;
    }

    private void writeEvent(ByteBuffer source, int targetChannel, Buffer.DataType dataType) {
        BufferBuilder builder = this.builders[targetChannel];
        if (builder != null) {
            builder.finish();
            this.buffers[targetChannel].add(builder.createBufferConsumerFromBeginning());
            builder.close();
            this.builders[targetChannel] = null;
        }
        MemorySegment segment = MemorySegmentFactory.allocateUnpooledOffHeapMemory((int)source.remaining());
        segment.put(0, source, segment.size());
        BufferConsumer consumer = new BufferConsumer(new NetworkBuffer(segment, FreeingBufferRecycler.INSTANCE, dataType), segment.size());
        this.buffers[targetChannel].add(consumer);
    }

    private void writeRecord(ByteBuffer source, int targetChannel) throws IOException {
        do {
            BufferBuilder builder;
            if ((builder = this.builders[targetChannel]) == null) {
                builder = this.requestBufferFromPool();
                if (builder == null) break;
                ++this.numBuffersOccupied;
                this.builders[targetChannel] = builder;
            }
            builder.append(source);
            if (!builder.isFull()) continue;
            builder.finish();
            this.buffers[targetChannel].add(builder.createBufferConsumerFromBeginning());
            builder.close();
            this.builders[targetChannel] = null;
        } while (source.hasRemaining());
    }

    private BufferBuilder requestBufferFromPool() throws IOException {
        try {
            if (this.numBuffersOccupied < this.numGuaranteedBuffers) {
                return this.bufferPool.requestBufferBuilderBlocking();
            }
        }
        catch (InterruptedException e) {
            throw new IOException("Interrupted while requesting buffer.", e);
        }
        return this.bufferPool.requestBufferBuilder();
    }

    @Override
    public BufferWithChannel getNextBuffer(MemorySegment transitBuffer) {
        Preconditions.checkState((boolean)this.isFull, (Object)"Sort buffer is not ready to be read.");
        Preconditions.checkState((!this.isReleased ? 1 : 0) != 0, (Object)"Sort buffer is already released.");
        BufferWithChannel buffer = null;
        if (!this.hasRemaining() || this.readOrderIndex >= this.subpartitionReadOrder.length) {
            return null;
        }
        int targetChannel = this.subpartitionReadOrder[this.readOrderIndex];
        while (buffer == null) {
            BufferConsumer consumer = this.buffers[targetChannel].poll();
            if (consumer != null) {
                buffer = new BufferWithChannel(consumer.build(), targetChannel);
                this.numBuffersOccupied -= buffer.getBuffer().isBuffer() ? 1 : 0;
                this.numTotalBytesRead += (long)buffer.getBuffer().readableBytes();
                consumer.close();
                continue;
            }
            if (++this.readOrderIndex >= this.subpartitionReadOrder.length) break;
            targetChannel = this.subpartitionReadOrder[this.readOrderIndex];
        }
        return buffer;
    }

    @Override
    public long numTotalRecords() {
        return this.numTotalRecords;
    }

    @Override
    public long numTotalBytes() {
        return this.numTotalBytes;
    }

    @Override
    public boolean hasRemaining() {
        return this.numTotalBytesRead < this.numTotalBytes;
    }

    @Override
    public void reset() {
        Preconditions.checkState((!this.isFinished ? 1 : 0) != 0, (Object)"Sort buffer has been finished.");
        Preconditions.checkState((!this.isReleased ? 1 : 0) != 0, (Object)"Sort buffer has been released.");
        this.isFull = false;
        this.readOrderIndex = 0;
    }

    @Override
    public void finish() {
        Preconditions.checkState((!this.isFull ? 1 : 0) != 0, (Object)"DataBuffer must not be full.");
        Preconditions.checkState((!this.isFinished ? 1 : 0) != 0, (Object)"DataBuffer is already finished.");
        this.isFull = true;
        this.isFinished = true;
        for (int channel = 0; channel < this.builders.length; ++channel) {
            BufferBuilder builder = this.builders[channel];
            if (builder == null) continue;
            builder.finish();
            this.buffers[channel].add(builder.createBufferConsumerFromBeginning());
            builder.close();
            this.builders[channel] = null;
        }
    }

    @Override
    public boolean isFinished() {
        return this.isFinished;
    }

    @Override
    public void release() {
        if (this.isReleased) {
            return;
        }
        this.isReleased = true;
        for (int channel = 0; channel < this.builders.length; ++channel) {
            BufferBuilder builder = this.builders[channel];
            if (builder == null) continue;
            builder.close();
            this.builders[channel] = null;
        }
        for (ArrayDeque<BufferConsumer> buffer : this.buffers) {
            BufferConsumer consumer = buffer.poll();
            while (consumer != null) {
                consumer.close();
                consumer = buffer.poll();
            }
        }
    }

    @Override
    public boolean isReleased() {
        return this.isReleased;
    }
}

