/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.corebase.cluster;

import java.io.Serializable;
import java.util.Set;

public class ProducerInfo
implements Serializable {
    private static final long serialVersionUID = 8324918571047041166L;
    private final Set<String> topicSet;
    private final String host;
    private String producerId;
    private boolean overTLS = false;

    public ProducerInfo(String producerId, Set<String> topicSet, String host, boolean overTLS) {
        this.producerId = producerId;
        this.topicSet = topicSet;
        this.host = host;
        this.overTLS = overTLS;
    }

    public String getProducerId() {
        return this.producerId;
    }

    public void setProducerId(String producerId) {
        this.producerId = producerId;
    }

    public Set<String> getTopicSet() {
        return this.topicSet;
    }

    public void appendTopicSet(Set<String> topicSet) {
        this.topicSet.addAll(topicSet);
    }

    public boolean isOverTLS() {
        return this.overTLS;
    }

    public String getHost() {
        return this.host;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(512);
        builder.append(this.producerId);
        builder.append("#");
        int cnt = 0;
        for (String topic : this.topicSet) {
            builder.append(topic);
            if (cnt == this.topicSet.size() - 1) continue;
            builder.append(":");
        }
        builder.append("@overTLS=").append(this.overTLS);
        return builder.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProducerInfo other = (ProducerInfo)obj;
        return this.producerId.equals(other.producerId) && this.topicSet.equals(other.topicSet);
    }
}

