/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.corebase.cluster;

import java.io.Serializable;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;

public class NodeAddrInfo
implements Comparable<NodeAddrInfo>,
Serializable {
    private static final long serialVersionUID = -1L;
    private String hostPortStr;
    private String host;
    private int port;

    public NodeAddrInfo(String host, int port) {
        if (TStringUtils.isBlank(host)) {
            throw new IllegalArgumentException("Argument host is Blank!");
        }
        this.host = host.trim();
        this.port = port;
        this.hostPortStr = new StringBuilder(256).append(host).append(":").append(port).toString();
    }

    public NodeAddrInfo(String host, int port, String hostPortStr) {
        if (TStringUtils.isBlank(host)) {
            throw new IllegalArgumentException("Argument host is Blank!");
        }
        if (TStringUtils.isBlank(hostPortStr)) {
            throw new IllegalArgumentException("Argument hostPortStr is Blank!");
        }
        this.host = host.trim();
        this.port = port;
        this.hostPortStr = hostPortStr.trim();
    }

    public String getHostPortStr() {
        return this.hostPortStr;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    @Override
    public int compareTo(NodeAddrInfo o) {
        if (!this.host.equals(o.host)) {
            return this.host.compareTo(o.host);
        }
        if (this.port != o.port) {
            return this.port > o.port ? 1 : -1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NodeAddrInfo)) {
            return false;
        }
        NodeAddrInfo that = (NodeAddrInfo)o;
        if (this.port != that.port) {
            return false;
        }
        return this.host.equals(that.host);
    }

    public int hashCode() {
        int result = this.host.hashCode();
        result = 31 * result + this.port;
        return result;
    }

    public String toString() {
        return this.hostPortStr;
    }
}

