/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.iceberg.BaseIncrementalScan;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.IncrementalAppendScan;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestGroup;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScanContext;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.relocated.com.google.common.collect.FluentIterable;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.util.SnapshotUtil;
import org.apache.iceberg.util.TableScanUtil;

class BaseIncrementalAppendScan
extends BaseIncrementalScan<IncrementalAppendScan, FileScanTask, CombinedScanTask>
implements IncrementalAppendScan {
    BaseIncrementalAppendScan(Table table, Schema schema, TableScanContext context) {
        super(table, schema, context);
    }

    @Override
    protected IncrementalAppendScan newRefinedScan(Table newTable, Schema newSchema, TableScanContext newContext) {
        return new BaseIncrementalAppendScan(newTable, newSchema, newContext);
    }

    @Override
    protected CloseableIterable<FileScanTask> doPlanFiles(Long fromSnapshotIdExclusive, long toSnapshotIdInclusive) {
        List<Snapshot> snapshots = BaseIncrementalAppendScan.appendsBetween(this.table(), fromSnapshotIdExclusive, toSnapshotIdInclusive);
        if (snapshots.isEmpty()) {
            return CloseableIterable.empty();
        }
        return this.appendFilesFromSnapshots(snapshots);
    }

    public CloseableIterable<CombinedScanTask> planTasks() {
        CloseableIterable fileScanTasks = this.planFiles();
        CloseableIterable<FileScanTask> splitFiles = TableScanUtil.splitFiles(fileScanTasks, this.targetSplitSize());
        return TableScanUtil.planTasks(splitFiles, this.targetSplitSize(), this.splitLookback(), this.splitOpenFileCost());
    }

    private CloseableIterable<FileScanTask> appendFilesFromSnapshots(List<Snapshot> snapshots) {
        HashSet snapshotIds = Sets.newHashSet((Iterable)Iterables.transform(snapshots, Snapshot::snapshotId));
        ImmutableSet manifests = FluentIterable.from(snapshots).transformAndConcat(snapshot -> snapshot.dataManifests(this.table().io())).filter(manifestFile -> snapshotIds.contains(manifestFile.snapshotId())).toSet();
        ManifestGroup manifestGroup = new ManifestGroup(this.table().io(), (Iterable<ManifestFile>)manifests).caseSensitive(this.isCaseSensitive()).select(this.scanColumns()).filterData(this.filter()).filterManifestEntries(manifestEntry -> snapshotIds.contains(manifestEntry.snapshotId()) && manifestEntry.status() == ManifestEntry.Status.ADDED).specsById(this.table().specs()).ignoreDeleted();
        if (this.context().ignoreResiduals()) {
            manifestGroup = manifestGroup.ignoreResiduals();
        }
        if (manifests.size() > 1 && this.shouldPlanWithExecutor()) {
            manifestGroup = manifestGroup.planWith(this.planExecutor());
        }
        return manifestGroup.planFiles();
    }

    private static List<Snapshot> appendsBetween(Table table, Long fromSnapshotIdExclusive, long toSnapshotIdInclusive) {
        ArrayList snapshots = Lists.newArrayList();
        for (Snapshot snapshot : SnapshotUtil.ancestorsBetween(toSnapshotIdInclusive, fromSnapshotIdExclusive, arg_0 -> ((Table)table).snapshot(arg_0))) {
            if (!snapshot.operation().equals("append")) continue;
            snapshots.add(snapshot);
        }
        return snapshots;
    }
}

