/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger2.mappers;

import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;
import springfox.documentation.builders.BuilderDefaults;
import springfox.documentation.schema.QualifiedModelName;
import springfox.documentation.schema.ReferenceModelSpecification;
import springfox.documentation.service.ModelNamesRegistry;

public class ReferenceModelSpecificationToPropertyConverter
implements Converter<ReferenceModelSpecification, Property> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReferenceModelSpecificationToPropertyConverter.class);
    private final ModelNamesRegistry modelNamesRegistry;

    public ReferenceModelSpecificationToPropertyConverter(ModelNamesRegistry modelNamesRegistry) {
        this.modelNamesRegistry = modelNamesRegistry;
    }

    public Property convert(ReferenceModelSpecification source) {
        ObjectProperty objectProperty = new ObjectProperty();
        QualifiedModelName qualifiedModelName = source.getKey().getQualifiedModelName();
        if ("java.lang".equals(qualifiedModelName.getNamespace()) && "object".equals(qualifiedModelName.getName())) {
            return objectProperty;
        }
        if (BuilderDefaults.emptyToNull((String)source.getKey().getQualifiedModelName().getName()) != null) {
            Optional name = this.modelNamesRegistry.nameByKey(source.getKey());
            if (!name.isPresent()) {
                LOGGER.error("Unable to find a model that matches key {}", (Object)source.getKey());
            }
            return new RefProperty(name.orElse("Error-" + source.getKey().getQualifiedModelName()));
        }
        return null;
    }
}

