/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;
import oracle.ons.CallBack;
import oracle.ons.CallBackMode;
import oracle.ons.Node;
import oracle.ons.Notification;
import oracle.ons.NotificationNetwork;
import oracle.ons.ONS;
import oracle.ons.Publisher;
import oracle.ons.Subscriber;
import oracle.ons.rpc.RpcServerException;

public class CallBackSubscriber
extends Subscriber
implements CallBack {
    private String logicalAddress = "";
    private final Object registrationLock = new Object();
    private boolean registrationComplete = false;
    private String registrationError = null;
    private String rpcServerName;
    private volatile CallBack rpcCallBack = null;
    private Map<String, String> addrProperties;
    private Publisher publisher;
    private Node serverNode = null;
    private String serverSubscriberId = null;
    private NotificationNetwork network;
    private Logger logger;

    public CallBackSubscriber(String rpcServerName, String subscription, String component, CallBack callback, CallBackMode callBackMode, Map<String, String> addrProperties) {
        this(rpcServerName, ONS.getONS(), subscription, component, callback, callBackMode, addrProperties);
    }

    public CallBackSubscriber(String rpcServerName, ONS myONS, String subscription, String component, CallBack callback, CallBackMode callBackMode, Map<String, String> addrProperties) {
        super(myONS.getNetwork().config, subscription, component, null);
        if (callback == null) {
            throw new IllegalStateException("oracle.ons.Callback parameter must not be null");
        }
        this.logger = myONS.getLogger();
        this.network = myONS.getNetwork();
        this.rpcServerName = rpcServerName;
        this.rpcCallBack = callback;
        this.addrProperties = addrProperties;
        this.publisher = new Publisher(this.network, rpcServerName);
        this.register_callback(this, 1);
        this.logger.info("created subscriber: rpcName=" + rpcServerName);
        this.register();
    }

    public String getLogicalAddress() {
        return this.logicalAddress;
    }

    public void start() {
    }

    @Override
    protected void setServerSubscriberInfo(Node node, String sid) {
        this.serverNode = node;
        this.serverSubscriberId = sid;
    }

    @Override
    protected boolean handleInternalNotification(Notification n) {
        boolean status = super.handleInternalNotification(n);
        if (status && this.serverSubscriberId != null && n.verb.equals("status") && this.isOpen()) {
            this.network.master.getWorkloadManager().schedule(new CallBackRegister(this));
        }
        return status;
    }

    protected void sendRegister() {
        Notification n = new Notification("ONSregister", "", "", null);
        n.setLocalOnly();
        n.put("ONSregisterID", "sONSrpc" + this.rpcServerName);
        n.putInternalProperty("SubscriberID", this.serverSubscriberId);
        n.put("ONSregisterGroup", "true");
        n.put("DirectRoute", "true");
        if (this.addrProperties != null) {
            for (Map.Entry<String, String> entry : this.addrProperties.entrySet()) {
                n.put(entry.getKey(), entry.getValue());
            }
        }
        this.sendNotification(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notification_callback(Notification n) {
        String eventType = n.getEventType();
        this.logger.info("notification type=" + eventType);
        if (eventType.equals("ONSstatus")) {
            String result = n.get("Result");
            String msg = n.get("Message");
            this.logger.info("status: result=" + result);
            if (result.equalsIgnoreCase("success")) {
                this.logicalAddress = msg;
                Object object = this.registrationLock;
                synchronized (object) {
                    this.registrationLock.notify();
                    this.registrationComplete = true;
                }
            } else {
                Object object = this.registrationLock;
                synchronized (object) {
                    this.registrationError = msg;
                    this.registrationLock.notify();
                    this.registrationComplete = true;
                }
            }
        } else if (this.registrationComplete && this.registrationError == null) {
            String directSource = n.get("DirectSource");
            String broadcastId = n.get("ONSbroadcastID");
            String traceRoute = n.get("TraceRoute");
            if (eventType.equals("ONS_RPC_PING")) {
                Notification pingReply = new Notification("ONS_RPC_PINGREPLY", "", "", null);
                pingReply.put("DirectRoute", directSource);
                pingReply.put("ONSbroadcastID", broadcastId);
                pingReply.put("BackRoute", traceRoute);
                pingReply.put("Result", "success");
                pingReply.put("DirectSource", this.logicalAddress);
                if (this.addrProperties != null) {
                    for (Map.Entry<String, String> entry : this.addrProperties.entrySet()) {
                        pingReply.put("|" + entry.getKey(), entry.getValue());
                    }
                }
                this.sendNotification(pingReply);
            } else if (eventType.equals("ONS_RPC_REQUEST")) {
                this.rpcCallBack.notification_callback(n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForRpcServerRegistrationReply() throws RpcServerException {
        Object object = this.registrationLock;
        synchronized (object) {
            if (!this.registrationComplete) {
                try {
                    this.registrationLock.wait(120000L);
                }
                catch (InterruptedException e) {
                    this.registrationError = "timed out";
                }
            }
        }
        if (this.registrationError != null) {
            throw new RpcServerException("Rpc Server registration failed: " + this.registrationError);
        }
    }

    private void sendNotification(Notification notification) {
        try {
            if (this.serverNode.getProtocolVersion() >= 5) {
                this.serverNode.publish(notification.toMessage(this.publisher));
            } else {
                this.serverNode.publish(notification.toMessageVersion4(this.publisher));
            }
        }
        catch (IOException e) {
            this.logger.severe("send: " + e + "\n" + e.getMessage());
        }
    }

    private static class CallBackRegister
    implements Runnable {
        CallBackSubscriber callbackSubscriber;

        private CallBackRegister(CallBackSubscriber cbSub) {
            this.callbackSubscriber = cbSub;
        }

        @Override
        public void run() {
            this.callbackSubscriber.sendRegister();
        }
    }
}

