/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.sinks.dataproxy;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.inlong.agent.common.AbstractDaemon;
import org.apache.inlong.agent.conf.InstanceProfile;
import org.apache.inlong.agent.core.task.OffsetManager;
import org.apache.inlong.agent.core.task.TaskManager;
import org.apache.inlong.agent.plugin.sinks.dataproxy.Sender;
import org.apache.inlong.agent.utils.AgentUtils;
import org.apache.inlong.agent.utils.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SenderManager
extends AbstractDaemon {
    private static final Logger LOGGER = LoggerFactory.getLogger(SenderManager.class);
    public static final int CORE_THREAD_SLEEP_TIME_MS = 60000;
    private static volatile SenderManager SenderManager = null;
    private final ConcurrentHashMap<String, Sender> senderMap = new ConcurrentHashMap();

    private SenderManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SenderManager getInstance() {
        if (SenderManager != null) return SenderManager;
        Class<OffsetManager> clazz = OffsetManager.class;
        synchronized (OffsetManager.class) {
            if (SenderManager != null) return SenderManager;
            SenderManager = new SenderManager();
            try {
                SenderManager.start();
            }
            catch (Exception e) {
                LOGGER.error("start sender manager failed:", (Throwable)e);
            }
            return SenderManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sender getSender(String taskId, InstanceProfile profile) {
        Sender sender = this.senderMap.get(taskId);
        if (sender == null) {
            Class<OffsetManager> clazz = OffsetManager.class;
            synchronized (OffsetManager.class) {
                if (sender == null) {
                    this.createSender(taskId, profile);
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return this.senderMap.get(taskId);
            }
        }
        return sender;
    }

    private void createSender(String taskId, InstanceProfile profile) {
        Sender sender = new Sender(profile, profile.getInlongGroupId(), profile.getInstanceId());
        try {
            sender.Start();
        }
        catch (Throwable ex) {
            LOGGER.error("error while init sender for group id {}", (Object)profile.getInstanceId());
            ThreadUtils.threadThrowableHandler((Thread)Thread.currentThread(), (Throwable)ex);
            throw new IllegalStateException(ex);
        }
        this.senderMap.put(taskId, sender);
    }

    private Runnable coreThread() {
        return () -> {
            Thread.currentThread().setName("sender-manager-core-thread");
            while (this.isRunnable()) {
                try {
                    AgentUtils.silenceSleepInMs((long)60000L);
                    this.senderMap.entrySet().forEach(entry -> {
                        if (TaskManager.getTaskStore().getTask((String)entry.getKey()) == null) {
                            Sender sender = this.senderMap.remove(entry.getKey());
                            sender.Stop();
                            LOGGER.info("task {} not exist, remove the related sender", entry.getKey());
                        }
                    });
                }
                catch (Throwable ex) {
                    LOGGER.error("sender-manager-core-thread: ", ex);
                    ThreadUtils.threadThrowableHandler((Thread)Thread.currentThread(), (Throwable)ex);
                }
            }
        };
    }

    public void start() throws Exception {
        this.submitWorker(this.coreThread());
    }

    public void stop() throws Exception {
    }
}

