/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.fetcher;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagerResultFormatter {
    public static final String SUCCESS_CODE = "true";
    private static final Logger LOGGER = LoggerFactory.getLogger(ManagerResultFormatter.class);
    private static final String RESULT_CODE = "success";
    private static final String RESULT_DATA = "data";
    private static final Gson GSON = new Gson();

    public static JsonObject getResultData(String jsonStr) {
        JsonObject object = (JsonObject)GSON.fromJson(jsonStr, JsonObject.class);
        if (!(object != null && object.has(RESULT_CODE) && object.has(RESULT_DATA) && SUCCESS_CODE.equals(object.get(RESULT_CODE).getAsString()))) {
            throw new IllegalArgumentException("cannot get result data, please check manager status, return str is " + jsonStr);
        }
        return object;
    }

    public static <T> List<T> getRandomList(List<T> baseList, int num) {
        if (baseList == null) {
            return new ArrayList();
        }
        ArrayList<T> newHostList = new ArrayList<T>(baseList);
        Collections.shuffle(newHostList);
        num = Math.min(num, baseList.size());
        return newHostList.subList(0, num);
    }
}

