/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.io;

import com.moilioncircle.redis.replicator.io.ByteArrayInputStream;
import com.moilioncircle.redis.replicator.io.RawByteListener;
import com.moilioncircle.redis.replicator.util.ByteArray;
import com.moilioncircle.redis.replicator.util.Strings;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;

public class RedisInputStream
extends InputStream {
    protected int head = 0;
    protected int tail = 0;
    protected long total = 0L;
    protected long markLen = 0L;
    protected final byte[] buf;
    protected boolean mark = false;
    protected final InputStream in;
    protected List<RawByteListener> rawByteListeners;

    public RedisInputStream(ByteArray array) {
        this(new ByteArrayInputStream(array));
    }

    public RedisInputStream(InputStream in) {
        this(in, 8192);
    }

    public RedisInputStream(InputStream in, int len) {
        this.in = in;
        this.buf = new byte[len];
    }

    public synchronized void setRawByteListeners(List<RawByteListener> rawByteListeners) {
        this.rawByteListeners = rawByteListeners;
    }

    protected void notify(byte ... bytes) {
        if (this.rawByteListeners == null || this.rawByteListeners.isEmpty()) {
            return;
        }
        for (RawByteListener listener : this.rawByteListeners) {
            listener.handle(bytes);
        }
    }

    public int head() {
        return this.head;
    }

    public int tail() {
        return this.tail;
    }

    public int bufSize() {
        return this.buf.length;
    }

    public boolean isMarked() {
        return this.mark;
    }

    public void mark(long len) {
        this.mark();
        this.markLen = len;
    }

    public void mark() {
        if (!this.mark) {
            this.mark = true;
            return;
        }
        throw new AssertionError((Object)"already marked");
    }

    public long unmark() {
        if (this.mark) {
            long rs = this.markLen;
            this.markLen = 0L;
            this.mark = false;
            return rs;
        }
        throw new AssertionError((Object)"must mark first");
    }

    public long total() {
        return this.total;
    }

    public ByteArray readBytes(long len) throws IOException {
        ByteArray bytes = new ByteArray(len);
        this.read(bytes, 0L, len);
        if (this.mark) {
            this.markLen += len;
        }
        return bytes;
    }

    public int readInt(int len) throws IOException {
        return this.readInt(len, true);
    }

    public long readLong(int len) throws IOException {
        return this.readLong(len, true);
    }

    public int readInt(int length, boolean littleEndian) throws IOException {
        int r = 0;
        for (int i = 0; i < length; ++i) {
            int v = this.read();
            if (littleEndian) {
                r |= v << (i << 3);
                continue;
            }
            r = r << 8 | v;
        }
        int c = 4 - length << 3;
        return r << c >> c;
    }

    public long readUInt(int length) throws IOException {
        return this.readUInt(length, true);
    }

    public long readUInt(int length, boolean littleEndian) throws IOException {
        return (long)this.readInt(length, littleEndian) & 0xFFFFFFFFL;
    }

    public int readInt(byte[] bytes) {
        return this.readInt(bytes, true);
    }

    public int readInt(byte[] bytes, boolean littleEndian) {
        int r = 0;
        int length = bytes.length;
        for (int i = 0; i < length; ++i) {
            int v = bytes[i] & 0xFF;
            if (littleEndian) {
                r |= v << (i << 3);
                continue;
            }
            r = r << 8 | v;
        }
        int c = 4 - length << 3;
        return r << c >> c;
    }

    public long readLong(int length, boolean littleEndian) throws IOException {
        long r = 0L;
        for (int i = 0; i < length; ++i) {
            long v = this.read();
            if (littleEndian) {
                r |= v << (i << 3);
                continue;
            }
            r = r << 8 | v;
        }
        return r;
    }

    public String readString(int len) throws IOException {
        return Strings.toString(this.readBytes(len).first());
    }

    public String readString(int len, Charset charset) throws IOException {
        return Strings.toString(this.readBytes(len).first(), charset);
    }

    @Override
    public int read() throws IOException {
        if (this.head >= this.tail) {
            this.fill();
        }
        if (this.mark) {
            ++this.markLen;
        }
        byte b = this.buf[this.head++];
        this.notify(b);
        return b & 0xFF;
    }

    public long read(ByteArray bytes, long offset, long len) throws IOException {
        int available;
        long index = offset;
        for (long total = len; total > 0L; total -= (long)available) {
            available = this.tail - this.head;
            if ((long)available >= total) {
                ByteArray.arraycopy(new ByteArray(this.buf), this.head, bytes, index, total);
                this.head = (int)((long)this.head + total);
                break;
            }
            ByteArray.arraycopy(new ByteArray(this.buf), this.head, bytes, index, available);
            index += (long)available;
            this.fill();
        }
        for (byte[] b : bytes) {
            this.notify(b);
        }
        return len;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return (int)this.read(new ByteArray(b), (long)off, (long)len);
    }

    @Override
    public int available() throws IOException {
        return this.tail - this.head + this.in.available();
    }

    public long skip(long len, boolean notify) throws IOException {
        int available;
        for (long total = len; total > 0L; total -= (long)available) {
            available = this.tail - this.head;
            if ((long)available >= total) {
                if (notify) {
                    this.notify(Arrays.copyOfRange(this.buf, this.head, this.head + (int)total));
                }
                this.head = (int)((long)this.head + total);
                break;
            }
            if (notify) {
                this.notify(Arrays.copyOfRange(this.buf, this.head, this.tail));
            }
            this.fill();
        }
        return len;
    }

    @Override
    public long skip(long len) throws IOException {
        return this.skip(len, true);
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    protected void fill() throws IOException {
        this.tail = this.in.read(this.buf, 0, this.buf.length);
        if (this.tail == -1) {
            throw new EOFException("end of file or end of stream.");
        }
        this.total += (long)this.tail;
        this.head = 0;
    }
}

