/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.dao.interceptor;

import java.lang.reflect.Field;
import java.sql.PreparedStatement;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.ognl.ASTConst;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.DefaultReflectorFactory;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.ReflectorFactory;
import org.apache.ibatis.reflection.factory.DefaultObjectFactory;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.reflection.wrapper.DefaultObjectWrapperFactory;
import org.apache.ibatis.reflection.wrapper.ObjectWrapperFactory;
import org.apache.ibatis.scripting.xmltags.OgnlCache;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.StringTypeHandler;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.dao.interceptor.MultiTenantQueryFilter;
import org.apache.inlong.manager.pojo.user.LoginUserUtils;
import org.apache.inlong.manager.pojo.user.UserInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=ParameterHandler.class, method="setParameters", args={PreparedStatement.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class MultiTenantInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(MultiTenantInterceptor.class);
    private static final String KEY_TENANT = "tenant";
    private static final String KEY_INLONG_SERVICE = "LoginUser.InlongService";
    private static final ObjectFactory DEFAULT_OBJECT_FACTORY = new DefaultObjectFactory();
    private static final ObjectWrapperFactory DEFAULT_OBJECT_WRAPPER_FACTORY = new DefaultObjectWrapperFactory();
    private static final ReflectorFactory REFLECTOR_FACTORY = new DefaultReflectorFactory();

    public Object intercept(Invocation invocation) throws Throwable {
        if (invocation.getTarget() instanceof ParameterHandler) {
            return this.doParameterHandler((ParameterHandler)invocation.getTarget(), invocation);
        }
        if (invocation.getTarget() instanceof Executor) {
            return this.doExecutor(invocation);
        }
        throw new Throwable("do not support type of target=" + invocation.getTarget());
    }

    private Object doExecutor(Invocation invocation) throws Throwable {
        MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
        String fullMethodName = mappedStatement.getId();
        if (!MultiTenantQueryFilter.isMultiTenantQuery(fullMethodName.split("_")[0])) {
            return invocation.proceed();
        }
        this.setExpressionCache();
        try {
            Object newParameter;
            Object[] args = invocation.getArgs();
            MappedStatement ms = (MappedStatement)args[0];
            Object parameter = args[1];
            BoundSql boundSql = args.length == 4 ? ms.getBoundSql(parameter) : (BoundSql)args[5];
            List parameterMappings = boundSql.getParameterMappings();
            this.setTenantMapping(parameterMappings);
            invocation.getArgs()[1] = newParameter = this.makeNewParameters(parameter, parameterMappings);
            return invocation.proceed();
        }
        catch (Exception e) {
            log.error("failed to do executor in MultiTenantInterceptor", (Throwable)e);
            throw e;
        }
    }

    private Object doParameterHandler(ParameterHandler parameterHandler, Invocation invocation) throws Throwable {
        MetaObject metaResultSetHandler = MetaObject.forObject((Object)parameterHandler, (ObjectFactory)DEFAULT_OBJECT_FACTORY, (ObjectWrapperFactory)DEFAULT_OBJECT_WRAPPER_FACTORY, (ReflectorFactory)REFLECTOR_FACTORY);
        MappedStatement mappedStatement = (MappedStatement)metaResultSetHandler.getValue("mappedStatement");
        String fullMethodName = mappedStatement.getId();
        if (!MultiTenantQueryFilter.isMultiTenantQuery(fullMethodName.split("_")[0])) {
            return invocation.proceed();
        }
        this.setExpressionCache();
        Object parameterObject = metaResultSetHandler.getValue("parameterObject");
        BoundSql boundSql = (BoundSql)metaResultSetHandler.getValue("boundSql");
        Object newParams = this.makeNewParameters(parameterObject, boundSql.getParameterMappings());
        this.setTenantMapping(boundSql.getParameterMappings());
        metaResultSetHandler.setValue("parameterObject", newParams);
        return invocation.proceed();
    }

    private Object makeNewParameters(Object parameterObject, List<ParameterMapping> parameters) {
        if (this.isPrimitiveOrWrapper(parameterObject) && parameters.size() == 2) {
            return this.makeNewParametersFromPrimitive(parameterObject, parameters);
        }
        if (parameterObject instanceof MapperMethod.ParamMap) {
            return this.makeNewParametersFromMap((MapperMethod.ParamMap<String>)((MapperMethod.ParamMap)parameterObject));
        }
        return this.makeNewParametersFromEntity(parameterObject);
    }

    private Object makeNewParametersFromMap(MapperMethod.ParamMap<String> parameterObject) {
        parameterObject.put((Object)KEY_TENANT, (Object)this.getTenant());
        return parameterObject;
    }

    private Object makeNewParametersFromPrimitive(Object parameterObject, List<ParameterMapping> parameters) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        int idx = 0;
        if (KEY_TENANT.equals(parameters.get(0).getProperty())) {
            idx = 1;
        }
        params.put(parameters.get(idx).getProperty(), parameterObject);
        params.put(KEY_TENANT, this.getTenant());
        return params;
    }

    private Object makeNewParametersFromEntity(Object parameterObject) {
        Field[] fields = parameterObject.getClass().getDeclaredFields();
        try {
            for (Field field : fields) {
                if (!field.getName().equals(KEY_TENANT)) continue;
                field.setAccessible(true);
                field.set(parameterObject, this.getTenant());
            }
        }
        catch (Exception e) {
            log.error("failed to set tenant into parameters=" + parameterObject, (Throwable)e);
        }
        return parameterObject;
    }

    private boolean isPrimitiveOrWrapper(Object obj) {
        try {
            Class<?> clazz = obj.getClass();
            return obj instanceof String || clazz.isPrimitive() || ((Class)clazz.getField("TYPE").get(null)).isPrimitive();
        }
        catch (Exception e) {
            return false;
        }
    }

    private String getTenant() {
        UserInfo userInfo = LoginUserUtils.getLoginUser();
        if (userInfo == null) {
            throw new BusinessException("Current user is null, please login first");
        }
        String tenant = userInfo.getTenant();
        if (StringUtils.isBlank((CharSequence)tenant)) {
            throw new BusinessException(String.format("User tenant is blank for user id=%s and username=%s", userInfo.getId(), userInfo.getName()));
        }
        return tenant;
    }

    private boolean isInlongService() {
        UserInfo userInfo = LoginUserUtils.getLoginUser();
        if (userInfo == null) {
            throw new BusinessException("Current user is null, please login first");
        }
        if (CollectionUtils.isEmpty((Collection)userInfo.getRoles())) {
            return false;
        }
        return userInfo.getRoles().contains("INLONG_SERVICE");
    }

    private void setExpressionCache() throws NoSuchFieldException, IllegalAccessException {
        Field cacheFiled = OgnlCache.class.getDeclaredField("expressionCache");
        cacheFiled.setAccessible(true);
        Map expressionCache = (Map)cacheFiled.get(null);
        ASTConst node = new ASTConst(31);
        node.setValue((Object)this.isInlongService());
        expressionCache.put(KEY_INLONG_SERVICE, node);
    }

    private void setTenantMapping(List<ParameterMapping> parameterMappings) throws NoSuchFieldException, IllegalAccessException {
        for (ParameterMapping mapping : parameterMappings) {
            if (!mapping.getProperty().equals(KEY_TENANT)) continue;
            Field javaType = mapping.getClass().getDeclaredField("javaType");
            javaType.setAccessible(true);
            javaType.set(mapping, String.class);
            Field typeHandler = mapping.getClass().getDeclaredField("typeHandler");
            typeHandler.setAccessible(true);
            typeHandler.set(mapping, new StringTypeHandler());
        }
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }
}

