/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.parquet.bytes.ByteBufferAllocator;
import org.apache.parquet.bytes.HeapByteBufferAllocator;
import org.apache.parquet.compression.CompressionCodecFactory;
import org.apache.parquet.crypto.FileDecryptionProperties;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.util.HadoopCodecs;

public class ParquetReadOptions {
    private static final boolean RECORD_FILTERING_ENABLED_DEFAULT = true;
    private static final boolean STATS_FILTERING_ENABLED_DEFAULT = true;
    private static final boolean DICTIONARY_FILTERING_ENABLED_DEFAULT = true;
    private static final boolean COLUMN_INDEX_FILTERING_ENABLED_DEFAULT = true;
    private static final int ALLOCATION_SIZE_DEFAULT = 0x800000;
    private static final boolean PAGE_VERIFY_CHECKSUM_ENABLED_DEFAULT = false;
    private static final boolean BLOOM_FILTER_ENABLED_DEFAULT = true;
    private final boolean useSignedStringMinMax;
    private final boolean useStatsFilter;
    private final boolean useDictionaryFilter;
    private final boolean useRecordFilter;
    private final boolean useColumnIndexFilter;
    private final boolean usePageChecksumVerification;
    private final boolean useBloomFilter;
    private final FilterCompat.Filter recordFilter;
    private final ParquetMetadataConverter.MetadataFilter metadataFilter;
    private final CompressionCodecFactory codecFactory;
    private final ByteBufferAllocator allocator;
    private final int maxAllocationSize;
    private final Map<String, String> properties;
    private final FileDecryptionProperties fileDecryptionProperties;

    ParquetReadOptions(boolean useSignedStringMinMax, boolean useStatsFilter, boolean useDictionaryFilter, boolean useRecordFilter, boolean useColumnIndexFilter, boolean usePageChecksumVerification, boolean useBloomFilter, FilterCompat.Filter recordFilter, ParquetMetadataConverter.MetadataFilter metadataFilter, CompressionCodecFactory codecFactory, ByteBufferAllocator allocator, int maxAllocationSize, Map<String, String> properties, FileDecryptionProperties fileDecryptionProperties) {
        this.useSignedStringMinMax = useSignedStringMinMax;
        this.useStatsFilter = useStatsFilter;
        this.useDictionaryFilter = useDictionaryFilter;
        this.useRecordFilter = useRecordFilter;
        this.useColumnIndexFilter = useColumnIndexFilter;
        this.usePageChecksumVerification = usePageChecksumVerification;
        this.useBloomFilter = useBloomFilter;
        this.recordFilter = recordFilter;
        this.metadataFilter = metadataFilter;
        this.codecFactory = codecFactory;
        this.allocator = allocator;
        this.maxAllocationSize = maxAllocationSize;
        this.properties = Collections.unmodifiableMap(properties);
        this.fileDecryptionProperties = fileDecryptionProperties;
    }

    public boolean useSignedStringMinMax() {
        return this.useSignedStringMinMax;
    }

    public boolean useStatsFilter() {
        return this.useStatsFilter;
    }

    public boolean useDictionaryFilter() {
        return this.useDictionaryFilter;
    }

    public boolean useRecordFilter() {
        return this.useRecordFilter;
    }

    public boolean useColumnIndexFilter() {
        return this.useColumnIndexFilter;
    }

    public boolean useBloomFilter() {
        return this.useBloomFilter;
    }

    public boolean usePageChecksumVerification() {
        return this.usePageChecksumVerification;
    }

    public FilterCompat.Filter getRecordFilter() {
        return this.recordFilter;
    }

    public ParquetMetadataConverter.MetadataFilter getMetadataFilter() {
        return this.metadataFilter;
    }

    public CompressionCodecFactory getCodecFactory() {
        return this.codecFactory;
    }

    public ByteBufferAllocator getAllocator() {
        return this.allocator;
    }

    public int getMaxAllocationSize() {
        return this.maxAllocationSize;
    }

    public Set<String> getPropertyNames() {
        return this.properties.keySet();
    }

    public String getProperty(String property) {
        return this.properties.get(property);
    }

    public FileDecryptionProperties getDecryptionProperties() {
        return this.fileDecryptionProperties;
    }

    public boolean isEnabled(String property, boolean defaultValue) {
        Optional<String> propValue = Optional.ofNullable(this.properties.get(property));
        return propValue.isPresent() ? Boolean.valueOf(propValue.get()) : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        protected boolean useSignedStringMinMax = false;
        protected boolean useStatsFilter = true;
        protected boolean useDictionaryFilter = true;
        protected boolean useRecordFilter = true;
        protected boolean useColumnIndexFilter = true;
        protected boolean usePageChecksumVerification = false;
        protected boolean useBloomFilter = true;
        protected FilterCompat.Filter recordFilter = null;
        protected ParquetMetadataConverter.MetadataFilter metadataFilter = ParquetMetadataConverter.NO_FILTER;
        protected CompressionCodecFactory codecFactory = HadoopCodecs.newFactory(0);
        protected ByteBufferAllocator allocator = new HeapByteBufferAllocator();
        protected int maxAllocationSize = 0x800000;
        protected Map<String, String> properties = new HashMap<String, String>();
        protected FileDecryptionProperties fileDecryptionProperties = null;

        public Builder useSignedStringMinMax(boolean useSignedStringMinMax) {
            this.useSignedStringMinMax = useSignedStringMinMax;
            return this;
        }

        public Builder useSignedStringMinMax() {
            this.useSignedStringMinMax = true;
            return this;
        }

        public Builder useStatsFilter(boolean useStatsFilter) {
            this.useStatsFilter = useStatsFilter;
            return this;
        }

        public Builder useStatsFilter() {
            this.useStatsFilter = true;
            return this;
        }

        public Builder useDictionaryFilter(boolean useDictionaryFilter) {
            this.useDictionaryFilter = useDictionaryFilter;
            return this;
        }

        public Builder useDictionaryFilter() {
            this.useDictionaryFilter = true;
            return this;
        }

        public Builder useRecordFilter(boolean useRecordFilter) {
            this.useRecordFilter = useRecordFilter;
            return this;
        }

        public Builder useRecordFilter() {
            this.useRecordFilter = true;
            return this;
        }

        public Builder useColumnIndexFilter(boolean useColumnIndexFilter) {
            this.useColumnIndexFilter = useColumnIndexFilter;
            return this;
        }

        public Builder useColumnIndexFilter() {
            return this.useColumnIndexFilter(true);
        }

        public Builder usePageChecksumVerification(boolean usePageChecksumVerification) {
            this.usePageChecksumVerification = usePageChecksumVerification;
            return this;
        }

        public Builder usePageChecksumVerification() {
            return this.usePageChecksumVerification(true);
        }

        public Builder useBloomFilter() {
            this.useBloomFilter = true;
            return this;
        }

        public Builder useBloomFilter(boolean useBloomFilter) {
            this.useBloomFilter = useBloomFilter;
            return this;
        }

        public Builder withRecordFilter(FilterCompat.Filter rowGroupFilter) {
            this.recordFilter = rowGroupFilter;
            return this;
        }

        public Builder withRange(long start, long end) {
            this.metadataFilter = ParquetMetadataConverter.range(start, end);
            return this;
        }

        public Builder withOffsets(long ... rowGroupOffsets) {
            this.metadataFilter = ParquetMetadataConverter.offsets(rowGroupOffsets);
            return this;
        }

        public Builder withMetadataFilter(ParquetMetadataConverter.MetadataFilter metadataFilter) {
            this.metadataFilter = metadataFilter;
            return this;
        }

        public Builder withCodecFactory(CompressionCodecFactory codecFactory) {
            this.codecFactory = codecFactory;
            return this;
        }

        public Builder withAllocator(ByteBufferAllocator allocator) {
            this.allocator = allocator;
            return this;
        }

        public Builder withMaxAllocationInBytes(int allocationSizeInBytes) {
            this.maxAllocationSize = allocationSizeInBytes;
            return this;
        }

        public Builder withPageChecksumVerification(boolean val2) {
            this.usePageChecksumVerification = val2;
            return this;
        }

        public Builder withDecryption(FileDecryptionProperties fileDecryptionProperties) {
            this.fileDecryptionProperties = fileDecryptionProperties;
            return this;
        }

        public Builder set(String key, String value) {
            this.properties.put(key, value);
            return this;
        }

        public Builder copy(ParquetReadOptions options) {
            this.useSignedStringMinMax(options.useSignedStringMinMax);
            this.useStatsFilter(options.useStatsFilter);
            this.useDictionaryFilter(options.useDictionaryFilter);
            this.useRecordFilter(options.useRecordFilter);
            this.withRecordFilter(options.recordFilter);
            this.withMetadataFilter(options.metadataFilter);
            this.withCodecFactory(options.codecFactory);
            this.withAllocator(options.allocator);
            this.withPageChecksumVerification(options.usePageChecksumVerification);
            this.withDecryption(options.fileDecryptionProperties);
            for (Map.Entry keyValue : options.properties.entrySet()) {
                this.set((String)keyValue.getKey(), (String)keyValue.getValue());
            }
            return this;
        }

        public ParquetReadOptions build() {
            return new ParquetReadOptions(this.useSignedStringMinMax, this.useStatsFilter, this.useDictionaryFilter, this.useRecordFilter, this.useColumnIndexFilter, this.usePageChecksumVerification, this.useBloomFilter, this.recordFilter, this.metadataFilter, this.codecFactory, this.allocator, this.maxAllocationSize, this.properties, this.fileDecryptionProperties);
        }
    }
}

