/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.protocol.node.transform;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.enums.FilterStrategy;
import org.apache.inlong.sort.protocol.node.transform.TransformNode;
import org.apache.inlong.sort.protocol.transformation.FieldRelation;
import org.apache.inlong.sort.protocol.transformation.FilterFunction;
import org.apache.inlong.sort.protocol.transformation.OrderDirection;

@JsonTypeName(value="distinct")
public class DistinctNode
extends TransformNode {
    private static final long serialVersionUID = 5007120031895569715L;
    @JsonProperty(value="distinctFields")
    private List<FieldInfo> distinctFields;
    @JsonProperty(value="orderField")
    private FieldInfo orderField;
    @JsonProperty(value="orderDirection")
    private OrderDirection orderDirection = OrderDirection.ASC;

    @JsonCreator
    public DistinctNode(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="fields") List<FieldInfo> fields, @JsonProperty(value="fieldRelations") List<FieldRelation> fieldRelations, @JsonProperty(value="filters") List<FilterFunction> filters, @JsonProperty(value="filterStrategy") FilterStrategy filterStrategy, @JsonProperty(value="distinctFields") List<FieldInfo> distinctFields, @JsonProperty(value="orderField") FieldInfo orderField, @JsonProperty(value="orderDirection") OrderDirection orderDirection) {
        super(id, name, fields, fieldRelations, filters, filterStrategy);
        this.distinctFields = Preconditions.checkNotNull(distinctFields, "distinctFields is null");
        Preconditions.checkState(!distinctFields.isEmpty(), "distinct fields is empty");
        this.orderField = Preconditions.checkNotNull(orderField, "orderField is null");
        this.orderDirection = orderDirection != null ? orderDirection : OrderDirection.ASC;
    }

    @Override
    public String genTableName() {
        return "distinct_" + super.getId();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DistinctNode)) {
            return false;
        }
        DistinctNode other = (DistinctNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<FieldInfo> this$distinctFields = this.getDistinctFields();
        List<FieldInfo> other$distinctFields = other.getDistinctFields();
        if (this$distinctFields == null ? other$distinctFields != null : !((Object)this$distinctFields).equals(other$distinctFields)) {
            return false;
        }
        FieldInfo this$orderField = this.getOrderField();
        FieldInfo other$orderField = other.getOrderField();
        if (this$orderField == null ? other$orderField != null : !((Object)this$orderField).equals(other$orderField)) {
            return false;
        }
        OrderDirection this$orderDirection = this.getOrderDirection();
        OrderDirection other$orderDirection = other.getOrderDirection();
        return !(this$orderDirection == null ? other$orderDirection != null : !((Object)((Object)this$orderDirection)).equals((Object)other$orderDirection));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DistinctNode;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<FieldInfo> $distinctFields = this.getDistinctFields();
        result = result * 59 + ($distinctFields == null ? 43 : ((Object)$distinctFields).hashCode());
        FieldInfo $orderField = this.getOrderField();
        result = result * 59 + ($orderField == null ? 43 : ((Object)$orderField).hashCode());
        OrderDirection $orderDirection = this.getOrderDirection();
        result = result * 59 + ($orderDirection == null ? 43 : ((Object)((Object)$orderDirection)).hashCode());
        return result;
    }

    public DistinctNode() {
    }

    public List<FieldInfo> getDistinctFields() {
        return this.distinctFields;
    }

    public FieldInfo getOrderField() {
        return this.orderField;
    }

    public OrderDirection getOrderDirection() {
        return this.orderDirection;
    }

    public void setDistinctFields(List<FieldInfo> distinctFields) {
        this.distinctFields = distinctFields;
    }

    public void setOrderField(FieldInfo orderField) {
        this.orderField = orderField;
    }

    public void setOrderDirection(OrderDirection orderDirection) {
        this.orderDirection = orderDirection;
    }

    @Override
    public String toString() {
        return "DistinctNode(distinctFields=" + this.getDistinctFields() + ", orderField=" + this.getOrderField() + ", orderDirection=" + (Object)((Object)this.getOrderDirection()) + ")";
    }
}

