/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.protocol.node.format;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.inlong.sort.protocol.node.format.Format;

@JsonTypeName(value="kvFormat")
public class KvFormat
implements Format {
    private static final String IDENTIFIER = "inlong-kv";
    @JsonProperty(value="entryDelimiter", defaultValue="&")
    private final String entryDelimiter;
    @JsonProperty(value="kvDelimiter", defaultValue="=")
    private final String kvDelimiter;
    @JsonProperty(value="ignoreParseErrors", defaultValue="false")
    @Nullable
    private final Boolean ignoreParseErrors;
    @JsonProperty(value="escapeChar")
    @Nullable
    private final String escapeChar;
    @JsonProperty(value="charset")
    @Nullable
    private final String charset;
    @JsonProperty(value="nullLiteral")
    @Nullable
    private final String nullLiteral;
    @JsonProperty(value="quoteCharacter")
    @Nullable
    private final String quoteCharacter;

    @JsonCreator
    public KvFormat(@JsonProperty(value="entryDelimiter") String entryDelimiter, @JsonProperty(value="kvDelimiter") String kvDelimiter, @Nullable @JsonProperty(value="escapeChar") String escapeChar, @Nullable @JsonProperty(value="ignoreParseErrors", defaultValue="false") Boolean ignoreParseErrors, @Nullable @JsonProperty(value="charset") String charset, @Nullable @JsonProperty(value="nullLiteral") String nullLiteral, @Nullable @JsonProperty(value="quoteCharacter") String quoteCharacter) {
        this.entryDelimiter = entryDelimiter;
        this.kvDelimiter = kvDelimiter;
        this.escapeChar = escapeChar;
        this.ignoreParseErrors = ignoreParseErrors;
        this.charset = charset;
        this.nullLiteral = nullLiteral;
        this.quoteCharacter = quoteCharacter;
    }

    public KvFormat() {
        this("&", "=", null, false, null, null, null);
    }

    @Override
    @JsonIgnore
    public String getFormat() {
        return IDENTIFIER;
    }

    @Override
    public String identifier() {
        return IDENTIFIER;
    }

    @Override
    public Map<String, String> generateOptions() {
        HashMap<String, String> options = new HashMap<String, String>(16);
        options.put("format", this.getFormat());
        options.put("format.kv-delimiter", this.kvDelimiter);
        options.put("format.entry-delimiter", this.entryDelimiter);
        if (StringUtils.isNotBlank(this.charset)) {
            options.put("format.charset", this.charset);
        }
        if (StringUtils.isNotBlank(this.nullLiteral)) {
            options.put("format.null-literal", this.nullLiteral);
        }
        if (StringUtils.isNotBlank(this.quoteCharacter)) {
            options.put("format.quote-character", this.quoteCharacter);
        }
        if (StringUtils.isNotBlank(this.escapeChar)) {
            options.put("format.escape-character", this.escapeChar);
        }
        if (this.ignoreParseErrors != null) {
            options.put("format.ignore-errors", String.valueOf(this.ignoreParseErrors));
        }
        return options;
    }

    public String getEntryDelimiter() {
        return this.entryDelimiter;
    }

    public String getKvDelimiter() {
        return this.kvDelimiter;
    }

    @Nullable
    public Boolean getIgnoreParseErrors() {
        return this.ignoreParseErrors;
    }

    @Nullable
    public String getEscapeChar() {
        return this.escapeChar;
    }

    @Nullable
    public String getCharset() {
        return this.charset;
    }

    @Nullable
    public String getNullLiteral() {
        return this.nullLiteral;
    }

    @Nullable
    public String getQuoteCharacter() {
        return this.quoteCharacter;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KvFormat)) {
            return false;
        }
        KvFormat other = (KvFormat)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$ignoreParseErrors = this.getIgnoreParseErrors();
        Boolean other$ignoreParseErrors = other.getIgnoreParseErrors();
        if (this$ignoreParseErrors == null ? other$ignoreParseErrors != null : !((Object)this$ignoreParseErrors).equals(other$ignoreParseErrors)) {
            return false;
        }
        String this$entryDelimiter = this.getEntryDelimiter();
        String other$entryDelimiter = other.getEntryDelimiter();
        if (this$entryDelimiter == null ? other$entryDelimiter != null : !this$entryDelimiter.equals(other$entryDelimiter)) {
            return false;
        }
        String this$kvDelimiter = this.getKvDelimiter();
        String other$kvDelimiter = other.getKvDelimiter();
        if (this$kvDelimiter == null ? other$kvDelimiter != null : !this$kvDelimiter.equals(other$kvDelimiter)) {
            return false;
        }
        String this$escapeChar = this.getEscapeChar();
        String other$escapeChar = other.getEscapeChar();
        if (this$escapeChar == null ? other$escapeChar != null : !this$escapeChar.equals(other$escapeChar)) {
            return false;
        }
        String this$charset = this.getCharset();
        String other$charset = other.getCharset();
        if (this$charset == null ? other$charset != null : !this$charset.equals(other$charset)) {
            return false;
        }
        String this$nullLiteral = this.getNullLiteral();
        String other$nullLiteral = other.getNullLiteral();
        if (this$nullLiteral == null ? other$nullLiteral != null : !this$nullLiteral.equals(other$nullLiteral)) {
            return false;
        }
        String this$quoteCharacter = this.getQuoteCharacter();
        String other$quoteCharacter = other.getQuoteCharacter();
        return !(this$quoteCharacter == null ? other$quoteCharacter != null : !this$quoteCharacter.equals(other$quoteCharacter));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KvFormat;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $ignoreParseErrors = this.getIgnoreParseErrors();
        result = result * 59 + ($ignoreParseErrors == null ? 43 : ((Object)$ignoreParseErrors).hashCode());
        String $entryDelimiter = this.getEntryDelimiter();
        result = result * 59 + ($entryDelimiter == null ? 43 : $entryDelimiter.hashCode());
        String $kvDelimiter = this.getKvDelimiter();
        result = result * 59 + ($kvDelimiter == null ? 43 : $kvDelimiter.hashCode());
        String $escapeChar = this.getEscapeChar();
        result = result * 59 + ($escapeChar == null ? 43 : $escapeChar.hashCode());
        String $charset = this.getCharset();
        result = result * 59 + ($charset == null ? 43 : $charset.hashCode());
        String $nullLiteral = this.getNullLiteral();
        result = result * 59 + ($nullLiteral == null ? 43 : $nullLiteral.hashCode());
        String $quoteCharacter = this.getQuoteCharacter();
        result = result * 59 + ($quoteCharacter == null ? 43 : $quoteCharacter.hashCode());
        return result;
    }

    public String toString() {
        return "KvFormat(entryDelimiter=" + this.getEntryDelimiter() + ", kvDelimiter=" + this.getKvDelimiter() + ", ignoreParseErrors=" + this.getIgnoreParseErrors() + ", escapeChar=" + this.getEscapeChar() + ", charset=" + this.getCharset() + ", nullLiteral=" + this.getNullLiteral() + ", quoteCharacter=" + this.getQuoteCharacter() + ")";
    }
}

