/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.protocol.enums;

public enum SchemaChangeType {
    CREATE_TABLE(1),
    DROP_TABLE(2),
    RENAME_TABLE(3),
    TRUNCATE_TABLE(4),
    ADD_COLUMN(5),
    DROP_COLUMN(6),
    RENAME_COLUMN(7),
    CHANGE_COLUMN_TYPE(8),
    ALTER(-1);

    private final int code;

    private SchemaChangeType(int code) {
        this.code = code;
    }

    public static SchemaChangeType getInstance(int code) {
        for (SchemaChangeType type : SchemaChangeType.values()) {
            if (type.code != code) continue;
            return type;
        }
        throw new IllegalArgumentException(String.format("Unsupported type of schema-change: %s for InLong", code));
    }

    public int getCode() {
        return this.code;
    }

    public String toString() {
        return String.format("%s(%s)", this.name(), this.getCode());
    }
}

