/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.function;

import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.flink.table.functions.ScalarFunction;

public class EncryptFunction
extends ScalarFunction {
    private static final long serialVersionUID = -7185622027483662395L;
    private static final String ENCODING = "UTF-8";
    private static final String KEY_ALGORITHM_AES = "AES";
    private static final String KEY_ALGORITHM_3DES = "DESede";
    private static final String CIPHER_ALGORITHM_3DES = "DESede/ECB/PKCS5Padding";
    private static final String SIGN_ALGORITHMS = "SHA1PRNG";
    private static final Base64 base64 = new Base64();

    public String eval(String field, String key, String encrypt) {
        if (field != null) {
            String newValue = "";
            EncryptionType encryptionType = EncryptionType.getInstance(encrypt);
            switch (encryptionType) {
                case AES: {
                    newValue = EncryptFunction.encryptAES(field, key);
                    break;
                }
                case DESEDE: {
                    newValue = EncryptFunction.encrypt3DES(field, key);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(String.format("Unsupported %s encryption type", encrypt));
                }
            }
            return newValue;
        }
        return null;
    }

    public static String encrypt(String data, String key, String method) {
        if (KEY_ALGORITHM_3DES.equals(method)) {
            return EncryptFunction.encrypt3DES(data, key);
        }
        if (KEY_ALGORITHM_AES.equals(method)) {
            return EncryptFunction.encryptAES(data, key);
        }
        return null;
    }

    public static String encrypt3DES(String data, String key) {
        try {
            SecretKeySpec desKey = new SecretKeySpec(EncryptFunction.build3DesKey(key), KEY_ALGORITHM_3DES);
            Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM_3DES);
            cipher.init(1, desKey);
            return EncryptFunction.encryptBASE64(cipher.doFinal(data.getBytes(ENCODING)));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static byte[] build3DesKey(String keyStr) {
        try {
            byte[] key = "000000000000000000000000".getBytes(ENCODING);
            byte[] temp = keyStr.getBytes(ENCODING);
            if (key.length > temp.length) {
                System.arraycopy(temp, 0, key, 0, temp.length);
            } else {
                System.arraycopy(temp, 0, key, 0, key.length);
            }
            return key;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String encryptBASE64(byte[] plaintextBytes) throws Exception {
        return new String(base64.encode(plaintextBytes), ENCODING);
    }

    public static String encryptAES(String content, String key) {
        try {
            KeyGenerator kgen = KeyGenerator.getInstance(KEY_ALGORITHM_AES);
            SecureRandom random = SecureRandom.getInstance(SIGN_ALGORITHMS);
            random.setSeed(key.getBytes(ENCODING));
            kgen.init(128, random);
            SecretKey secretKey = kgen.generateKey();
            byte[] enCodeFormat = secretKey.getEncoded();
            SecretKeySpec secretKeySpec = new SecretKeySpec(enCodeFormat, KEY_ALGORITHM_AES);
            Cipher cipher = Cipher.getInstance(KEY_ALGORITHM_AES);
            byte[] byteContent = content.getBytes(ENCODING);
            cipher.init(1, secretKeySpec);
            byte[] byteRresult = cipher.doFinal(byteContent);
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < byteRresult.length; ++i) {
                String hex = Integer.toHexString(byteRresult[i] & 0xFF);
                if (hex.length() == 1) {
                    hex = '0' + hex;
                }
                sb.append(hex.toUpperCase());
            }
            return sb.toString();
        }
        catch (Exception e) {
            e.toString();
            return null;
        }
    }

    private static enum EncryptionType {
        DESEDE,
        AES;


        public static EncryptionType getInstance(String encrypt) {
            return Arrays.stream(EncryptionType.values()).filter(v -> v.name().equalsIgnoreCase(encrypt)).findFirst().orElse(null);
        }
    }
}

