/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.formats.json.canal;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.formats.common.TimestampFormat;
import org.apache.flink.formats.json.JsonFormatOptions;
import org.apache.flink.formats.json.JsonFormatOptionsUtil;
import org.apache.flink.formats.json.canal.CanalJsonFormatOptions;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.DeserializationFormatFactory;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.Factory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.SerializationFormatFactory;
import org.apache.inlong.sort.formats.json.canal.CanalJsonEnhancedDecodingFormat;
import org.apache.inlong.sort.formats.json.canal.CanalJsonEnhancedEncodingFormat;

public class CanalJsonEnhancedFormatFactory
implements DeserializationFormatFactory,
SerializationFormatFactory {
    public static final String IDENTIFIER = "canal-json-inlong";

    public DecodingFormat<DeserializationSchema<RowData>> createDecodingFormat(DynamicTableFactory.Context context, ReadableConfig formatOptions) {
        FactoryUtil.validateFactoryOptions((Factory)this, (ReadableConfig)formatOptions);
        JsonFormatOptionsUtil.validateDecodingFormatOptions(formatOptions);
        String database = formatOptions.getOptional(CanalJsonFormatOptions.DATABASE_INCLUDE).orElse(null);
        String table = formatOptions.getOptional(CanalJsonFormatOptions.TABLE_INCLUDE).orElse(null);
        boolean ignoreParseErrors = (Boolean)formatOptions.get(CanalJsonFormatOptions.IGNORE_PARSE_ERRORS);
        TimestampFormat timestampFormat = JsonFormatOptionsUtil.getTimestampFormat(formatOptions);
        return new CanalJsonEnhancedDecodingFormat(database, table, ignoreParseErrors, timestampFormat);
    }

    public EncodingFormat<SerializationSchema<RowData>> createEncodingFormat(DynamicTableFactory.Context context, ReadableConfig formatOptions) {
        FactoryUtil.validateFactoryOptions((Factory)this, (ReadableConfig)formatOptions);
        JsonFormatOptionsUtil.validateDecodingFormatOptions(formatOptions);
        TimestampFormat timestampFormat = JsonFormatOptionsUtil.getTimestampFormat(formatOptions);
        JsonFormatOptions.MapNullKeyMode mapNullKeyMode = JsonFormatOptionsUtil.getMapNullKeyMode(formatOptions);
        String mapNullKeyLiteral = (String)formatOptions.get(CanalJsonFormatOptions.JSON_MAP_NULL_KEY_LITERAL);
        boolean encodeDecimalAsPlainNumber = (Boolean)formatOptions.get(JsonFormatOptions.ENCODE_DECIMAL_AS_PLAIN_NUMBER);
        return new CanalJsonEnhancedEncodingFormat(timestampFormat, mapNullKeyMode, mapNullKeyLiteral, encodeDecimalAsPlainNumber);
    }

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        return Collections.emptySet();
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(CanalJsonFormatOptions.IGNORE_PARSE_ERRORS);
        options.add(CanalJsonFormatOptions.TIMESTAMP_FORMAT);
        options.add(CanalJsonFormatOptions.DATABASE_INCLUDE);
        options.add(CanalJsonFormatOptions.TABLE_INCLUDE);
        options.add(CanalJsonFormatOptions.JSON_MAP_NULL_KEY_MODE);
        options.add(CanalJsonFormatOptions.JSON_MAP_NULL_KEY_LITERAL);
        options.add(JsonFormatOptions.ENCODE_DECIMAL_AS_PLAIN_NUMBER);
        return options;
    }
}

