/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.csv;

import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.file.src.reader.SimpleStreamFormat;
import org.apache.flink.connector.file.src.reader.StreamFormat;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.formats.common.Converter;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.MappingIterator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.dataformat.csv.CsvMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.dataformat.csv.CsvSchema;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class CsvReaderFormat<T>
extends SimpleStreamFormat<T> {
    private static final long serialVersionUID = 1L;
    private final CsvMapper mapper;
    private final CsvSchema schema;
    private final Class<Object> rootType;
    private final Converter<Object, T, Void> converter;
    private final TypeInformation<T> typeInformation;
    private boolean ignoreParseErrors;

    <R> CsvReaderFormat(CsvMapper mapper, CsvSchema schema, Class<R> rootType, Converter<R, T, Void> converter, TypeInformation<T> typeInformation, boolean ignoreParseErrors) {
        this.mapper = (CsvMapper)Preconditions.checkNotNull((Object)mapper);
        this.schema = (CsvSchema)Preconditions.checkNotNull((Object)schema);
        this.rootType = (Class)Preconditions.checkNotNull(rootType);
        this.typeInformation = (TypeInformation)Preconditions.checkNotNull(typeInformation);
        this.converter = (Converter)Preconditions.checkNotNull(converter);
        this.ignoreParseErrors = ignoreParseErrors;
    }

    public static <T> CsvReaderFormat<T> forSchema(CsvSchema schema, TypeInformation<T> typeInformation) {
        return CsvReaderFormat.forSchema(new CsvMapper(), schema, typeInformation);
    }

    public static <T> CsvReaderFormat<T> forSchema(CsvMapper mapper, CsvSchema schema, TypeInformation<T> typeInformation) {
        return new CsvReaderFormat<Object>(mapper, schema, typeInformation.getTypeClass(), (value, context) -> value, typeInformation, false);
    }

    public static <T> CsvReaderFormat<T> forPojo(Class<T> pojoType) {
        CsvMapper mapper = new CsvMapper();
        return CsvReaderFormat.forSchema(mapper, mapper.schemaFor(pojoType).withoutQuoteChar(), TypeInformation.of(pojoType));
    }

    public CsvReaderFormat<T> withIgnoreParseErrors() {
        return new CsvReaderFormat<T>(this.mapper, this.schema, this.rootType, this.converter, this.typeInformation, true);
    }

    public StreamFormat.Reader<T> createReader(Configuration config, FSDataInputStream stream) throws IOException {
        return new Reader<Object, T>(this.mapper.readerFor(this.rootType).with(this.schema).readValues((InputStream)stream), this.converter, this.ignoreParseErrors);
    }

    public TypeInformation<T> getProducedType() {
        return this.typeInformation;
    }

    private static final class Reader<R, T>
    implements StreamFormat.Reader<T> {
        private final MappingIterator<R> iterator;
        private final Converter<R, T, Void> converter;
        private final boolean ignoreParseErrors;

        public Reader(MappingIterator<R> iterator, Converter<R, T, Void> converter, boolean ignoreParseErrors) {
            this.iterator = (MappingIterator)Preconditions.checkNotNull(iterator);
            this.converter = (Converter)Preconditions.checkNotNull(converter);
            this.ignoreParseErrors = ignoreParseErrors;
        }

        @Nullable
        public T read() throws IOException {
            while (this.iterator.hasNext()) {
                try {
                    R nextElement = this.iterator.next();
                    return this.converter.convert(nextElement, null);
                }
                catch (Throwable t2) {
                    if (this.ignoreParseErrors) continue;
                    throw t2;
                }
            }
            return null;
        }

        public void close() throws IOException {
            this.iterator.close();
        }
    }
}

