/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro.utils;

import java.io.DataInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.flink.avro.shaded.org.apache.avro.io.Decoder;
import org.apache.flink.avro.shaded.org.apache.avro.util.Utf8;

public class DataInputDecoder
extends Decoder {
    private final Utf8 stringDecoder = new Utf8();
    private DataInput in;

    public void setIn(DataInput in) {
        this.in = in;
    }

    @Override
    public void readNull() {
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.in.readBoolean();
    }

    @Override
    public int readInt() throws IOException {
        return this.in.readInt();
    }

    @Override
    public long readLong() throws IOException {
        return this.in.readLong();
    }

    @Override
    public float readFloat() throws IOException {
        return this.in.readFloat();
    }

    @Override
    public double readDouble() throws IOException {
        return this.in.readDouble();
    }

    @Override
    public int readEnum() throws IOException {
        return this.readInt();
    }

    @Override
    public void readFixed(byte[] bytes, int start, int length) throws IOException {
        this.in.readFully(bytes, start, length);
    }

    @Override
    public ByteBuffer readBytes(ByteBuffer old) throws IOException {
        ByteBuffer result;
        int length = this.readInt();
        if (old != null && length <= old.capacity() && old.hasArray()) {
            result = old;
            result.clear();
        } else {
            result = ByteBuffer.allocate(length);
        }
        this.in.readFully(result.array(), result.arrayOffset() + result.position(), length);
        result.limit(length);
        return result;
    }

    @Override
    public void skipFixed(int length) throws IOException {
        this.skipBytes(length);
    }

    @Override
    public void skipBytes() throws IOException {
        int num = this.readInt();
        this.skipBytes(num);
    }

    @Override
    public Utf8 readString(Utf8 old) throws IOException {
        int length = this.readInt();
        Utf8 result = old != null ? old : new Utf8();
        result.setByteLength(length);
        if (length > 0) {
            this.in.readFully(result.getBytes(), 0, length);
        }
        return result;
    }

    @Override
    public String readString() throws IOException {
        return this.readString(this.stringDecoder).toString();
    }

    @Override
    public void skipString() throws IOException {
        int len = this.readInt();
        this.skipBytes(len);
    }

    @Override
    public long readArrayStart() throws IOException {
        return DataInputDecoder.readVarLongCount(this.in);
    }

    @Override
    public long arrayNext() throws IOException {
        return DataInputDecoder.readVarLongCount(this.in);
    }

    @Override
    public long skipArray() throws IOException {
        return DataInputDecoder.readVarLongCount(this.in);
    }

    @Override
    public long readMapStart() throws IOException {
        return DataInputDecoder.readVarLongCount(this.in);
    }

    @Override
    public long mapNext() throws IOException {
        return DataInputDecoder.readVarLongCount(this.in);
    }

    @Override
    public long skipMap() throws IOException {
        return DataInputDecoder.readVarLongCount(this.in);
    }

    @Override
    public int readIndex() throws IOException {
        return this.readInt();
    }

    private void skipBytes(int num) throws IOException {
        while (num > 0) {
            num -= this.in.skipBytes(num);
        }
    }

    public static long readVarLongCount(DataInput in) throws IOException {
        long curr;
        long value = in.readUnsignedByte();
        if ((value & 0x80L) == 0L) {
            return value;
        }
        int shift = 7;
        value &= 0x7FL;
        while (((curr = (long)in.readUnsignedByte()) & 0x80L) != 0L) {
            value |= (curr & 0x7FL) << shift;
            shift += 7;
        }
        return value |= curr << shift;
    }
}

