/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.hadoop.hbase.util.JVM;
import org.apache.hadoop.hbase.util.UnsafeAccess;
import org.apache.hadoop.hbase.util.UnsafeAvailChecker;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Unsafe;

@InterfaceAudience.Private
public class ClassSize {
    private static final Logger LOG = LoggerFactory.getLogger(ClassSize.class);
    public static final int ARRAY;
    public static final int ARRAYLIST;
    public static final int LINKEDLIST;
    public static final int LINKEDLIST_ENTRY;
    public static final int BYTE_BUFFER;
    public static final int INTEGER;
    public static final int MAP_ENTRY;
    public static final int OBJECT;
    public static final int REFERENCE;
    public static final int STRING;
    public static final int TREEMAP;
    public static final int CONCURRENT_HASHMAP;
    public static final int CONCURRENT_HASHMAP_ENTRY;
    public static final int CONCURRENT_HASHMAP_SEGMENT;
    public static final int CONCURRENT_SKIPLISTMAP;
    public static final int CONCURRENT_SKIPLISTMAP_ENTRY;
    public static final int CELL_FLAT_MAP;
    public static final int CELL_CHUNK_MAP;
    public static final int CELL_CHUNK_MAP_ENTRY;
    public static final int CELL_ARRAY_MAP;
    public static final int CELL_ARRAY_MAP_ENTRY;
    public static final int REENTRANT_LOCK;
    public static final int ATOMIC_LONG;
    public static final int ATOMIC_INTEGER;
    public static final int ATOMIC_BOOLEAN;
    public static final int ATOMIC_REFERENCE;
    public static final int COPYONWRITE_ARRAYSET;
    public static final int COPYONWRITE_ARRAYLIST;
    public static final int TIMERANGE;
    public static final int SYNC_TIMERANGE_TRACKER;
    public static final int NON_SYNC_TIMERANGE_TRACKER;
    public static final int CELL_SET;
    public static final int STORE_SERVICES;
    private static final MemoryLayout memoryLayout;
    private static final boolean USE_UNSAFE_LAYOUT;

    private static MemoryLayout getMemoryLayout() {
        String enabled = System.getProperty("hbase.memorylayout.use.unsafe");
        if (UnsafeAvailChecker.isAvailable() && (enabled == null || Boolean.parseBoolean(enabled))) {
            LOG.debug("Using Unsafe to estimate memory layout");
            return new UnsafeLayout();
        }
        LOG.debug("Not using Unsafe to estimate memory layout");
        return new MemoryLayout();
    }

    public static boolean useUnsafeLayout() {
        return USE_UNSAFE_LAYOUT;
    }

    private static int[] getSizeCoefficients(Class cl, boolean debug) {
        int primitives = 0;
        int arrays = 0;
        int references = 0;
        int index = 0;
        while (null != cl) {
            Field[] field = cl.getDeclaredFields();
            if (null != field) {
                for (Field aField : field) {
                    if (Modifier.isStatic(aField.getModifiers())) continue;
                    Class<?> fieldClass = aField.getType();
                    if (fieldClass.isArray()) {
                        ++arrays;
                        ++references;
                    } else if (!fieldClass.isPrimitive()) {
                        ++references;
                    } else {
                        String name = fieldClass.getName();
                        if (name.equals("int") || name.equals("I")) {
                            primitives += 4;
                        } else if (name.equals("long") || name.equals("J")) {
                            primitives += 8;
                        } else if (name.equals("boolean") || name.equals("Z")) {
                            ++primitives;
                        } else if (name.equals("short") || name.equals("S")) {
                            primitives += 2;
                        } else if (name.equals("byte") || name.equals("B")) {
                            ++primitives;
                        } else if (name.equals("char") || name.equals("C")) {
                            primitives += 2;
                        } else if (name.equals("float") || name.equals("F")) {
                            primitives += 4;
                        } else if (name.equals("double") || name.equals("D")) {
                            primitives += 8;
                        }
                    }
                    if (debug && LOG.isDebugEnabled()) {
                        LOG.debug("" + index + " " + aField.getName() + " " + aField.getType());
                    }
                    ++index;
                }
            }
            cl = cl.getSuperclass();
        }
        return new int[]{primitives, arrays, references};
    }

    private static long estimateBaseFromCoefficients(int[] coeff, boolean debug) {
        long prealign_size = OBJECT + coeff[0] + coeff[2] * REFERENCE;
        long size = ClassSize.align(prealign_size) + (long)ClassSize.align(coeff[1] * ARRAY);
        if (debug && LOG.isDebugEnabled()) {
            LOG.debug("Primitives=" + coeff[0] + ", arrays=" + coeff[1] + ", references=" + coeff[2] + ", refSize " + REFERENCE + ", size=" + size + ", prealign_size=" + prealign_size);
        }
        return size;
    }

    public static long estimateBase(Class cl, boolean debug) {
        return ClassSize.estimateBaseFromCoefficients(ClassSize.getSizeCoefficients(cl, debug), debug);
    }

    public static int align(int num) {
        return (int)ClassSize.align((long)num);
    }

    public static long align(long num) {
        return memoryLayout.align(num);
    }

    public static boolean is32BitJVM() {
        String model = System.getProperty("sun.arch.data.model");
        return model != null && model.equals("32");
    }

    public static long sizeOf(byte[] b) {
        return memoryLayout.sizeOfByteArray(b.length);
    }

    public static long sizeOfByteArray(int len) {
        return memoryLayout.sizeOfByteArray(len);
    }

    static {
        memoryLayout = ClassSize.getMemoryLayout();
        USE_UNSAFE_LAYOUT = memoryLayout instanceof UnsafeLayout;
        REFERENCE = memoryLayout.oopSize();
        OBJECT = memoryLayout.headerSize();
        ARRAY = memoryLayout.arrayHeaderSize();
        ARRAYLIST = ClassSize.align(OBJECT + REFERENCE + 8) + ClassSize.align(ARRAY);
        LINKEDLIST = ClassSize.align(OBJECT + 8 + 2 * REFERENCE);
        LINKEDLIST_ENTRY = ClassSize.align(OBJECT + 2 * REFERENCE);
        BYTE_BUFFER = JVM.getJVMSpecVersion() < 17 ? ClassSize.align(OBJECT + REFERENCE + 20 + 3 + 8) + ClassSize.align(ARRAY) : ClassSize.align(OBJECT + 2 * REFERENCE + 20 + 3 + 8) + ClassSize.align(ARRAY);
        INTEGER = ClassSize.align(OBJECT + 4);
        MAP_ENTRY = ClassSize.align(OBJECT + 5 * REFERENCE + 1);
        TREEMAP = ClassSize.align(OBJECT + 8 + 7 * REFERENCE);
        STRING = (int)ClassSize.estimateBase(String.class, false);
        CONCURRENT_HASHMAP = (int)ClassSize.estimateBase(ConcurrentHashMap.class, false);
        CONCURRENT_HASHMAP_ENTRY = ClassSize.align(REFERENCE + OBJECT + 3 * REFERENCE + 8);
        CONCURRENT_HASHMAP_SEGMENT = ClassSize.align(REFERENCE + OBJECT + 12 + 4 + ARRAY);
        CONCURRENT_SKIPLISTMAP = (int)ClassSize.estimateBase(ConcurrentSkipListMap.class, false);
        CELL_FLAT_MAP = OBJECT + 8 + 1 + REFERENCE;
        CELL_ARRAY_MAP = ClassSize.align(CELL_FLAT_MAP + REFERENCE + ARRAY);
        CELL_CHUNK_MAP = ClassSize.align(CELL_FLAT_MAP + REFERENCE + ARRAY);
        CONCURRENT_SKIPLISTMAP_ENTRY = ClassSize.align(ClassSize.align(OBJECT + 3 * REFERENCE) + ClassSize.align((OBJECT + 3 * REFERENCE) / 2));
        CELL_ARRAY_MAP_ENTRY = ClassSize.align(REFERENCE);
        CELL_CHUNK_MAP_ENTRY = 20;
        REENTRANT_LOCK = ClassSize.align(OBJECT + 3 * REFERENCE);
        ATOMIC_LONG = ClassSize.align(OBJECT + 8);
        ATOMIC_INTEGER = ClassSize.align(OBJECT + 4);
        ATOMIC_BOOLEAN = ClassSize.align(OBJECT + 1);
        ATOMIC_REFERENCE = ClassSize.align(OBJECT + REFERENCE);
        COPYONWRITE_ARRAYSET = ClassSize.align(OBJECT + REFERENCE);
        COPYONWRITE_ARRAYLIST = ClassSize.align(OBJECT + 2 * REFERENCE + ARRAY);
        TIMERANGE = ClassSize.align(OBJECT + 16 + 1);
        SYNC_TIMERANGE_TRACKER = ClassSize.align(OBJECT + 2 * REFERENCE);
        NON_SYNC_TIMERANGE_TRACKER = ClassSize.align(OBJECT + 16);
        CELL_SET = ClassSize.align(OBJECT + REFERENCE + 4);
        STORE_SERVICES = ClassSize.align(OBJECT + REFERENCE + ATOMIC_LONG);
    }

    private static class UnsafeLayout
    extends MemoryLayout {
        @Override
        int headerSize() {
            try {
                return (int)UnsafeAccess.theUnsafe.objectFieldOffset(HeaderSize.class.getDeclaredField("a"));
            }
            catch (NoSuchFieldException | SecurityException e) {
                LOG.error(e.toString(), (Throwable)e);
                return super.headerSize();
            }
        }

        @Override
        int arrayHeaderSize() {
            return UnsafeAccess.theUnsafe.arrayBaseOffset(byte[].class);
        }

        @Override
        int oopSize() {
            return Unsafe.ARRAY_OBJECT_INDEX_SCALE;
        }

        @Override
        long sizeOfByteArray(int len) {
            return this.align(ARRAY + len * Unsafe.ARRAY_BYTE_INDEX_SCALE);
        }

        private static final class HeaderSize {
            private byte a;

            private HeaderSize() {
            }
        }
    }

    private static class MemoryLayout {
        private MemoryLayout() {
        }

        int headerSize() {
            return 2 * this.oopSize();
        }

        int arrayHeaderSize() {
            return (int)this.align(3 * this.oopSize());
        }

        int oopSize() {
            return ClassSize.is32BitJVM() ? 4 : 8;
        }

        public long align(long num) {
            return num + 7L >> 3 << 3;
        }

        long sizeOfByteArray(int len) {
            return this.align(ARRAY + len);
        }
    }
}

