/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloudapi.common.provider;

import com.tencentcloudapi.common.Credential;
import com.tencentcloudapi.common.exception.TencentCloudSDKException;
import com.tencentcloudapi.common.provider.CredentialsProvider;
import com.tencentcloudapi.common.provider.CvmRoleCredential;
import com.tencentcloudapi.common.provider.EnvironmentVariableCredentialsProvider;
import com.tencentcloudapi.common.provider.OIDCRoleArnProvider;
import com.tencentcloudapi.common.provider.ProfileCredentialsProvider;
import java.io.IOException;

public class DefaultCredentialsProvider
implements CredentialsProvider {
    @Override
    public Credential getCredentials() throws TencentCloudSDKException {
        try {
            Credential cred = new EnvironmentVariableCredentialsProvider().getCredentials();
            return cred;
        }
        catch (TencentCloudSDKException tencentCloudSDKException) {
            try {
                Credential cred = new ProfileCredentialsProvider().getCredentials();
                return cred;
            }
            catch (TencentCloudSDKException tencentCloudSDKException2) {
                Credential cred = new CvmRoleCredential();
                if (((Credential)cred).getSecretId() != null && ((Credential)cred).getSecretKey() != null && ((Credential)cred).getToken() != null) {
                    return cred;
                }
                try {
                    cred = new OIDCRoleArnProvider().getCredentials();
                    return cred;
                }
                catch (IOException iOException) {
                    throw new TencentCloudSDKException("No valid credential");
                }
            }
        }
    }
}

