/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import java.util.HashMap;
import java.util.Map;
import org.apache.pulsar.client.api.schema.SchemaDefinition;
import org.apache.pulsar.client.api.schema.SchemaDefinitionBuilder;
import org.apache.pulsar.client.api.schema.SchemaReader;
import org.apache.pulsar.client.api.schema.SchemaWriter;
import org.apache.pulsar.client.impl.schema.SchemaDefinitionImpl;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;

public class SchemaDefinitionBuilderImpl<T>
implements SchemaDefinitionBuilder<T> {
    public static final String ALWAYS_ALLOW_NULL = "__alwaysAllowNull";
    public static final String JSR310_CONVERSION_ENABLED = "__jsr310ConversionEnabled";
    private Class<T> clazz;
    private boolean alwaysAllowNull = true;
    private boolean jsr310ConversionEnabled = false;
    private Map<String, String> properties = new HashMap<String, String>();
    private String jsonDef;
    private boolean supportSchemaVersioning = false;
    private SchemaReader<T> reader;
    private SchemaWriter<T> writer;

    public SchemaDefinitionBuilder<T> withAlwaysAllowNull(boolean alwaysAllowNull) {
        this.alwaysAllowNull = alwaysAllowNull;
        return this;
    }

    public SchemaDefinitionBuilder<T> withJSR310ConversionEnabled(boolean jsr310ConversionEnabled) {
        this.jsr310ConversionEnabled = jsr310ConversionEnabled;
        return this;
    }

    public SchemaDefinitionBuilder<T> addProperty(String key, String value) {
        this.properties.put(key, value);
        return this;
    }

    public SchemaDefinitionBuilder<T> withPojo(Class clazz) {
        this.clazz = clazz;
        return this;
    }

    public SchemaDefinitionBuilder<T> withJsonDef(String jsonDef) {
        this.jsonDef = jsonDef;
        return this;
    }

    public SchemaDefinitionBuilder<T> withSupportSchemaVersioning(boolean supportSchemaVersioning) {
        this.supportSchemaVersioning = supportSchemaVersioning;
        return this;
    }

    public SchemaDefinitionBuilder<T> withProperties(Map<String, String> properties) {
        this.properties = properties;
        if (properties.containsKey(ALWAYS_ALLOW_NULL)) {
            this.alwaysAllowNull = Boolean.parseBoolean(properties.get(ALWAYS_ALLOW_NULL));
        }
        if (properties.containsKey(ALWAYS_ALLOW_NULL)) {
            this.jsr310ConversionEnabled = Boolean.parseBoolean(properties.get(JSR310_CONVERSION_ENABLED));
        }
        return this;
    }

    public SchemaDefinitionBuilder<T> withSchemaReader(SchemaReader<T> reader) {
        this.reader = reader;
        return this;
    }

    public SchemaDefinitionBuilder<T> withSchemaWriter(SchemaWriter<T> writer) {
        this.writer = writer;
        return this;
    }

    public SchemaDefinition<T> build() {
        Preconditions.checkArgument(StringUtils.isNotBlank(this.jsonDef) || this.clazz != null, "Must specify one of the pojo or jsonDef for the schema definition.");
        Preconditions.checkArgument(!StringUtils.isNotBlank(this.jsonDef) || this.clazz == null, "Not allowed to set pojo and jsonDef both for the schema definition.");
        Preconditions.checkArgument(this.reader != null && this.writer != null || this.reader == null && this.writer == null, "Must specify reader and writer or none of them.");
        this.properties.put(ALWAYS_ALLOW_NULL, String.valueOf(this.alwaysAllowNull));
        this.properties.put(JSR310_CONVERSION_ENABLED, String.valueOf(this.jsr310ConversionEnabled));
        return new SchemaDefinitionImpl<T>(this.clazz, this.jsonDef, this.alwaysAllowNull, this.properties, this.supportSchemaVersioning, this.jsr310ConversionEnabled, this.reader, this.writer);
    }
}

