/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema;

import com.fasterxml.classmate.ResolvedType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import springfox.documentation.schema.ModelDependencyProvider;
import springfox.documentation.spi.schema.contexts.ModelContext;

@Component
@Qualifier(value="cachedModelDependencies")
public class CachingModelDependencyProvider
implements ModelDependencyProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(CachingModelDependencyProvider.class);
    private final Map<ModelContext, Set<ResolvedType>> cache = new HashMap<ModelContext, Set<ResolvedType>>();
    private final Function<ModelContext, Set<ResolvedType>> lookup = delegate::dependentModels;

    @Autowired
    public CachingModelDependencyProvider(@Qualifier(value="default") ModelDependencyProvider delegate) {
    }

    @Override
    public Set<ResolvedType> dependentModels(ModelContext modelContext) {
        try {
            return this.cache.computeIfAbsent(modelContext, this.lookup);
        }
        catch (Exception e) {
            LOGGER.warn("Exception calculating dependencies for model -> {}, {}", (Object)modelContext.description(), (Object)e.getMessage());
            return new HashSet<ResolvedType>();
        }
    }
}

