/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util;

import java.util.Objects;
import java.util.function.BiConsumer;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.util.RangeSets;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableRangeSet;
import org.apache.flink.calcite.shaded.com.google.common.collect.Range;
import org.apache.flink.calcite.shaded.com.google.common.collect.RangeSet;

public class Sarg<C extends Comparable<C>>
implements Comparable<Sarg<C>> {
    public final RangeSet<C> rangeSet;
    public final boolean containsNull;
    public final int pointCount;

    private Sarg(ImmutableRangeSet<C> rangeSet, boolean containsNull) {
        this.rangeSet = Objects.requireNonNull(rangeSet);
        this.containsNull = containsNull;
        this.pointCount = RangeSets.countPoints(rangeSet);
    }

    public static <C extends Comparable<C>> Sarg<C> of(boolean containsNull, RangeSet<C> rangeSet) {
        return new Sarg<C>(ImmutableRangeSet.copyOf(rangeSet), containsNull);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.printTo(sb, StringBuilder::append);
        return sb.toString();
    }

    public StringBuilder printTo(StringBuilder sb, BiConsumer<StringBuilder, C> valuePrinter) {
        sb.append("Sarg[");
        RangeSets.Consumer printer = RangeSets.printer(sb, valuePrinter);
        Ord.forEach(this.rangeSet.asRanges(), (r, i) -> {
            if (i > 0) {
                sb.append(", ");
            }
            RangeSets.forEach(r, printer);
        });
        if (this.containsNull) {
            sb.append(", null");
        }
        return sb.append("]");
    }

    @Override
    public int compareTo(Sarg<C> o) {
        return RangeSets.compare(this.rangeSet, o.rangeSet);
    }

    public int hashCode() {
        return RangeSets.hashCode(this.rangeSet) * 31 + (this.containsNull ? 2 : 3);
    }

    public boolean equals(Object o) {
        return o == this || o instanceof Sarg && this.rangeSet.equals(((Sarg)o).rangeSet) && this.containsNull == ((Sarg)o).containsNull;
    }

    public boolean isPoints() {
        return this.pointCount == this.rangeSet.asRanges().size();
    }

    public boolean isComplementedPoints() {
        return this.rangeSet.span().encloses(Range.all()) && this.rangeSet.complement().asRanges().stream().allMatch(RangeSets::isPoint);
    }
}

