/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sink.kudu;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonTypeDefine;
import org.apache.inlong.manager.pojo.sink.SinkRequest;
import org.apache.inlong.manager.pojo.sink.StreamSink;
import org.apache.inlong.manager.pojo.sink.kudu.KuduSinkRequest;

@ApiModel(value="Kudu sink info")
@JsonTypeDefine(value="KUDU")
public class KuduSink
extends StreamSink {
    @ApiModelProperty(value="Kudu masters, a comma separated list of 'host:port' pairs")
    private String masters;
    @ApiModelProperty(value="Target table name")
    private String tableName;
    @ApiModelProperty(value="Partition field list")
    private String partitionKey;
    @ApiModelProperty(value="Buckets for the newly created table")
    private Integer buckets;

    public KuduSink() {
        this.setSinkType("KUDU");
    }

    @Override
    public SinkRequest genSinkRequest() {
        return (SinkRequest)CommonBeanUtils.copyProperties((Object)this, KuduSinkRequest::new);
    }

    protected KuduSink(KuduSinkBuilder<?, ?> b) {
        super((StreamSink.StreamSinkBuilder<?, ?>)b);
        this.masters = ((KuduSinkBuilder)b).masters;
        this.tableName = ((KuduSinkBuilder)b).tableName;
        this.partitionKey = ((KuduSinkBuilder)b).partitionKey;
        this.buckets = ((KuduSinkBuilder)b).buckets;
    }

    public static KuduSinkBuilder<?, ?> builder() {
        return new KuduSinkBuilderImpl();
    }

    public String getMasters() {
        return this.masters;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getPartitionKey() {
        return this.partitionKey;
    }

    public Integer getBuckets() {
        return this.buckets;
    }

    public void setMasters(String masters) {
        this.masters = masters;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setPartitionKey(String partitionKey) {
        this.partitionKey = partitionKey;
    }

    public void setBuckets(Integer buckets) {
        this.buckets = buckets;
    }

    public KuduSink(String masters, String tableName, String partitionKey, Integer buckets) {
        this.masters = masters;
        this.tableName = tableName;
        this.partitionKey = partitionKey;
        this.buckets = buckets;
    }

    @Override
    public String toString() {
        return "KuduSink(super=" + super.toString() + ", masters=" + this.getMasters() + ", tableName=" + this.getTableName() + ", partitionKey=" + this.getPartitionKey() + ", buckets=" + this.getBuckets() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KuduSink)) {
            return false;
        }
        KuduSink other = (KuduSink)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$buckets = this.getBuckets();
        Integer other$buckets = other.getBuckets();
        if (this$buckets == null ? other$buckets != null : !((Object)this$buckets).equals(other$buckets)) {
            return false;
        }
        String this$masters = this.getMasters();
        String other$masters = other.getMasters();
        if (this$masters == null ? other$masters != null : !this$masters.equals(other$masters)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$partitionKey = this.getPartitionKey();
        String other$partitionKey = other.getPartitionKey();
        return !(this$partitionKey == null ? other$partitionKey != null : !this$partitionKey.equals(other$partitionKey));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof KuduSink;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $buckets = this.getBuckets();
        result = result * 59 + ($buckets == null ? 43 : ((Object)$buckets).hashCode());
        String $masters = this.getMasters();
        result = result * 59 + ($masters == null ? 43 : $masters.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $partitionKey = this.getPartitionKey();
        result = result * 59 + ($partitionKey == null ? 43 : $partitionKey.hashCode());
        return result;
    }

    private static final class KuduSinkBuilderImpl
    extends KuduSinkBuilder<KuduSink, KuduSinkBuilderImpl> {
        private KuduSinkBuilderImpl() {
        }

        @Override
        protected KuduSinkBuilderImpl self() {
            return this;
        }

        @Override
        public KuduSink build() {
            return new KuduSink(this);
        }
    }

    public static abstract class KuduSinkBuilder<C extends KuduSink, B extends KuduSinkBuilder<C, B>>
    extends StreamSink.StreamSinkBuilder<C, B> {
        private String masters;
        private String tableName;
        private String partitionKey;
        private Integer buckets;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B masters(String masters) {
            this.masters = masters;
            return (B)this.self();
        }

        public B tableName(String tableName) {
            this.tableName = tableName;
            return (B)this.self();
        }

        public B partitionKey(String partitionKey) {
            this.partitionKey = partitionKey;
            return (B)this.self();
        }

        public B buckets(Integer buckets) {
            this.buckets = buckets;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "KuduSink.KuduSinkBuilder(super=" + super.toString() + ", masters=" + this.masters + ", tableName=" + this.tableName + ", partitionKey=" + this.partitionKey + ", buckets=" + this.buckets + ")";
        }
    }
}

