/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.node.cos;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.pojo.node.cos.COSDataNodeRequest;

@ApiModel(value="COS data node info")
public class COSDataNodeDTO {
    @ApiModelProperty(value="COS bucket name")
    private String bucketName;
    @ApiModelProperty(value="COS secret id")
    private String credentialsId;
    @ApiModelProperty(value="COS secret key")
    private String credentialsKey;
    @ApiModelProperty(value="COS region")
    private String region;

    public static COSDataNodeDTO getFromRequest(COSDataNodeRequest request, String extParams) {
        COSDataNodeDTO dto = StringUtils.isNotBlank((CharSequence)extParams) ? COSDataNodeDTO.getFromJson(extParams) : new COSDataNodeDTO();
        return (COSDataNodeDTO)CommonBeanUtils.copyProperties((Object)request, (Object)dto, (boolean)true);
    }

    public static COSDataNodeDTO getFromJson(@NotNull String extParams) {
        try {
            return (COSDataNodeDTO)JsonUtils.parseObject((String)extParams, COSDataNodeDTO.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.CLUSTER_INFO_INCORRECT, String.format("Failed to parse extParams for COS node: %s", e.getMessage()));
        }
    }

    public static COSDataNodeDTOBuilder builder() {
        return new COSDataNodeDTOBuilder();
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public String getCredentialsKey() {
        return this.credentialsKey;
    }

    public String getRegion() {
        return this.region;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    public void setCredentialsKey(String credentialsKey) {
        this.credentialsKey = credentialsKey;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof COSDataNodeDTO)) {
            return false;
        }
        COSDataNodeDTO other = (COSDataNodeDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$bucketName = this.getBucketName();
        String other$bucketName = other.getBucketName();
        if (this$bucketName == null ? other$bucketName != null : !this$bucketName.equals(other$bucketName)) {
            return false;
        }
        String this$credentialsId = this.getCredentialsId();
        String other$credentialsId = other.getCredentialsId();
        if (this$credentialsId == null ? other$credentialsId != null : !this$credentialsId.equals(other$credentialsId)) {
            return false;
        }
        String this$credentialsKey = this.getCredentialsKey();
        String other$credentialsKey = other.getCredentialsKey();
        if (this$credentialsKey == null ? other$credentialsKey != null : !this$credentialsKey.equals(other$credentialsKey)) {
            return false;
        }
        String this$region = this.getRegion();
        String other$region = other.getRegion();
        return !(this$region == null ? other$region != null : !this$region.equals(other$region));
    }

    protected boolean canEqual(Object other) {
        return other instanceof COSDataNodeDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $bucketName = this.getBucketName();
        result = result * 59 + ($bucketName == null ? 43 : $bucketName.hashCode());
        String $credentialsId = this.getCredentialsId();
        result = result * 59 + ($credentialsId == null ? 43 : $credentialsId.hashCode());
        String $credentialsKey = this.getCredentialsKey();
        result = result * 59 + ($credentialsKey == null ? 43 : $credentialsKey.hashCode());
        String $region = this.getRegion();
        result = result * 59 + ($region == null ? 43 : $region.hashCode());
        return result;
    }

    public String toString() {
        return "COSDataNodeDTO(bucketName=" + this.getBucketName() + ", credentialsId=" + this.getCredentialsId() + ", credentialsKey=" + this.getCredentialsKey() + ", region=" + this.getRegion() + ")";
    }

    public COSDataNodeDTO() {
    }

    public COSDataNodeDTO(String bucketName, String credentialsId, String credentialsKey, String region) {
        this.bucketName = bucketName;
        this.credentialsId = credentialsId;
        this.credentialsKey = credentialsKey;
        this.region = region;
    }

    public static class COSDataNodeDTOBuilder {
        private String bucketName;
        private String credentialsId;
        private String credentialsKey;
        private String region;

        COSDataNodeDTOBuilder() {
        }

        public COSDataNodeDTOBuilder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public COSDataNodeDTOBuilder credentialsId(String credentialsId) {
            this.credentialsId = credentialsId;
            return this;
        }

        public COSDataNodeDTOBuilder credentialsKey(String credentialsKey) {
            this.credentialsKey = credentialsKey;
            return this;
        }

        public COSDataNodeDTOBuilder region(String region) {
            this.region = region;
            return this;
        }

        public COSDataNodeDTO build() {
            return new COSDataNodeDTO(this.bucketName, this.credentialsId, this.credentialsKey, this.region);
        }

        public String toString() {
            return "COSDataNodeDTO.COSDataNodeDTOBuilder(bucketName=" + this.bucketName + ", credentialsId=" + this.credentialsId + ", credentialsKey=" + this.credentialsKey + ", region=" + this.region + ")";
        }
    }
}

