/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.cluster.agent;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.pojo.cluster.agent.AgentClusterRequest;

@ApiModel(value="Agent cluster info")
public class AgentClusterDTO {
    @ApiModelProperty(value="Version number of the server list collected by the cluster")
    private Integer serverVersion;

    public static AgentClusterDTO getFromRequest(AgentClusterRequest request, String extParams) {
        AgentClusterDTO dto = StringUtils.isNotBlank((CharSequence)extParams) ? AgentClusterDTO.getFromJson(extParams) : new AgentClusterDTO();
        return (AgentClusterDTO)CommonBeanUtils.copyProperties((Object)request, (Object)dto, (boolean)true);
    }

    public static AgentClusterDTO getFromJson(@NotNull String extParams) {
        try {
            return (AgentClusterDTO)JsonUtils.parseObject((String)extParams, AgentClusterDTO.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.CLUSTER_INFO_INCORRECT, String.format("parse extParams of Agent Cluster failure: %s", e.getMessage()));
        }
    }

    public static AgentClusterDTOBuilder builder() {
        return new AgentClusterDTOBuilder();
    }

    public Integer getServerVersion() {
        return this.serverVersion;
    }

    public void setServerVersion(Integer serverVersion) {
        this.serverVersion = serverVersion;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AgentClusterDTO)) {
            return false;
        }
        AgentClusterDTO other = (AgentClusterDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$serverVersion = this.getServerVersion();
        Integer other$serverVersion = other.getServerVersion();
        return !(this$serverVersion == null ? other$serverVersion != null : !((Object)this$serverVersion).equals(other$serverVersion));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AgentClusterDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $serverVersion = this.getServerVersion();
        result = result * 59 + ($serverVersion == null ? 43 : ((Object)$serverVersion).hashCode());
        return result;
    }

    public String toString() {
        return "AgentClusterDTO(serverVersion=" + this.getServerVersion() + ")";
    }

    public AgentClusterDTO() {
    }

    public AgentClusterDTO(Integer serverVersion) {
        this.serverVersion = serverVersion;
    }

    public static class AgentClusterDTOBuilder {
        private Integer serverVersion;

        AgentClusterDTOBuilder() {
        }

        public AgentClusterDTOBuilder serverVersion(Integer serverVersion) {
            this.serverVersion = serverVersion;
            return this;
        }

        public AgentClusterDTO build() {
            return new AgentClusterDTO(this.serverVersion);
        }

        public String toString() {
            return "AgentClusterDTO.AgentClusterDTOBuilder(serverVersion=" + this.serverVersion + ")";
        }
    }
}

