/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.metrics.audit;

import java.util.HashSet;
import org.apache.inlong.agent.conf.AbstractConfiguration;
import org.apache.inlong.audit.AuditOperator;
import org.apache.inlong.audit.entity.AuditComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuditUtils.class);
    public static final int AGENT_ISOLATE_KEY = 1;
    public static int AUDIT_ID_AGENT_READ_SUCCESS = 3;
    public static int AUDIT_ID_AGENT_SEND_SUCCESS = 4;
    public static int AUDIT_ID_AGENT_READ_FAILED = 524291;
    public static int AUDIT_ID_AGENT_SEND_FAILED = 524292;
    public static int AUDIT_ID_AGENT_RESEND = 65540;
    public static int AUDIT_ID_AGENT_READ_SUCCESS_REAL_TIME = 0x40000001;
    public static int AUDIT_ID_AGENT_SEND_SUCCESS_REAL_TIME = 0x40000002;
    public static int AUDIT_ID_AGENT_READ_FAILED_REAL_TIME = 0x40000003;
    public static int AUDIT_ID_AGENT_SEND_FAILED_REAL_TIME = 0x40000004;
    public static int AUDIT_ID_AGENT_TRY_SEND_REAL_TIME = 0x40000005;
    public static int AUDIT_ID_AGENT_SEND_EXCEPTION_REAL_TIME = 0x40000006;
    public static int AUDIT_ID_AGENT_RESEND_REAL_TIME = 0x40000007;
    public static int AUDIT_ID_AGENT_SEND_EXCEPTION = 0x40000008;
    public static int AUDIT_ID_AGENT_TRY_SEND = 0x40000009;
    public static int AUDIT_ID_AGENT_ADD_INSTANCE_DB = 0x4000000A;
    public static int AUDIT_ID_AGENT_DEL_INSTANCE_DB = 0x4000000B;
    public static int AUDIT_ID_AGENT_ADD_INSTANCE_MEM = 0x4000000C;
    public static int AUDIT_ID_AGENT_DEL_INSTANCE_MEM = 0x4000000D;
    public static int AUDIT_ID_AGENT_TASK_MGR_HEARTBEAT = 0x4000000E;
    public static int AUDIT_ID_AGENT_TASK_HEARTBEAT = 0x4000000F;
    public static int AUDIT_ID_AGENT_INSTANCE_MGR_HEARTBEAT = 0x40000010;
    public static int AUDIT_ID_AGENT_INSTANCE_HEARTBEAT = 0x40000011;
    public static int AUDIT_ID_AGENT_ADD_INSTANCE_MEM_FAILED = 1073741842;
    public static int AUDIT_ID_AGENT_DEL_INSTANCE_MEM_UNUSUAL = 1073741843;
    private static boolean IS_AUDIT = true;

    public static void initAudit(AbstractConfiguration conf) {
        IS_AUDIT = conf.getBoolean("audit.enable", true);
        if (IS_AUDIT) {
            if (conf.hasKey("audit.proxys")) {
                HashSet<String> address = new HashSet<String>();
                address.add(conf.get("audit.proxys"));
                AuditOperator.getInstance().setAuditProxy(address);
            } else {
                AuditOperator.getInstance().setAuditProxy(AuditComponent.AGENT, conf.get("agent.manager.addr"), conf.get("agent.manager.auth.secretId"), conf.get("agent.manager.auth.secretKey"));
            }
            AuditOperator.getInstance().setLocalIP(conf.get("agent.local.ip"));
        }
    }

    public static void add(int auditID, String inlongGroupId, String inlongStreamId, long logTime, int count, long size, long version) {
        if (!IS_AUDIT) {
            return;
        }
        if (inlongGroupId == null || inlongStreamId == null) {
            LOGGER.error("invalid args inlongGroupId: {}, inlongStreamId: {}", (Object)inlongGroupId, (Object)inlongStreamId);
            return;
        }
        try {
            AuditOperator.getInstance().add(auditID, "-1", inlongGroupId, inlongStreamId, logTime, (long)count, size, version);
        }
        catch (Throwable e) {
            LOGGER.error("call audit add inlongGroupId: {}, inlongStreamId: {}, auditID {}, error", new Object[]{inlongGroupId, inlongStreamId, auditID, e});
        }
    }

    public static void add(int auditID, String inlongGroupId, String inlongStreamId, long logTime, int count, long size) {
        AuditUtils.add(auditID, inlongGroupId, inlongStreamId, logTime, count, size, -1L);
    }

    public static void send() {
        if (!IS_AUDIT) {
            return;
        }
        AuditOperator.getInstance().flush(1L);
    }
}

