/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.conf;

import com.google.gson.Gson;
import java.text.ParseException;
import java.util.Objects;
import java.util.TimeZone;
import org.apache.inlong.agent.conf.AbstractConfiguration;
import org.apache.inlong.agent.conf.InstanceProfile;
import org.apache.inlong.agent.pojo.TaskProfileDto;
import org.apache.inlong.agent.utils.AgentUtils;
import org.apache.inlong.agent.utils.DateTransUtils;
import org.apache.inlong.common.enums.InstanceStateEnum;
import org.apache.inlong.common.enums.TaskStateEnum;
import org.apache.inlong.common.enums.TaskTypeEnum;
import org.apache.inlong.common.pojo.agent.DataConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskProfile
extends AbstractConfiguration {
    public static final String SQL_TASK = "org.apache.inlong.agent.plugin.task.logcollection.SQLTask";
    public static final String FILE_TASK = "org.apache.inlong.agent.plugin.task.logcollection.local.FileTask";
    public static final String COS_TASK = "org.apache.inlong.agent.plugin.task.logcollection.cos.COSTask";
    public static final String KAFKA_TASK = "org.apache.inlong.agent.plugin.task.KafkaTask";
    public static final String PULSAR_TASK = "org.apache.inlong.agent.plugin.task.PulsarTask";
    public static final String MONGODB_TASK = "org.apache.inlong.agent.plugin.task.MongoDBTask";
    public static final String ORACLE_TASK = "org.apache.inlong.agent.plugin.task.OracleTask";
    public static final String REDIS_TASK = "org.apache.inlong.agent.plugin.task.RedisTask";
    public static final String POSTGRESQL_TASK = "org.apache.inlong.agent.plugin.task.PostgreSQLTask";
    public static final String MQTT_TASK = "org.apache.inlong.agent.plugin.task.MqttTask";
    public static final String SQLSERVER_TASK = "org.apache.inlong.agent.plugin.task.SQLServerTask";
    public static final String MOCK_TASK = "org.apache.inlong.agent.plugin.task.MockTask";
    private static final Gson GSON = new Gson();
    private static final Logger logger = LoggerFactory.getLogger(TaskProfile.class);

    public static TaskProfile convertToTaskProfile(DataConfig dataConfig) {
        if (dataConfig == null) {
            return null;
        }
        return TaskProfileDto.convertToTaskProfile(dataConfig);
    }

    public String getTaskClass() {
        TaskTypeEnum taskType = TaskTypeEnum.getTaskType((int)this.getInt("task.taskType", TaskTypeEnum.FILE.getType()));
        switch (Objects.requireNonNull(taskType)) {
            case SQL: {
                return SQL_TASK;
            }
            case FILE: {
                return FILE_TASK;
            }
            case KAFKA: {
                return KAFKA_TASK;
            }
            case PULSAR: {
                return PULSAR_TASK;
            }
            case POSTGRES: {
                return POSTGRESQL_TASK;
            }
            case ORACLE: {
                return ORACLE_TASK;
            }
            case SQLSERVER: {
                return SQLSERVER_TASK;
            }
            case MONGODB: {
                return MONGODB_TASK;
            }
            case REDIS: {
                return REDIS_TASK;
            }
            case MQTT: {
                return MQTT_TASK;
            }
            case COS: {
                return COS_TASK;
            }
            case MOCK: {
                return MOCK_TASK;
            }
        }
        logger.error("invalid task type {}", (Object)taskType);
        return null;
    }

    public String getTaskId() {
        return this.get("task.id");
    }

    public String getCycleUnit() {
        return this.get("task.cycleUnit");
    }

    public String getTimeZone() {
        return this.get("task.timeZone");
    }

    public TaskStateEnum getState() {
        return TaskStateEnum.getTaskState((int)this.getInt("task.state"));
    }

    public void setState(TaskStateEnum state) {
        this.setInt("task.state", state.ordinal());
    }

    public boolean isRetry() {
        return this.getBoolean("task.retry", false);
    }

    public String getInlongGroupId() {
        return this.get("proxy.inlongGroupId", "default_inlong_group_id");
    }

    public String getInlongStreamId() {
        return this.get("proxy.inlongStreamId", "default_inlong_stream_id");
    }

    public static TaskProfile parseJsonStr(String jsonStr) {
        TaskProfile conf = new TaskProfile();
        conf.loadJsonStrResource(jsonStr);
        return conf;
    }

    @Override
    public boolean allRequiredKeyExist() {
        return this.hasKey("task.id") && this.hasKey("task.sink") && this.hasKey("task.channel") && this.hasKey("task.groupId") && this.hasKey("task.streamId");
    }

    public String toJsonStr() {
        return GSON.toJson(this.getConfigStorage());
    }

    public InstanceProfile createInstanceProfile(String fileName, String cycleUnit, String dataTime, long fileUpdateTime) {
        InstanceProfile instanceProfile = InstanceProfile.parseJsonStr(this.toJsonStr());
        instanceProfile.setInstanceId(fileName);
        instanceProfile.setSourceDataTime(dataTime);
        Long sinkDataTime = 0L;
        try {
            sinkDataTime = DateTransUtils.timeStrConvertToMillSec(dataTime, cycleUnit, TimeZone.getTimeZone(this.getTimeZone()));
        }
        catch (ParseException e) {
            logger.error("createInstanceProfile ParseException error: ", (Throwable)e);
            return null;
        }
        catch (Exception e) {
            logger.error("createInstanceProfile Exception error: ", (Throwable)e);
            return null;
        }
        instanceProfile.setSinkDataTime(sinkDataTime);
        instanceProfile.setCreateTime(AgentUtils.getCurrentTime());
        instanceProfile.setModifyTime(AgentUtils.getCurrentTime());
        instanceProfile.setState(InstanceStateEnum.DEFAULT);
        instanceProfile.setFileUpdateTime(fileUpdateTime);
        return instanceProfile;
    }
}

