/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.asn1;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1Constructed;
import oracle.security.crypto.asn1.ASN1ConstructedInputStream;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1Header;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1Set;
import oracle.security.crypto.asn1.ASN1TaggedObject;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;
import oracle.security.crypto.util.VectorOverArrayList;

public class ASN1GenericConstructed
implements ASN1Constructed,
ASN1TaggedObject {
    private ArrayList<ASN1Object> a = new ArrayList();
    private int b = 0;
    private ASN1Header c = null;
    private int d;
    private int e;
    private int f = 0;
    private ASN1Object[] g = null;

    public ASN1GenericConstructed(int n) {
        this(n, 128);
    }

    public ASN1GenericConstructed(int n, int n2) {
        this.d = n;
        this.e = n2;
    }

    public ASN1GenericConstructed(ASN1Object aSN1Object, int n) {
        this(aSN1Object, n, 128);
    }

    public ASN1GenericConstructed(ASN1Object aSN1Object, int n, int n2) {
        this(n, n2);
        this.addElement(aSN1Object);
    }

    public ASN1GenericConstructed(Vector<? extends ASN1Object> vector, int n) {
        this(vector, n, 128);
    }

    public ASN1GenericConstructed(Vector<? extends ASN1Object> vector, int n, int n2) {
        this(vector == null ? null : new ArrayList<ASN1Object>(vector), n, n2);
    }

    public ASN1GenericConstructed(List<? extends ASN1Object> list, int n) {
        this(list, n, 128);
    }

    public ASN1GenericConstructed(List<? extends ASN1Object> list, int n, int n2) {
        this(n, n2);
        this.a = list == null ? null : new ArrayList<ASN1Object>(list);
        this.b = 0;
        int n3 = this.a.size();
        for (int i = 0; i < n3; ++i) {
            this.b += this.a.get(i).length();
        }
    }

    public ASN1GenericConstructed(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public ASN1GenericConstructed(byte[] byArray) throws IOException {
        this.input(new UnsyncByteArrayInputStream(byArray));
    }

    @Override
    public ASN1Header getHeader() {
        if (this.c == null) {
            this.c = new ASN1Header(this.d, this.e, 1, this.b);
        }
        return this.c;
    }

    private ASN1Object[] a() {
        if (this.g == null) {
            this.g = ASN1Set.a(this.a, this.f);
        }
        return this.g;
    }

    public int getTag() {
        return this.d;
    }

    public int getTagClass() {
        return this.e;
    }

    @Override
    public Vector<ASN1Object> elements() {
        return this.a == null ? null : new VectorOverArrayList<ASN1Object>(this.a);
    }

    @Override
    public ArrayList<ASN1Object> elementsAsList() {
        return this.a;
    }

    @Override
    public int size() {
        return this.a.size();
    }

    @Override
    public ASN1Object elementAt(int n) {
        return this.a.get(n);
    }

    public ASN1Object firstElement() {
        return this.a.get(0);
    }

    public ASN1Object lastElement() {
        return this.a.get(this.a.size() - 1);
    }

    public void addElement(ASN1Object aSN1Object) {
        this.a.add(aSN1Object);
        this.b += aSN1Object.length();
        this.c = null;
        this.g = null;
    }

    public void setEncodingType(int n) {
        this.f = n;
    }

    public int getEncodingType() {
        return this.f;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("GENERIC CONSTRUCTED [");
        switch (this.e) {
            case 0: {
                stringBuffer.append("UNIVERSAL");
                break;
            }
            case 64: {
                stringBuffer.append("APPLICATION");
                break;
            }
            case 128: {
                stringBuffer.append("CONTEXT SPECIFIC");
                break;
            }
            case 192: {
                stringBuffer.append("PRIVATE");
                break;
            }
            default: {
                stringBuffer.append(this.e);
            }
        }
        stringBuffer.append(' ');
        stringBuffer.append(this.d);
        stringBuffer.append("] ");
        stringBuffer.append(Utils.toString(this.a));
        return stringBuffer.toString();
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        ASN1Header aSN1Header = new ASN1Header(inputStream);
        if (aSN1Header.getEncodingMethod() == 0) {
            throw new ASN1FormatException("Constructed encoding expected.");
        }
        ASN1ConstructedInputStream aSN1ConstructedInputStream = new ASN1ConstructedInputStream(inputStream, aSN1Header);
        this.d = aSN1Header.getTag();
        this.e = aSN1Header.getTagClass();
        this.a = new ArrayList();
        this.b = 0;
        while (aSN1ConstructedInputStream.hasMoreData()) {
            ASN1Object aSN1Object = ASN1Utils.inputASN1Object(aSN1ConstructedInputStream);
            this.a.add(aSN1Object);
            this.b += aSN1Object.length();
        }
        aSN1ConstructedInputStream.terminate();
        this.c = null;
        this.g = null;
    }

    @Override
    public int length() {
        return this.getHeader().totalLength();
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.getHeader().output(outputStream);
        if (this.f == 0) {
            int n = this.a.size();
            for (int i = 0; i < n; ++i) {
                this.a.get(i).output(outputStream);
            }
        } else {
            ASN1Object[] aSN1ObjectArray = this.a();
            int n = aSN1ObjectArray.length;
            for (int i = 0; i < n; ++i) {
                aSN1ObjectArray[i].output(outputStream);
            }
        }
    }

    public static void outputValue(OutputStream outputStream, Vector<? extends ASN1Object> vector, int n) throws IOException {
        ASN1GenericConstructed.outputValue(outputStream, vector, n, 128);
    }

    public static void outputValue(OutputStream outputStream, List<? extends ASN1Object> list, int n) throws IOException {
        ASN1GenericConstructed.outputValue(outputStream, list, n, 128);
    }

    public static void outputValue(OutputStream outputStream, Vector<? extends ASN1Object> vector, int n, int n2) throws IOException {
        ASN1GenericConstructed.outputValue(outputStream, vector, n, n2);
    }

    public static void outputValue(OutputStream outputStream, List<? extends ASN1Object> list, int n, int n2) throws IOException {
        int n3;
        int n4 = 0;
        int n5 = list.size();
        for (n3 = 0; n3 < n5; ++n3) {
            n4 += list.get(n3).length();
        }
        outputStream.write(32 + n2 + n);
        ASN1Utils.outputLengthBytes(outputStream, n4);
        n5 = list.size();
        for (n3 = 0; n3 < n5; ++n3) {
            list.get(n3).output(outputStream);
        }
    }

    static {
        FIPS_140_2.powerUpSelfTest();
    }
}

