/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.nfa;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerConfigSnapshot;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerUtil;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.cep.nfa.DeweyNumber;
import org.apache.flink.cep.nfa.compiler.NFAStateNameHandler;
import org.apache.flink.cep.nfa.sharedbuffer.EventId;
import org.apache.flink.cep.nfa.sharedbuffer.Lockable;
import org.apache.flink.cep.nfa.sharedbuffer.NodeId;
import org.apache.flink.cep.nfa.sharedbuffer.SharedBufferEdge;
import org.apache.flink.cep.nfa.sharedbuffer.SharedBufferNode;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

@Deprecated
public class SharedBuffer<V> {
    private final Map<Tuple2<String, ValueTimeWrapper<V>>, NodeId> mappingContext;
    private Map<Integer, EventId> starters;
    private final Map<EventId, Lockable<V>> eventsBuffer;
    private final Map<NodeId, Lockable<SharedBufferNode>> pages;

    public Map<EventId, Lockable<V>> getEventsBuffer() {
        return this.eventsBuffer;
    }

    public Map<NodeId, Lockable<SharedBufferNode>> getPages() {
        return this.pages;
    }

    public SharedBuffer(Map<EventId, Lockable<V>> eventsBuffer, Map<NodeId, Lockable<SharedBufferNode>> pages, Map<Tuple2<String, ValueTimeWrapper<V>>, NodeId> mappingContext, Map<Integer, EventId> starters) {
        this.eventsBuffer = eventsBuffer;
        this.pages = pages;
        this.mappingContext = mappingContext;
        this.starters = starters;
    }

    public NodeId getNodeId(String prevState, long timestamp, int counter, V event) {
        return this.mappingContext.get(Tuple2.of((Object)NFAStateNameHandler.getOriginalNameFromInternal(prevState), new ValueTimeWrapper<V>(event, timestamp, counter)));
    }

    public EventId getStartEventId(int run) {
        return this.starters.get(run);
    }

    public static class SharedBufferSerializer<K, V>
    extends TypeSerializer<SharedBuffer<V>> {
        private static final long serialVersionUID = -3254176794680331560L;
        private final TypeSerializer<K> keySerializer;
        private final TypeSerializer<V> valueSerializer;
        private final TypeSerializer<DeweyNumber> versionSerializer;

        public SharedBufferSerializer(TypeSerializer<K> keySerializer, TypeSerializer<V> valueSerializer) {
            this(keySerializer, valueSerializer, (TypeSerializer<DeweyNumber>)DeweyNumber.DeweyNumberSerializer.INSTANCE);
        }

        public SharedBufferSerializer(TypeSerializer<K> keySerializer, TypeSerializer<V> valueSerializer, TypeSerializer<DeweyNumber> versionSerializer) {
            this.keySerializer = keySerializer;
            this.valueSerializer = valueSerializer;
            this.versionSerializer = versionSerializer;
        }

        public TypeSerializer<DeweyNumber> getVersionSerializer() {
            return this.versionSerializer;
        }

        public TypeSerializer<K> getKeySerializer() {
            return this.keySerializer;
        }

        public TypeSerializer<V> getValueSerializer() {
            return this.valueSerializer;
        }

        public boolean isImmutableType() {
            return false;
        }

        public SharedBufferSerializer<K, V> duplicate() {
            return new SharedBufferSerializer<K, V>(this.keySerializer.duplicate(), this.valueSerializer.duplicate());
        }

        public SharedBuffer<V> createInstance() {
            throw new UnsupportedOperationException();
        }

        public SharedBuffer<V> copy(SharedBuffer<V> from) {
            throw new UnsupportedOperationException();
        }

        public SharedBuffer<V> copy(SharedBuffer<V> from, SharedBuffer<V> reuse) {
            throw new UnsupportedOperationException();
        }

        public int getLength() {
            return -1;
        }

        public void serialize(SharedBuffer<V> record, DataOutputView target) throws IOException {
            throw new UnsupportedOperationException();
        }

        public SharedBuffer<V> deserialize(DataInputView source) throws IOException {
            ArrayList<Tuple2> entries = new ArrayList<Tuple2>();
            HashMap<ValueTimeWrapper<V>, EventId> values = new HashMap<ValueTimeWrapper<V>, EventId>();
            HashMap<EventId, Lockable<Lockable<Object>>> valuesWithIds = new HashMap<EventId, Lockable<Lockable<Object>>>();
            HashMap<Tuple2<String, ValueTimeWrapper<NodeId>>, NodeId> mappingContext = new HashMap<Tuple2<String, ValueTimeWrapper<NodeId>>, NodeId>();
            HashMap<Long, Integer> totalEventsPerTimestamp = new HashMap<Long, Integer>();
            int totalPages = source.readInt();
            for (int i = 0; i < totalPages; ++i) {
                Object stateName = this.keySerializer.deserialize(source);
                int numberEntries = source.readInt();
                for (int j = 0; j < numberEntries; ++j) {
                    ValueTimeWrapper<V> wrapper = ValueTimeWrapper.deserialize(this.valueSerializer, source);
                    EventId eventId = (EventId)values.get(wrapper);
                    if (eventId == null) {
                        int id = totalEventsPerTimestamp.computeIfAbsent(((ValueTimeWrapper)wrapper).timestamp, k -> 0);
                        eventId = new EventId(id, ((ValueTimeWrapper)wrapper).timestamp);
                        values.put(wrapper, eventId);
                        valuesWithIds.put(eventId, new Lockable<Object>(((ValueTimeWrapper)wrapper).value, 1));
                        totalEventsPerTimestamp.computeIfPresent(((ValueTimeWrapper)wrapper).timestamp, (k, v) -> v + 1);
                    } else {
                        Lockable eventWrapper = (Lockable)valuesWithIds.get(eventId);
                        eventWrapper.lock();
                    }
                    NodeId nodeId = new NodeId(eventId, (String)stateName);
                    int refCount = source.readInt();
                    entries.add(Tuple2.of((Object)nodeId, new Lockable<SharedBufferNode>(new SharedBufferNode(), refCount)));
                    mappingContext.put(Tuple2.of((Object)((String)stateName), wrapper), nodeId);
                }
            }
            int totalEdges = source.readInt();
            HashMap<Integer, EventId> starters = new HashMap<Integer, EventId>();
            for (int j = 0; j < totalEdges; ++j) {
                int sourceIdx = source.readInt();
                int targetIdx = source.readInt();
                DeweyNumber version = (DeweyNumber)this.versionSerializer.deserialize(source);
                Tuple2 sourceEntry = (Tuple2)entries.get(sourceIdx);
                Tuple2 targetEntry = targetIdx < 0 ? Tuple2.of(null, null) : (Tuple2)entries.get(targetIdx);
                ((SharedBufferNode)((Lockable)sourceEntry.f1).getElement()).addEdge(new SharedBufferEdge((NodeId)targetEntry.f0, version));
                if (version.length() != 1) continue;
                starters.put(version.getRun(), ((NodeId)sourceEntry.f0).getEventId());
            }
            Map<NodeId, Lockable<SharedBufferNode>> entriesMap = entries.stream().collect(Collectors.toMap(e -> (NodeId)e.f0, e -> (Lockable)e.f1));
            return new SharedBuffer(valuesWithIds, entriesMap, mappingContext, starters);
        }

        public SharedBuffer<V> deserialize(SharedBuffer<V> reuse, DataInputView source) throws IOException {
            return this.deserialize(source);
        }

        public void copy(DataInputView source, DataOutputView target) throws IOException {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !Objects.equals(obj.getClass(), ((Object)((Object)this)).getClass())) {
                return false;
            }
            SharedBufferSerializer other = (SharedBufferSerializer)((Object)obj);
            return Objects.equals(this.keySerializer, other.getKeySerializer()) && Objects.equals(this.valueSerializer, other.getValueSerializer()) && Objects.equals(this.versionSerializer, other.getVersionSerializer());
        }

        public int hashCode() {
            return 37 * this.keySerializer.hashCode() + this.valueSerializer.hashCode();
        }

        public SharedBufferSerializerSnapshot<K, V> snapshotConfiguration() {
            return new SharedBufferSerializerSnapshot(this);
        }
    }

    public static final class SharedBufferSerializerSnapshot<K, V>
    extends CompositeTypeSerializerSnapshot<SharedBuffer<V>, SharedBufferSerializer<K, V>> {
        private static final int VERSION = 2;

        public SharedBufferSerializerSnapshot() {
            super(SharedBufferSerializer.class);
        }

        public SharedBufferSerializerSnapshot(SharedBufferSerializer<K, V> sharedBufferSerializer) {
            super(sharedBufferSerializer);
        }

        protected int getCurrentOuterSnapshotVersion() {
            return 2;
        }

        protected TypeSerializer<?>[] getNestedSerializers(SharedBufferSerializer<K, V> outerSerializer) {
            return new TypeSerializer[]{((SharedBufferSerializer)outerSerializer).keySerializer, ((SharedBufferSerializer)outerSerializer).valueSerializer, ((SharedBufferSerializer)outerSerializer).versionSerializer};
        }

        protected SharedBufferSerializer<K, V> createOuterSerializerWithNestedSerializers(TypeSerializer<?>[] nestedSerializers) {
            TypeSerializer<?> keySerializer = nestedSerializers[0];
            TypeSerializer<?> valueSerializer = nestedSerializers[1];
            TypeSerializer<?> versionSerializer = nestedSerializers[2];
            return new SharedBufferSerializer(keySerializer, valueSerializer, versionSerializer);
        }
    }

    @Deprecated
    public static final class SharedBufferSerializerConfigSnapshot<K, V>
    extends CompositeTypeSerializerConfigSnapshot<SharedBuffer<V>> {
        private static final int VERSION = 1;

        public SharedBufferSerializerConfigSnapshot() {
        }

        public SharedBufferSerializerConfigSnapshot(TypeSerializer<K> keySerializer, TypeSerializer<V> valueSerializer, TypeSerializer<DeweyNumber> versionSerializer) {
            super(new TypeSerializer[]{keySerializer, valueSerializer, versionSerializer});
        }

        public int getVersion() {
            return 1;
        }

        public TypeSerializerSchemaCompatibility<SharedBuffer<V>> resolveSchemaCompatibility(TypeSerializer<SharedBuffer<V>> newSerializer) {
            return CompositeTypeSerializerUtil.delegateCompatibilityCheckToNewSnapshot(newSerializer, new SharedBufferSerializerSnapshot(), (TypeSerializerSnapshot[])this.getNestedSerializerSnapshots());
        }
    }

    private static class ValueTimeWrapper<V> {
        private final V value;
        private final long timestamp;
        private final int counter;

        ValueTimeWrapper(V value, long timestamp, int counter) {
            this.value = value;
            this.timestamp = timestamp;
            this.counter = counter;
        }

        public int getCounter() {
            return this.counter;
        }

        public V getValue() {
            return this.value;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public String toString() {
            return "ValueTimeWrapper(" + this.value + ", " + this.timestamp + ", " + this.counter + ")";
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ValueTimeWrapper)) {
                return false;
            }
            ValueTimeWrapper other = (ValueTimeWrapper)obj;
            return this.timestamp == other.getTimestamp() && Objects.equals(this.value, other.getValue()) && this.counter == other.getCounter();
        }

        public int hashCode() {
            return (int)(31L * (31L * (this.timestamp ^ this.timestamp >>> 32) + (long)this.value.hashCode()) + (long)this.counter);
        }

        public static <V> ValueTimeWrapper<V> deserialize(TypeSerializer<V> valueSerializer, DataInputView source) throws IOException {
            Object value = valueSerializer.deserialize(source);
            long timestamp = source.readLong();
            int counter = source.readInt();
            return new ValueTimeWrapper<Object>(value, timestamp, counter);
        }
    }
}

