/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.commons.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GzipUtils {
    public static final Logger LOG = LoggerFactory.getLogger(GzipUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compress(byte[] data) {
        if (data == null || data.length == 0) {
            return data;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GZIPOutputStream gzip = null;
        try {
            gzip = new GZIPOutputStream(out);
            gzip.write(data);
        }
        catch (IOException e) {
            LOG.error("compress data error", (Throwable)e);
        }
        finally {
            if (gzip != null) {
                try {
                    gzip.close();
                }
                catch (IOException e) {
                    LOG.error(GzipUtils.class.getSimpleName(), (Throwable)e);
                }
            }
        }
        return out.toByteArray();
    }

    public static byte[] decompress(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        try {
            int n;
            GZIPInputStream ungzip = new GZIPInputStream(in);
            byte[] buffer = new byte[256];
            while ((n = ungzip.read(buffer)) >= 0) {
                out.write(buffer, 0, n);
            }
        }
        catch (IOException e) {
            LOG.error("Decompress data error", (Throwable)e);
        }
        return out.toByteArray();
    }
}

