/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.rpsl;

import com.google.common.base.Preconditions;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.ripe.ipresource.IpRange;

public record RpslObject(List<RpslAttribute> attributes) {
    public RpslObject {
        Preconditions.checkNotNull(attributes);
        Preconditions.checkArgument((!attributes.isEmpty() ? 1 : 0) != 0);
    }

    public String type() {
        return this.attributes.get(0).name();
    }

    public String id() {
        return this.attributes.get(0).value();
    }

    public Optional<String> first(String name) {
        return this.attributes.stream().filter(attribute -> attribute.name().equals(name)).map(RpslAttribute::value).findFirst();
    }

    public List<String> all(String name) {
        return this.attributes.stream().filter(attribute -> attribute.name().equals(name)).map(RpslAttribute::value).toList();
    }

    public Map<String, List<String>> asMap() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (RpslAttribute attribute : this.attributes()) {
            List list = map.getOrDefault(attribute.name(), new ArrayList());
            list.add(attribute.value());
            map.put(attribute.name(), list);
        }
        return map;
    }

    public Optional<IpRange> inetnum() {
        return this.first("inetnum").map(IpRange::parse);
    }

    public Optional<IpRange> inet6num() {
        return this.first("inet6num").map(IpRange::parse);
    }

    public List<RpslChanged> changed() {
        return this.all("changed").stream().map(RpslChanged::parse).collect(Collectors.toList());
    }

    public Optional<LocalDateTime> created() {
        return this.first("created").map(this::parseDateTime);
    }

    public Optional<LocalDateTime> lastModified() {
        return this.first("last-modified").map(this::parseDateTime);
    }

    private LocalDateTime parseDateTime(String dateTimeStr) {
        try {
            return LocalDateTime.parse(dateTimeStr, DateTimeFormatter.ISO_DATE_TIME);
        }
        catch (DateTimeParseException e) {
            throw new IllegalArgumentException("Invalid date time format: " + dateTimeStr, e);
        }
    }

    public Optional<String> status() {
        return this.first("status");
    }

    public Optional<String> netname() {
        return this.first("netname");
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (RpslAttribute attribute : this.attributes()) {
            stringBuilder.append(attribute.name()).append(": ").append(attribute.value()).append("\n");
        }
        return stringBuilder.toString();
    }

    public record RpslAttribute(String name, String value) {
    }

    public record RpslChanged(String email, LocalDate date) {
        public static RpslChanged parse(String s) {
            LocalDate date;
            String[] parts = s.trim().split("\\s+");
            if (parts.length != 2) {
                throw new IllegalArgumentException("Invalid changed format: " + s);
            }
            String email = parts[0];
            String dateStr = parts[1];
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
            try {
                date = LocalDate.parse(dateStr, formatter);
            }
            catch (DateTimeParseException e) {
                throw new IllegalArgumentException("Invalid date format in changed: " + dateStr, e);
            }
            return new RpslChanged(email, date);
        }
    }
}

